package dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.compat;

import com.google.auto.service.AutoService;
import com.google.gson.JsonElement;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.dynamicassetgenerator.api.compat.ConditionalInvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.api.compat.InvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.api.templates.TagFile;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.FabriQuiltShared;
import io.wispforest.owo.util.TagInjector;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

@AutoService(ConditionalInvisibleResourceProvider.class)
@SuppressWarnings("unused")
public class OwoLibProviderWrapper implements ConditionalInvisibleResourceProvider {

    @Override
    public boolean isAvailable() {
        return FabriQuiltShared.getInstance().isModLoaded("owo");
    }

    @Override
    public InvisibleResourceProvider get() {
        return new OwoLibProvider();
    }

    public static class OwoLibProvider implements InvisibleResourceProvider {
        private static @Nullable Map<class_2960, String> tagMap;

        @Override
        public class_7367<InputStream> getResource(@NonNull class_3264 type, @NonNull class_2960 location) {
            if (type == class_3264.field_14190) {
                checkMap();
                if (tagMap.containsKey(location))
                    return () -> new ByteArrayInputStream(tagMap.get(location).getBytes());
            }
            return null;
        }

        @Override
        public void listResources(@NonNull class_3264 type, @NonNull String namespace, @NonNull String path, class_3262.@NonNull class_7664 resourceOutput) {
            if (type == class_3264.field_14190) {
                checkMap();
                tagMap.keySet().stream()
                        .filter(location -> location.method_12836().equals(namespace) && location.method_12832().startsWith(path))
                        .forEach(rl -> resourceOutput.accept(rl, this.getResource(type, rl)));
            }
        }

        @Override
        public Set<String> getNamespaces(@NonNull class_3264 type) {
            if (type == class_3264.field_14190) {
                checkMap();
                return tagMap.keySet().stream().map(class_2960::method_12836).collect(Collectors.toSet());
            }
            else return Set.of();
        }

        @Override
        public void reset(@NonNull class_3264 type) {
            if (type == class_3264.field_14190)
                tagMap = null;
        }

        private void checkMap() {
            if (tagMap == null) {
                synchronized (this) {
                    if (tagMap != null) return;
                    tagMap = new HashMap<>();
                    TagInjector.getInjections().forEach((key, values) -> {
                        var tag = new TagFile(new ArrayList<>(values), false);
                        JsonElement encoded;
                        try {
                            encoded =
                                    TagFile.CODEC.encodeStart(JsonOps.INSTANCE, tag).getOrThrow(RuntimeException::new);
                        } catch (RuntimeException e) {
                            DynamicAssetGenerator.LOGGER.error("Error encoding tag file from OwoLib entries: " + e.getMessage());
                            return;
                        }
                        tagMap.put(new class_2960(key.tagId().method_12836(), "tags/" + key.type() + "/" + key.tagId().method_12832() + ".json"),
                                DynamicAssetGenerator.GSON.toJson(encoded));
                    });
                }
            }
        }
    }
}
