package dev.lukebemish.dynamicassetgenerator.impl.client;

import com.mojang.datafixers.util.Either;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.cache.CacheMetaJsonOps;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.impl.CacheReference;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import org.jspecify.annotations.NonNull;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_7367;

public final class TexSourceCache {
    private TexSourceCache() {
    }

    private static final Map<class_2960, Map<String, CacheReference<Either<class_1011, IOException>>>> MULTI_CACHE = new ConcurrentHashMap<>();

    @NonNull
    public static class_1011 fromCache(class_7367<class_1011> supplier, TexSource source, ResourceGenerationContext context, TexSourceDataHolder data) throws IOException {
        var cache = MULTI_CACHE.computeIfAbsent(context.getCacheName(), k -> new ConcurrentHashMap<>());
        try {
            var dataOps = new CacheMetaJsonOps();
            dataOps.putData(TexSourceDataHolder.class, data);
            String cacheKey = TexSource.CODEC.encodeStart(dataOps, source).result().map(DynamicAssetGenerator.GSON_FLAT::toJson).orElse(null);
            if (cacheKey == null) {
                return supplier.get();
            }
            CacheReference<Either<class_1011, IOException>> ref;
            if (cache.containsKey(cacheKey))
                ref = cache.get(cacheKey);
            else
                ref = new CacheReference<>();
            var result = ref.calcSync(cached -> {
                if (cached == null) {
                    try {
                        class_1011 image = supplier.get();
                        ref.setHeld(Either.left(image));
                        class_1011 output = NativeImageHelper.of(image.method_4318(), image.method_4307(), image.method_4323(), false);
                        output.method_4317(image);
                        return Either.left(output);
                    } catch (IOException e) {
                        ref.setHeld(Either.right(e));
                        return Either.right(e);
                    }
                } else if (cached.left().isPresent()) {
                    class_1011 image = cached.left().get();
                    class_1011 output = NativeImageHelper.of(image.method_4318(), image.method_4307(), image.method_4323(), false);
                    output.method_4317(image);
                    return Either.left(output);
                } else {
                    return Either.right(cached.right().get());
                }
            });

            if (!cache.containsKey(cacheKey))
                cache.put(cacheKey, ref);

            if (result.left().isPresent()) {
                return result.left().get();
            } else {
                throw result.right().get();
            }
        } catch (RuntimeException e) {
            DynamicAssetGenerator.LOGGER.warn("Could not cache texture source; something has gone wrong with encoding or texture creation.", e);
            return supplier.get();
        }
    }

    public static void reset(ResourceGenerationContext context) {
        synchronized (MULTI_CACHE) {
            Map<String, CacheReference<Either<class_1011, IOException>>> cache;
            if ((cache = MULTI_CACHE.get(context.getCacheName())) != null) {
                cache.forEach((s, e) -> {
                    if (e.getHeld().left().isPresent()) {
                        e.getHeld().left().get().close();
                    }
                });
                MULTI_CACHE.remove(context.getCacheName());
            }
        }
    }

}
