/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.client;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.SpriteProvider;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import org.jspecify.annotations.Nullable;

public record BuiltinSpriteProvider(Map<ResourceLocation, TexSource> sources, @Nullable ResourceLocation location) implements SpriteProvider<BuiltinSpriteProvider>
{
    public static final ResourceLocation LOCATION = new ResourceLocation("dynamic_asset_generator", "tex_sources");
    public static final MapCodec<BuiltinSpriteProvider> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, TexSource.CODEC).fieldOf("sources").forGetter(BuiltinSpriteProvider::sources), (App)ResourceLocation.CODEC.optionalFieldOf("location").forGetter(s -> Optional.ofNullable(s.location()))).apply((Applicative)i, (sources, location) -> new BuiltinSpriteProvider((Map<ResourceLocation, TexSource>)sources, location.orElse(null))));

    @Override
    public Map<ResourceLocation, TexSource> getSources(ResourceGenerationContext context) {
        HashMap<ResourceLocation, TexSource> outSources = new HashMap<ResourceLocation, TexSource>(this.sources());
        if (this.location != null) {
            FileToIdConverter converter = new FileToIdConverter(this.location.getNamespace() + "/" + this.location.getPath(), ".json");
            context.getResourceSource().listResources(this.location.getNamespace() + "/" + this.location.getPath(), rl -> rl.getPath().endsWith(".json")).forEach((fileRl, resource) -> {
                ResourceLocation rl = converter.fileToId(fileRl);
                try (InputStreamReader reader = new InputStreamReader((InputStream)resource.get());){
                    JsonElement json = (JsonElement)DynamicAssetGenerator.GSON.fromJson((Reader)reader, JsonElement.class);
                    DataResult result = TexSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    result.result().ifPresent(texSource -> outSources.put(rl, (TexSource)texSource));
                    result.error().ifPresent(partial -> DynamicAssetGenerator.LOGGER.error("Failed to load tex source json for " + String.valueOf(this.location) + ": " + String.valueOf(rl) + ": " + partial.message()));
                }
                catch (IOException e) {
                    DynamicAssetGenerator.LOGGER.error("Failed to load tex source json for " + String.valueOf(this.location) + ": " + String.valueOf(rl), (Throwable)e);
                }
            });
        }
        return outSources;
    }

    @Override
    public ResourceLocation getLocation() {
        return LOCATION;
    }
}

