/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import java.util.Objects;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class TransformSource
implements TexSource {
    private static final int DEFAULT_ROTATE = 0;
    private static final boolean DEFAULT_FLIP = false;
    public static final MapCodec<TransformSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TexSource.CODEC.fieldOf("input").forGetter(TransformSource::getInput), (App)Codec.INT.optionalFieldOf("rotate", (Object)0).forGetter(TransformSource::getRotate), (App)Codec.BOOL.optionalFieldOf("flip", (Object)false).forGetter(TransformSource::isFlip)).apply((Applicative)instance, TransformSource::new));
    private final TexSource input;
    private final int rotate;
    private final boolean flip;

    private TransformSource(TexSource input, int rotate, boolean flip) {
        this.input = input;
        this.rotate = rotate;
        this.flip = flip;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable IoSupplier<NativeImage> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        IoSupplier<NativeImage> input = this.getInput().getCachedSupplier(data, context);
        if (input == null) {
            data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.getInput());
            return null;
        }
        return () -> {
            NativeImage output = (NativeImage)input.get();
            for (int i = 0; i < this.getRotate(); ++i) {
                output = TransformSource.clockwiseRotate(output);
            }
            if (this.isFlip()) {
                NativeImage output2 = NativeImageHelper.of(output.format(), output.getWidth(), output.getHeight(), false);
                for (int x = 0; x < output.getWidth(); ++x) {
                    for (int y = 0; y < output.getHeight(); ++y) {
                        output2.setPixelRGBA(output.getWidth() - 1 - x, y, ImageUtils.safeGetPixelABGR(output, x, y));
                    }
                }
                output.close();
                output = output2;
            }
            return output;
        };
    }

    private static NativeImage clockwiseRotate(NativeImage input) {
        int w = input.getWidth();
        int h = input.getHeight();
        NativeImage output = NativeImageHelper.of(input.format(), h, w, false);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                output.setPixelRGBA(y, w - x - 1, ImageUtils.safeGetPixelABGR(input, x, y));
            }
        }
        input.close();
        return output;
    }

    public TexSource getInput() {
        return this.input;
    }

    public int getRotate() {
        return this.rotate;
    }

    public boolean isFlip() {
        return this.flip;
    }

    public static class Builder {
        private TexSource input;
        private int rotate = 0;
        private boolean flip = false;

        public Builder setInput(TexSource input) {
            this.input = input;
            return this;
        }

        public Builder setRotate(int rotate) {
            this.rotate = rotate;
            return this;
        }

        public Builder setFlip(boolean flip) {
            this.flip = flip;
            return this;
        }

        public TransformSource build() {
            Objects.requireNonNull(this.input);
            return new TransformSource(this.input, this.rotate, this.flip);
        }
    }
}

