/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import dev.lukebemish.dynamicassetgenerator.impl.EmptyResourceSource;
import dev.lukebemish.dynamicassetgenerator.impl.ResourceFinder;
import dev.lukebemish.dynamicassetgenerator.impl.platform.Services;
import dev.lukebemish.dynamicassetgenerator.impl.util.InvisibleProviderUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ResourceGenerationContext {
    public @NonNull ResourceLocation getCacheName();

    default public ResourceSource getResourceSource() {
        return EmptyResourceSource.INSTANCE;
    }

    @ApiStatus.NonExtendable
    default public ResourceGenerationContext withResourceSource(final ResourceSource source) {
        final ResourceGenerationContext outer = this;
        return new ResourceGenerationContext(){

            @Override
            public @NonNull ResourceLocation getCacheName() {
                return outer.getCacheName();
            }

            @Override
            public ResourceSource getResourceSource() {
                return source;
            }
        };
    }

    public static interface ResourceSource {
        public static ResourceSource blind() {
            return EmptyResourceSource.INSTANCE;
        }

        public @Nullable IoSupplier<InputStream> getResource(@NonNull ResourceLocation var1);

        public List<IoSupplier<InputStream>> getResourceStack(@NonNull ResourceLocation var1);

        public Map<ResourceLocation, IoSupplier<InputStream>> listResources(@NonNull String var1, @NonNull Predicate<ResourceLocation> var2);

        public Map<ResourceLocation, List<IoSupplier<InputStream>>> listResourceStacks(@NonNull String var1, @NonNull Predicate<ResourceLocation> var2);

        public @NonNull Set<String> getNamespaces();

        public static ResourceSource filtered(Predicate<String> allowedPacks, PackType type) {
            int ordinal = type.ordinal();
            java.util.function.Supplier<Stream<PackResources>> packs = () -> ResourceFinder.INSTANCES[ordinal].getPacks().filter(pack -> allowedPacks.test(pack.packId()));
            return ResourceSource.of(type, packs);
        }

        public static ResourceSource filtered(Predicate<String> allowedPacks, PackType type, java.util.function.Supplier<Stream<PackResources>> packResources) {
            java.util.function.Supplier<Stream<PackResources>> packs = () -> ((Stream)packResources.get()).filter(pack -> allowedPacks.test(pack.packId()));
            return ResourceSource.of(type, packs);
        }

        default public ResourceSource fallback(final ResourceSource fallback) {
            final ResourceSource outer = this;
            return new ResourceSource(){

                @Override
                public @Nullable IoSupplier<InputStream> getResource(@NonNull ResourceLocation location) {
                    IoSupplier<InputStream> supplier = outer.getResource(location);
                    return supplier != null ? supplier : fallback.getResource(location);
                }

                @Override
                public List<IoSupplier<InputStream>> getResourceStack(@NonNull ResourceLocation location) {
                    List<IoSupplier<InputStream>> list = outer.getResourceStack(location);
                    if (list.isEmpty()) {
                        return fallback.getResourceStack(location);
                    }
                    return list;
                }

                @Override
                public Map<ResourceLocation, IoSupplier<InputStream>> listResources(@NonNull String path, @NonNull Predicate<ResourceLocation> filter) {
                    HashMap<ResourceLocation, IoSupplier<InputStream>> map = new HashMap<ResourceLocation, IoSupplier<InputStream>>(fallback.listResources(path, filter));
                    map.putAll(outer.listResources(path, filter));
                    return map;
                }

                @Override
                public Map<ResourceLocation, List<IoSupplier<InputStream>>> listResourceStacks(@NonNull String path, @NonNull Predicate<ResourceLocation> filter) {
                    HashMap<ResourceLocation, List<IoSupplier<InputStream>>> map = new HashMap<ResourceLocation, List<IoSupplier<InputStream>>>(fallback.listResourceStacks(path, filter));
                    outer.listResourceStacks(path, filter).forEach((rl, list) -> {
                        if (!list.isEmpty()) {
                            map.put((ResourceLocation)rl, (List<IoSupplier<InputStream>>)list);
                        }
                    });
                    return map;
                }

                @Override
                public @NonNull Set<String> getNamespaces() {
                    HashSet<String> set = new HashSet<String>(fallback.getNamespaces());
                    set.addAll(outer.getNamespaces());
                    return set;
                }
            };
        }

        public static ResourceSource of(PackType type, java.util.function.Supplier<Stream<PackResources>> resources) {
            Supplier packs = Suppliers.memoize(() -> Services.DEGROUPER.unpackPacks(Stream.concat((Stream)resources.get(), InvisibleProviderUtils.INVISIBLE_RESOURCE_PROVIDERS.stream().map(InvisibleProviderUtils::constructPlaceholderResourcesFromProvider))).toList());
            return new ResourceSource(){
                final /* synthetic */ java.util.function.Supplier val$packs;
                final /* synthetic */ PackType val$type;
                {
                    this.val$packs = supplier;
                    this.val$type = packType;
                }

                @Override
                public @Nullable IoSupplier<InputStream> getResource(@NonNull ResourceLocation location) {
                    IoSupplier found = null;
                    for (PackResources pack : (List)this.val$packs.get()) {
                        IoSupplier resource = pack.getResource(this.val$type, location);
                        if (resource == null) continue;
                        found = resource;
                    }
                    return found;
                }

                @Override
                public List<IoSupplier<InputStream>> getResourceStack(@NonNull ResourceLocation location) {
                    ArrayList<IoSupplier<InputStream>> out = new ArrayList<IoSupplier<InputStream>>();
                    for (PackResources pack : (List)this.val$packs.get()) {
                        IoSupplier resource = pack.getResource(this.val$type, location);
                        if (resource == null) continue;
                        out.add((IoSupplier<InputStream>)resource);
                    }
                    Collections.reverse(out);
                    return out;
                }

                @Override
                public Map<ResourceLocation, IoSupplier<InputStream>> listResources(@NonNull String path, @NonNull Predicate<ResourceLocation> filter) {
                    HashMap<ResourceLocation, IoSupplier<InputStream>> resources = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
                    for (PackResources pack : (List)this.val$packs.get()) {
                        for (String namespace : pack.getNamespaces(this.val$type)) {
                            pack.listResources(this.val$type, namespace, path, (rl, s) -> {
                                if (filter.test((ResourceLocation)rl)) {
                                    resources.put((ResourceLocation)rl, (IoSupplier<InputStream>)s);
                                }
                            });
                        }
                    }
                    return resources;
                }

                @Override
                public Map<ResourceLocation, List<IoSupplier<InputStream>>> listResourceStacks(@NonNull String path, @NonNull Predicate<ResourceLocation> filter) {
                    HashMap<ResourceLocation, List<IoSupplier<InputStream>>> resources = new HashMap<ResourceLocation, List<IoSupplier<InputStream>>>();
                    for (PackResources pack : (List)this.val$packs.get()) {
                        for (String namespace : pack.getNamespaces(this.val$type)) {
                            pack.listResources(this.val$type, namespace, path, (rl, s) -> {
                                if (filter.test((ResourceLocation)rl)) {
                                    List list = resources.computeIfAbsent((ResourceLocation)rl, location -> new ArrayList());
                                    list.add(s);
                                }
                            });
                        }
                    }
                    for (List list : resources.values()) {
                        Collections.reverse(list);
                    }
                    return resources;
                }

                @Override
                public @NonNull Set<String> getNamespaces() {
                    HashSet<String> namespaces = new HashSet<String>();
                    for (PackResources pack : (List)this.val$packs.get()) {
                        namespaces.addAll(pack.getNamespaces(this.val$type));
                    }
                    return namespaces;
                }
            };
        }
    }
}

