/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api;

import dev.lukebemish.dynamicassetgenerator.api.InputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.Resettable;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.Timing;
import dev.lukebemish.dynamicassetgenerator.impl.util.ResourceUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class ResourceCache {
    protected final List<Supplier<? extends PathAwareInputStreamSource>> cache = new ArrayList<Supplier<? extends PathAwareInputStreamSource>>();
    private final List<Resettable> resetListeners = new ArrayList<Resettable>();
    private final ResourceLocation name;
    private @Nullable ResourceGenerationContext.ResourceSource filteredSource = null;

    public static <T extends ResourceCache> T register(T cache, Pack.Position position) {
        DynamicAssetGenerator.registerCache(cache.getName(), cache, position);
        return cache;
    }

    public Set<ResourceLocation> getDependencies() {
        return Set.of();
    }

    public final boolean allowAccess(String packId) {
        String prefix = "dynamic_asset_generator/";
        if (!packId.startsWith(prefix)) {
            return true;
        }
        String remainder = packId.substring(prefix.length());
        ResourceLocation targetName = ResourceLocation.read((String)remainder).result().orElse(null);
        return targetName == null || this.getDependencies().contains(targetName);
    }

    public static <T extends ResourceCache> T register(T cache) {
        return ResourceCache.register(cache, Pack.Position.BOTTOM);
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public ResourceCache(ResourceLocation name) {
        this.name = name;
    }

    public Map<ResourceLocation, IoSupplier<InputStream>> getResources() {
        HashMap<ResourceLocation, IoSupplier<InputStream>> outputs = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
        this.cache.forEach(p -> {
            try {
                PathAwareInputStreamSource source = (PathAwareInputStreamSource)p.get();
                Set<ResourceLocation> rls = source.getLocations(this.makeContext(false));
                if (DynamicAssetGenerator.TIME_RESOURCES) {
                    rls.forEach(rl -> {
                        long startTime = System.nanoTime();
                        IoSupplier<InputStream> supplier = ResourceUtils.wrapSafeData(rl, source, this.makeContext(false));
                        if (supplier != null) {
                            outputs.put((ResourceLocation)rl, supplier);
                        }
                        long endTime = System.nanoTime();
                        long duration = (endTime - startTime) / 1000L;
                        Timing.recordPartialTime(this.getName().toString(), rl, duration);
                    });
                } else {
                    rls.forEach(rl -> {
                        IoSupplier<InputStream> supplier = ResourceUtils.wrapSafeData(rl, source, this.makeContext(false));
                        if (supplier != null) {
                            outputs.put((ResourceLocation)rl, supplier);
                        }
                    });
                }
            }
            catch (Throwable e) {
                DynamicAssetGenerator.LOGGER.error("Issue setting up PathAwareInputStreamSource:", e);
            }
        });
        return outputs;
    }

    public @NonNull ResourceGenerationContext makeContext(final boolean blind) {
        return new ResourceGenerationContext(){

            @Override
            public @NonNull ResourceLocation getCacheName() {
                return ResourceCache.this.getName();
            }

            @Override
            public ResourceGenerationContext.ResourceSource getResourceSource() {
                if (blind || ResourceCache.this.filteredSource == null) {
                    return ResourceGenerationContext.ResourceSource.blind();
                }
                return ResourceCache.this.filteredSource;
            }
        };
    }

    public void planResetListener(Resettable listener) {
        this.resetListeners.add(listener);
    }

    public void reset(ResourceGenerationContext context) {
        this.resetListeners.forEach(r -> r.reset(context));
        this.filteredSource = ResourceGenerationContext.ResourceSource.filtered(this::allowAccess, this.getPackType());
    }

    public void planSource(ResourceLocation rl, InputStreamSource source) {
        this.cache.add(ResourceCache.wrap(() -> Set.of(rl), source));
    }

    public void planSource(Supplier<Set<ResourceLocation>> locations, InputStreamSource source) {
        this.cache.add(ResourceCache.wrap(locations, source));
    }

    public void planSource(Set<ResourceLocation> locations, InputStreamSource source) {
        this.cache.add(ResourceCache.wrap(() -> locations, source));
    }

    public void planSource(PathAwareInputStreamSource source) {
        this.cache.add(() -> source);
        if (source instanceof Resettable) {
            Resettable resettable = (Resettable)((Object)source);
            this.planResetListener(resettable);
        }
    }

    public void planSource(Supplier<? extends PathAwareInputStreamSource> source) {
        this.cache.add(source);
    }

    public abstract @NonNull PackType getPackType();

    private static Supplier<PathAwareInputStreamSource> wrap(final Supplier<Set<ResourceLocation>> rls, final InputStreamSource source) {
        return () -> new PathAwareInputStreamSource(){

            @Override
            public @NonNull Set<ResourceLocation> getLocations(ResourceGenerationContext context) {
                return (Set)rls.get();
            }

            @Override
            public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
                return source.get(outRl, context);
            }

            @Override
            public @Nullable String createCacheKey(ResourceLocation outRl, ResourceGenerationContext context) {
                return source.createCacheKey(outRl, context);
            }
        };
    }
}

