/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.sources;

import dev.lukebemish.dynamicassetgenerator.api.PathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.Resettable;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface TagSupplier
extends Function<ResourceGenerationContext, Map<ResourceLocation, Set<ResourceLocation>>>,
Resettable {
    default public @Nullable String createSupplierCacheKey(ResourceLocation outRl, ResourceGenerationContext context) {
        return null;
    }

    @Override
    default public void reset(ResourceGenerationContext context) {
    }

    public static class TagBakery
    implements PathAwareInputStreamSource,
    Resettable,
    TagSupplier {
        private Map<ResourceLocation, Set<ResourceLocation>> bakedTags;
        private final List<TagSupplier> tagQueue;
        private final Map<ResourceLocation, Set<ResourceLocation>> staticQueue = new HashMap<ResourceLocation, Set<ResourceLocation>>();

        public TagBakery() {
            this.tagQueue = new ArrayList<TagSupplier>();
            this.tagQueue.add(new TagSupplier(){

                @Override
                public Map<ResourceLocation, Set<ResourceLocation>> apply(ResourceGenerationContext context) {
                    return staticQueue;
                }

                @Override
                public String createSupplierCacheKey(ResourceLocation outRl, ResourceGenerationContext context) {
                    return "STATIC_QUEUE";
                }
            });
        }

        public void queue(TagSupplier tagSupplier) {
            this.tagQueue.add(tagSupplier);
        }

        public void queue(ResourceLocation tag, Set<ResourceLocation> entries) {
            this.staticQueue.computeIfAbsent(tag, k -> new HashSet()).addAll(entries);
        }

        public void queue(ResourceLocation tag, ResourceLocation entry) {
            this.staticQueue.computeIfAbsent(tag, k -> new HashSet()).add(entry);
        }

        public void queue(Map<ResourceLocation, Set<ResourceLocation>> tags) {
            tags.forEach((tag, entries) -> this.staticQueue.computeIfAbsent((ResourceLocation)tag, k -> new HashSet()).addAll(entries));
        }

        @Override
        public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
            if (!outRl.getPath().startsWith("tags/") || !outRl.getPath().endsWith(".json")) {
                return null;
            }
            return () -> {
                this.checkTags(context);
                ResourceLocation tagRl = new ResourceLocation(outRl.getNamespace(), outRl.getPath().substring(5, outRl.getPath().length() - 5));
                return this.build(this.bakedTags.get(tagRl));
            };
        }

        private InputStream build(Set<ResourceLocation> paths) {
            StringBuilder internal = new StringBuilder();
            ArrayList<ResourceLocation> toAdd = new ArrayList<ResourceLocation>(paths);
            toAdd.forEach(rl -> {
                if (!internal.isEmpty()) {
                    internal.append(",\n");
                }
                internal.append("\"").append(rl.getNamespace()).append(":").append(rl.getPath()).append("\"");
            });
            String json = "{\n\"replace\":false,\n\"values\":[" + String.valueOf(internal) + "\n]}";
            return new ByteArrayInputStream(json.getBytes());
        }

        @Override
        public @NonNull Set<ResourceLocation> getLocations(ResourceGenerationContext context) {
            this.checkTags(context);
            return this.bakedTags.keySet().stream().map(rl -> rl.withPrefix("tags/").withSuffix(".json")).collect(Collectors.toSet());
        }

        @Override
        public void reset(ResourceGenerationContext context) {
            this.bakedTags = null;
            for (TagSupplier tagSupplier : this.tagQueue) {
                tagSupplier.reset(context);
            }
        }

        private synchronized void checkTags(ResourceGenerationContext context) {
            if (this.bakedTags == null) {
                this.bakedTags = new HashMap<ResourceLocation, Set<ResourceLocation>>();
                this.tagQueue.forEach(function -> {
                    Map map = (Map)function.apply(context);
                    map.forEach((tag, set) -> {
                        Set entrySet = this.bakedTags.computeIfAbsent((ResourceLocation)tag, k -> new HashSet());
                        entrySet.addAll(set);
                    });
                });
            }
        }

        @Override
        public Map<ResourceLocation, Set<ResourceLocation>> apply(ResourceGenerationContext context) {
            this.checkTags(context);
            return this.bakedTags;
        }

        @Override
        public @Nullable String createCacheKey(ResourceLocation outRl, ResourceGenerationContext context) {
            StringBuilder builder = new StringBuilder();
            for (TagSupplier tagSupplier : this.tagQueue) {
                String key = tagSupplier.createSupplierCacheKey(outRl, context);
                if (key == null) {
                    return null;
                }
                builder.append(Base64.getEncoder().encodeToString(key.getBytes(StandardCharsets.UTF_8)));
                builder.append('\n');
            }
            for (Map.Entry entry : this.staticQueue.entrySet()) {
                builder.append(entry.getKey());
                builder.append("[");
                for (ResourceLocation rl : (Set)entry.getValue()) {
                    builder.append(rl);
                    builder.append(',');
                }
                builder.append("]\n");
            }
            return builder.substring(0, builder.length() - 1);
        }

        @Override
        public @Nullable String createSupplierCacheKey(ResourceLocation outRl, ResourceGenerationContext context) {
            return this.createCacheKey(outRl, context);
        }
    }
}

