/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors;

import com.mojang.datafixers.util.Pair;
import dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes;
import dev.lukebemish.dynamicassetgenerator.api.colors.geometry.ColorCoordinates;
import dev.lukebemish.dynamicassetgenerator.api.colors.geometry.LineSegment;
import dev.lukebemish.dynamicassetgenerator.api.util.FuzzySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.util.FastColor;
import org.jspecify.annotations.NonNull;

public class Palette
implements Collection<Integer> {
    private final Set<Integer> backing;
    private List<Integer> colors;
    private List<LineSegment> lines;
    private final double cutoff;
    private int extendedLow = 0;
    private int extendedHigh = 0;
    public static final double DEFAULT_CUTOFF = 3.5;
    private static final int MAX_WIDTH = (int)Math.floor(ColorTypes.ARGB32.distance(0, 0xFFFFFF));
    private static final Comparator<Integer> COMPARATOR = Comparator.comparingInt(i -> FastColor.ARGB32.red((int)i) + FastColor.ARGB32.green((int)i) + FastColor.ARGB32.blue((int)i));

    public Palette() {
        this(3.5);
    }

    public Palette(double cutoff) {
        this.cutoff = cutoff;
        this.backing = new FuzzySet<Integer>((i1, i2) -> ColorTypes.ARGB32.distance((int)i1, (int)i2) < cutoff, colors -> {
            int r = 0;
            int g = 0;
            int b = 0;
            for (Integer color : colors) {
                r += FastColor.ARGB32.red((int)color);
                g += FastColor.ARGB32.green((int)color);
                b += FastColor.ARGB32.blue((int)color);
            }
            return FastColor.ARGB32.color((int)255, (int)(r / colors.size()), (int)(g / colors.size()), (int)(b / colors.size()));
        });
        this.updateList();
    }

    public static Palette fromColors(Collection<Integer> colors, double cutoff) {
        Palette palette = new Palette(cutoff);
        palette.addAll((Collection<? extends Integer>)colors);
        return palette;
    }

    public static Palette fromPalette(Palette palette, double cutoff) {
        Palette newPalette = new Palette(cutoff);
        newPalette.addAll(palette);
        return newPalette;
    }

    public static Palette fromPalette(Palette palette) {
        return Palette.fromPalette(palette, palette.getCutoff());
    }

    public double getCutoff() {
        return this.cutoff;
    }

    @Override
    public boolean add(Integer color) {
        return this.add((int)color);
    }

    @Override
    public boolean add(int color) {
        boolean mutated = this.backing.add(color |= 0xFF000000);
        if (mutated) {
            this.updateList();
        }
        return mutated;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> colors) {
        boolean mutated = this.backing.addAll(colors.stream().map(i -> i | 0xFF000000).toList());
        if (mutated) {
            this.updateList();
        }
        return mutated;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> collection) {
        boolean mutated = this.backing.removeAll(collection);
        if (mutated) {
            this.updateList();
        }
        return mutated;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> collection) {
        boolean mutated = this.backing.retainAll(collection);
        if (mutated) {
            this.updateList();
        }
        return mutated;
    }

    @Override
    public void clear() {
        this.backing.clear();
        this.updateList();
    }

    public void extendToWidth(int targetWidth) {
        this.extend(palette -> ColorTypes.ARGB32.distance(palette.colors.get(0), palette.colors.get(palette.colors.size() - 1)) >= (double)targetWidth);
    }

    public void extendToSize(int targetSize) {
        this.extend(palette -> palette.size() >= targetSize);
    }

    public void extend(Predicate<Palette> isExtended) {
        if (this.backing.isEmpty()) {
            throw new IllegalStateException("Color palette is empty");
        }
        double spacing = ColorTypes.ARGB32.distance(this.colors.get(0), this.colors.get(this.colors.size() - 1)) / (double)(this.colors.size() - 1);
        boolean reachedLow = false;
        boolean reachedHigh = false;
        while (!isExtended.test(this)) {
            boolean isLow = true;
            do {
                if (isLow && reachedLow || !isLow && reachedHigh) {
                    isLow = !isLow;
                    continue;
                }
                int end = isLow ? this.colors.get(0) : this.colors.get(this.colors.size() - 1);
                double endDistance = ColorTypes.ARGB32.distance(end, isLow ? 0 : 0xFFFFFF);
                int oldSize = this.backing.size();
                if (endDistance < spacing) {
                    int newColor = isLow ? 0 : 0xFFFFFF;
                    this.backing.add(newColor);
                    if (this.updateExtended(isLow, oldSize)) {
                        this.updateList();
                    }
                    if (isLow) {
                        reachedLow = true;
                        continue;
                    }
                    reachedHigh = true;
                    continue;
                }
                int target = isLow ? 0 : 255;
                int r = (int)(((double)ColorTypes.ARGB32.red(end) * (endDistance - spacing) + (double)target * spacing) / endDistance);
                int g = (int)(((double)ColorTypes.ARGB32.green(end) * (endDistance - spacing) + (double)target * spacing) / endDistance);
                int b = (int)(((double)ColorTypes.ARGB32.blue(end) * (endDistance - spacing) + (double)target * spacing) / endDistance);
                int newColor = ColorTypes.ARGB32.color(255, r, g, b);
                this.backing.add(newColor);
                boolean didExtension = this.updateExtended(isLow, oldSize);
                if (didExtension) {
                    this.updateList();
                }
                if (!didExtension) {
                    if (isLow) {
                        reachedLow = true;
                    } else {
                        reachedHigh = true;
                    }
                }
                boolean bl = isLow = !isLow;
            } while (!isLow);
            if (!reachedLow || !reachedHigh) continue;
            break;
        }
    }

    private boolean updateExtended(boolean isLow, int oldSize) {
        if (oldSize == this.backing.size()) {
            return false;
        }
        if (isLow) {
            ++this.extendedLow;
        } else {
            ++this.extendedHigh;
        }
        return true;
    }

    public int originalSize() {
        return this.backing.size() - this.extendedLow - this.extendedHigh;
    }

    @Override
    public int size() {
        return this.colors.size();
    }

    @Override
    public boolean isEmpty() {
        return this.colors.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.backing.contains(o);
    }

    @Override
    public @NonNull Iterator<Integer> iterator() {
        return this.colors.iterator();
    }

    @Override
    public Object @NonNull [] toArray() {
        return this.colors.toArray();
    }

    @Override
    public <T> T @NonNull [] toArray(T @NonNull [] ts) {
        return this.colors.toArray(ts);
    }

    @Override
    public boolean remove(Object o) {
        boolean mutated = this.backing.remove(o);
        if (mutated) {
            this.updateList();
        }
        return mutated;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> collection) {
        return this.backing.containsAll(collection);
    }

    public int originalStart() {
        if (this.backing.isEmpty()) {
            throw new IllegalStateException("Color palette is empty");
        }
        return this.extendedLow;
    }

    public int originalEnd() {
        if (this.backing.isEmpty()) {
            throw new IllegalStateException("Color palette is empty");
        }
        return this.colors.size() - this.extendedHigh - 1;
    }

    public int originalCenterSample() {
        return (this.originalStart() + this.originalEnd()) * 256 / this.colors.size() / 2;
    }

    public int originalStartSample() {
        return this.originalStart() * 256 / this.colors.size();
    }

    public int originalEndSample() {
        return this.originalEnd() * 256 / this.colors.size();
    }

    public int originalToExtended(int originalSample) {
        if (this.backing.isEmpty()) {
            throw new IllegalStateException("Color palette is empty");
        }
        return originalSample * this.originalSize() / this.colors.size() + this.originalStartSample();
    }

    public int extendedToOriginal(int extendedSample) {
        if (this.originalSize() == 0) {
            throw new IllegalStateException("Original color palette was empty");
        }
        int originalSampleSize = this.originalSize() * 256 / this.colors.size();
        int output = (extendedSample - this.originalStartSample()) * 256 / originalSampleSize;
        return ColorTypes.clamp8(output);
    }

    public int getSample(int color) {
        color |= 0xFF000000;
        if (this.colors.isEmpty()) {
            throw new IllegalStateException("Color palette is empty");
        }
        ArrayList<Pair> indexWithDistance = new ArrayList<Pair>();
        for (int i = 0; i < this.colors.size(); ++i) {
            indexWithDistance.add(Pair.of((Object)i, (Object)ColorTypes.ARGB32.distance(color, this.colors.get(i))));
        }
        indexWithDistance.sort(Comparator.comparingDouble(Pair::getSecond));
        if (indexWithDistance.size() == 1 || (Double)((Pair)indexWithDistance.get(0)).getSecond() <= this.cutoff) {
            return (Integer)((Pair)indexWithDistance.get(0)).getFirst() * 256 / this.colors.size();
        }
        Pair colorMain = (Pair)indexWithDistance.get(0);
        Pair colorNext = (Pair)indexWithDistance.get(1);
        double distance = (Double)colorMain.getSecond() + (Double)colorNext.getSecond();
        double lerp = Math.max(0.0, Math.min(1.0, (Double)colorMain.getSecond() / distance));
        return (int)Math.round(((double)((Integer)colorMain.getFirst()).intValue() * (1.0 - lerp) + (double)((Integer)colorNext.getFirst()).intValue() * lerp) * 256.0 / (double)this.colors.size());
    }

    public int getColor(int sample) {
        if (sample < 0 || sample > 255) {
            throw new IllegalArgumentException("Sample number must be between 0 and 255");
        }
        return this.colors.get(sample * this.colors.size() / 256);
    }

    public int getColorFromIndex(int index) {
        return this.colors.get(index);
    }

    public int getClosestColor(int color) {
        if (this.colors.isEmpty()) {
            throw new IllegalStateException("Color palette is empty");
        }
        ArrayList<Pair> indexWithDistance = new ArrayList<Pair>();
        for (int knownColor : this.colors) {
            indexWithDistance.add(Pair.of((Object)knownColor, (Object)ColorTypes.ARGB32.distance(color, knownColor)));
        }
        indexWithDistance.sort(Comparator.comparingDouble(Pair::getSecond));
        return (Integer)((Pair)indexWithDistance.get(0)).getFirst();
    }

    public int getAverage() {
        int c = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int color : this.colors) {
            ++c;
            r += FastColor.ARGB32.red((int)color);
            g += FastColor.ARGB32.green((int)color);
            b += FastColor.ARGB32.blue((int)color);
        }
        return FastColor.ARGB32.color((int)255, (int)(r / c), (int)(g / c), (int)(b / c));
    }

    public double distanceToPolyLine(int color, ColorCoordinates coordinates) {
        return this.lines.stream().mapToDouble(line -> line.distanceTo(color, coordinates)).min().orElseGet(() -> {
            if (this.colors.isEmpty()) {
                throw new IllegalStateException("Color palette is empty");
            }
            return coordinates.distance(color, this.colors.get(0));
        });
    }

    private void updateList() {
        this.colors = this.backing.stream().sorted(COMPARATOR).toList();
        this.lines = !this.colors.isEmpty() ? IntStream.range(1, this.colors.size()).mapToObj(i -> new LineSegment(this.colors.get(i - 1), this.colors.get(i))).toList() : List.of();
    }
}

