/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.colors;

import dev.lukebemish.dynamicassetgenerator.api.colors.IntColorType;
import dev.lukebemish.dynamicassetgenerator.api.colors.LongColorType;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import org.jetbrains.annotations.Contract;

public final class ColorTypes {
    public static final ARGB32 ARGB32 = new ARGB32();
    public static final ABGR32 ABGR32 = new ABGR32();
    public static final HSL32 HSL32 = new HSL32();
    public static final HSV32 HSV32 = new HSV32();
    public static final CIELAB32 CIELAB32 = new CIELAB32();
    public static final ARGB64 ARGB64 = new ARGB64();
    public static final ABGR64 ABGR64 = new ABGR64();
    public static final HSL64 HSL64 = new HSL64();
    public static final HSV64 HSV64 = new HSV64();
    public static final CIELAB64 CIELAB64 = new CIELAB64();

    private ColorTypes() {
    }

    @Contract(pure=true)
    public static int clamp8(int value) {
        return Math.min(Math.max(value, 0), 255);
    }

    @Contract(pure=true)
    public static int clamp16(int value) {
        return Math.min(Math.max(value, 0), 65535);
    }

    @Contract(pure=true)
    public static double linearize8(int value) {
        double v = (float)value / 255.0f;
        if (v <= 0.04045) {
            return v / 12.92;
        }
        return Math.pow((v + 0.055) / 1.055, 2.4);
    }

    @Contract(pure=true)
    public static int delinearize8(double value) {
        if (value <= 0.0031308) {
            return ColorTypes.clamp8((int)(value * 12.92 * 255.0 + 0.5));
        }
        return ColorTypes.clamp8((int)((1.055 * Math.pow(value, 0.4166666666666667) - 0.055) * 255.0 + 0.5));
    }

    @Contract(pure=true)
    public static double linearize16(int value) {
        double v = (float)value / 65535.0f;
        if (v <= 0.04045) {
            return v / 12.92;
        }
        return Math.pow((v + 0.055) / 1.055, 2.4);
    }

    @Contract(pure=true)
    public static int delinearize16(double value) {
        if (value <= 0.0031308) {
            return ColorTypes.clamp16((int)(value * 12.92 * 65535.0 + 0.5));
        }
        return ColorTypes.clamp16((int)((1.055 * Math.pow(value, 0.4166666666666667) - 0.055) * 65535.0 + 0.5));
    }

    @Contract(pure=true)
    public static int demote(long color) {
        int a = (int)(color >> 56) & 0xFF;
        int c1 = (int)(color >> 40) & 0xFF;
        int c2 = (int)(color >> 24) & 0xFF;
        int c3 = (int)(color >> 8) & 0xFF;
        return a << 24 | c1 << 16 | c2 << 8 | c3;
    }

    @Contract(pure=true)
    public static long promote(int color) {
        long a = color >> 16 & 0xFF00;
        long c1 = color >> 8 & 0xFF00;
        long c2 = color & 0xFF00;
        int c3 = color << 8 & 0xFF00;
        return a << 48 | c1 << 32 | c2 << 16 | (long)c3;
    }

    public static final class ARGB32
    extends IntColorType.BlendingIntColorType {
        private ARGB32() {
        }

        @Contract(pure=true)
        public int red(int color) {
            return this.first(color);
        }

        @Contract(pure=true)
        public int green(int color) {
            return this.second(color);
        }

        @Contract(pure=true)
        public int blue(int color) {
            return this.third(color);
        }

        @Override
        public int toARGB32(int color) {
            return color;
        }

        @Override
        public int fromARGB32(int color) {
            return color;
        }

        public double distance(int color1, int color2) {
            int dr = this.red(color1) - this.red(color2);
            int dg = this.green(color1) - this.green(color2);
            int db = this.blue(color1) - this.blue(color2);
            return Math.sqrt(dr * dr + dg * dg + db * db);
        }
    }

    public static final class ABGR32
    extends IntColorType.BlendingIntColorType {
        private ABGR32() {
        }

        @Contract(pure=true)
        public int red(int color) {
            return this.third(color);
        }

        @Contract(pure=true)
        public int green(int color) {
            return this.second(color);
        }

        @Contract(pure=true)
        public int blue(int color) {
            return this.first(color);
        }

        @Override
        public int toARGB32(int color) {
            return ARGB32.color(this.alpha(color), this.red(color), this.green(color), this.blue(color));
        }

        @Override
        public int fromARGB32(int color) {
            return this.color(ARGB32.alpha(color), ARGB32.blue(color), ARGB32.green(color), ARGB32.red(color));
        }
    }

    public static final class HSL32
    extends IntColorType.HueIntColorType {
        private HSL32() {
        }

        @Contract(pure=true)
        public int saturation(int color) {
            return this.second(color);
        }

        @Contract(pure=true)
        public int lightness(int color) {
            return this.third(color);
        }

        @Override
        protected float makeChroma(int color) {
            float s = (float)this.saturation(color) / 255.0f;
            float l = (float)this.lightness(color) / 255.0f;
            return (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        }

        @Override
        protected float makeMatch(int color, float chroma) {
            return (float)this.lightness(color) / 255.0f - chroma / 2.0f;
        }

        @Override
        protected int makeColor(int alpha, int hue, float chroma, float xMin, float xMax) {
            float l = (xMax + xMin) / 2.0f;
            float v = l + chroma / 2.0f;
            float s = l <= 0.0f || l >= 1.0f ? 0.0f : (v - l) / Math.min(l, 1.0f - l);
            return this.color(alpha, hue, ColorTypes.clamp8(Math.round(s * 255.0f)), ColorTypes.clamp8(Math.round(l * 255.0f)));
        }
    }

    public static class HSV32
    extends IntColorType.HueIntColorType {
        private HSV32() {
        }

        @Contract(pure=true)
        public int saturation(int color) {
            return this.second(color);
        }

        @Contract(pure=true)
        public int value(int color) {
            return this.third(color);
        }

        @Override
        protected float makeChroma(int color) {
            float s = (float)this.saturation(color) / 255.0f;
            float v = (float)this.value(color) / 255.0f;
            return s * v;
        }

        @Override
        protected float makeMatch(int color, float chroma) {
            return (float)this.value(color) / 255.0f - chroma;
        }

        @Override
        protected int makeColor(int alpha, int hue, float chroma, float xMin, float xMax) {
            float v = (xMax + xMin + chroma) / 2.0f;
            float s = v == 0.0f ? 0.0f : chroma / v;
            return this.color(alpha, hue, ColorTypes.clamp8(Math.round(s * 255.0f)), ColorTypes.clamp8(Math.round(v * 255.0f)));
        }
    }

    public static final class CIELAB32
    extends IntColorType {
        private static final double XN = 0.95047;
        private static final double YN = 1.0;
        private static final double ZN = 1.08883;
        private static final double DELTA = 0.20689655172413793;
        private static final double DELTA_2 = 0.04280618311533888;
        private static final double DELTA_3 = 0.008856451679035631;

        private CIELAB32() {
        }

        @Contract(pure=true)
        public int lightness(int color) {
            return this.first(color);
        }

        @Contract(pure=true)
        public int a(int color) {
            return (byte)this.second(color);
        }

        @Contract(pure=true)
        public int b(int color) {
            return (byte)this.third(color);
        }

        public double distance(int color1, int color2) {
            int dL = this.lightness(color1) - this.lightness(color2);
            int da = this.a(color1) - this.a(color2);
            int db = this.b(color1) - this.b(color2);
            return Math.sqrt(da * da + db * db + dL * dL);
        }

        @Override
        public int toARGB32(int color) {
            double x = 0.95047 * dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB32.cielabFinv((double)(this.lightness(color) + 16) / 116.0 + (double)this.a(color) / 500.0);
            double y = 1.0 * dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB32.cielabFinv((double)(this.lightness(color) + 16) / 116.0);
            double z = 1.08883 * dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB32.cielabFinv((double)(this.lightness(color) + 16) / 116.0 + (double)this.b(color) / 200.0);
            double lR = 3.2406 * x + -1.5372 * y + -0.4986 * z;
            double lG = -0.9689 * x + 1.8758 * y + 0.0415 * z;
            double lB = 0.0557 * x + -0.204 * y + 1.057 * z;
            int r = ColorTypes.delinearize8(lR);
            int g = ColorTypes.delinearize8(lG);
            int b = ColorTypes.delinearize8(lB);
            return ARGB32.color(this.alpha(color), r, g, b);
        }

        @Override
        public int fromARGB32(int color) {
            int r = ARGB32.red(color);
            int g = ARGB32.green(color);
            int b = ARGB32.blue(color);
            double lR = ColorTypes.linearize8(r);
            double lG = ColorTypes.linearize8(g);
            double lB = ColorTypes.linearize8(b);
            double x = 0.4124 * lR + 0.3576 * lG + 0.1805 * lB;
            double y = 0.2126 * lR + 0.7152 * lG + 0.0722 * lB;
            double z = 0.0193 * lR + 0.1192 * lG + 0.9505 * lB;
            double l = 116.0 * dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB32.cielabF(y / 1.0) - 16.0;
            double a_ = 500.0 * (dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB32.cielabF(x / 0.95047) - dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB32.cielabF(y / 1.0));
            double b_ = 200.0 * (dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB32.cielabF(y / 1.0) - dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB32.cielabF(z / 1.08883));
            return this.color(ARGB32.alpha(color), (int)Math.round(l) & 0xFF, (int)Math.round(a_) & 0xFF, (int)Math.round(b_) & 0xFF);
        }

        @Contract(pure=true)
        private static double cielabF(double t) {
            if (t > 0.008856451679035631) {
                return Math.pow(t, 0.3333333333333333);
            }
            return t / 0.12841854934601665 + 0.13793103448275862;
        }

        @Contract(pure=true)
        private static double cielabFinv(double t) {
            if (t > 0.20689655172413793) {
                return t * t * t;
            }
            return 0.12841854934601665 * (t - 0.13793103448275862);
        }
    }

    public static final class ARGB64
    extends LongColorType.BlendingLongColorType {
        private ARGB64() {
        }

        @Contract(pure=true)
        public int red(long color) {
            return this.first(color);
        }

        @Contract(pure=true)
        public int green(long color) {
            return this.second(color);
        }

        @Contract(pure=true)
        public int blue(long color) {
            return this.third(color);
        }

        @Override
        public long toARGB64(long color) {
            return color;
        }

        @Override
        public long fromARGB64(long color) {
            return color;
        }

        public double distance(long color1, long color2) {
            int dr = this.red(color1) - this.red(color2);
            int dg = this.green(color1) - this.green(color2);
            int db = this.blue(color1) - this.blue(color2);
            return Math.sqrt(dr * dr + dg * dg + db * db);
        }
    }

    public static final class ABGR64
    extends LongColorType.BlendingLongColorType {
        private ABGR64() {
        }

        @Contract(pure=true)
        public int red(long color) {
            return this.third(color);
        }

        @Contract(pure=true)
        public int green(long color) {
            return this.second(color);
        }

        @Contract(pure=true)
        public int blue(long color) {
            return this.first(color);
        }

        @Override
        public long toARGB64(long color) {
            return ARGB64.color(this.alpha(color), this.red(color), this.green(color), this.blue(color));
        }

        @Override
        public long fromARGB64(long color) {
            return this.color(ARGB64.alpha(color), ARGB64.red(color), ARGB64.green(color), ARGB64.blue(color));
        }
    }

    public static final class HSL64
    extends LongColorType.HueLongColorType {
        private HSL64() {
        }

        @Contract(pure=true)
        public int saturation(long color) {
            return this.second(color);
        }

        @Contract(pure=true)
        public int lightness(long color) {
            return this.third(color);
        }

        @Override
        protected float makeChroma(long color) {
            float s = (float)this.saturation(color) / 65535.0f;
            float l = (float)this.lightness(color) / 65535.0f;
            return (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        }

        @Override
        protected float makeMatch(long color, float chroma) {
            return (float)this.lightness(color) / 65535.0f - chroma / 2.0f;
        }

        @Override
        protected long makeColor(int alpha, int hue, float chroma, float xMin, float xMax) {
            float l = (xMax + xMin) / 2.0f;
            float v = l + chroma / 2.0f;
            float s = l <= 0.0f || l >= 1.0f ? 0.0f : (v - l) / Math.min(l, 1.0f - l);
            return this.color(alpha, hue, ColorTypes.clamp16(Math.round(s * 65535.0f)), ColorTypes.clamp16(Math.round(l * 65535.0f)));
        }
    }

    public static class HSV64
    extends LongColorType.HueLongColorType {
        private HSV64() {
        }

        @Contract(pure=true)
        public int saturation(long color) {
            return this.second(color);
        }

        @Contract(pure=true)
        public int value(long color) {
            return this.third(color);
        }

        @Override
        protected float makeChroma(long color) {
            float s = (float)this.saturation(color) / 65535.0f;
            float v = (float)this.value(color) / 65535.0f;
            return s * v;
        }

        @Override
        protected float makeMatch(long color, float chroma) {
            return (float)this.value(color) / 65535.0f - chroma;
        }

        @Override
        protected long makeColor(int alpha, int hue, float chroma, float xMin, float xMax) {
            float v = (xMax + xMin + chroma) / 2.0f;
            float s = v == 0.0f ? 0.0f : chroma / v;
            return this.color(alpha, hue, ColorTypes.clamp16(Math.round(s * 65535.0f)), ColorTypes.clamp16(Math.round(v * 65535.0f)));
        }
    }

    public static final class CIELAB64
    extends LongColorType {
        private static final double XN = 0.95047;
        private static final double YN = 1.0;
        private static final double ZN = 1.08883;
        private static final double DELTA = 0.20689655172413793;
        private static final double DELTA_2 = 0.04280618311533888;
        private static final double DELTA_3 = 0.008856451679035631;

        private CIELAB64() {
        }

        @Contract(pure=true)
        public float lightness(long color) {
            return (float)this.first(color) / 255.0f;
        }

        @Contract(pure=true)
        public float a(long color) {
            return (float)((short)this.second(color)) / 255.0f;
        }

        @Contract(pure=true)
        public float b(long color) {
            return (float)((short)this.third(color)) / 255.0f;
        }

        public double distance(long color1, long color2) {
            float dL = this.lightness(color1) - this.lightness(color2);
            float da = this.a(color1) - this.a(color2);
            float db = this.b(color1) - this.b(color2);
            return Math.sqrt(da * da + db * db + dL * dL);
        }

        @Override
        public long toARGB64(long color) {
            double x = 0.95047 * dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB64.cielabFinv((double)(this.lightness(color) + 16.0f) / 116.0 + (double)this.a(color) / 500.0);
            double y = 1.0 * dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB64.cielabFinv((double)(this.lightness(color) + 16.0f) / 116.0);
            double z = 1.08883 * dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB64.cielabFinv((double)(this.lightness(color) + 16.0f) / 116.0 + (double)this.b(color) / 200.0);
            double lR = 3.2406 * x + -1.5372 * y + -0.4986 * z;
            double lG = -0.9689 * x + 1.8758 * y + 0.0415 * z;
            double lB = 0.0557 * x + -0.204 * y + 1.057 * z;
            int r = ColorTypes.delinearize16(lR);
            int g = ColorTypes.delinearize16(lG);
            int b = ColorTypes.delinearize16(lB);
            return ARGB64.color(this.alpha(color), r, g, b);
        }

        @Override
        public long fromARGB64(long color) {
            int r = ARGB64.red(color);
            int g = ARGB64.green(color);
            int b = ARGB64.blue(color);
            double lR = ColorTypes.linearize16(r);
            double lG = ColorTypes.linearize16(g);
            double lB = ColorTypes.linearize16(b);
            double x = 0.4124 * lR + 0.3576 * lG + 0.1805 * lB;
            double y = 0.2126 * lR + 0.7152 * lG + 0.0722 * lB;
            double z = 0.0193 * lR + 0.1192 * lG + 0.9505 * lB;
            double l = 116.0 * dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB64.cielabF(y / 1.0) - 16.0;
            double a_ = 500.0 * (dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB64.cielabF(x / 0.95047) - dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB64.cielabF(y / 1.0));
            double b_ = 200.0 * (dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB64.cielabF(y / 1.0) - dev.lukebemish.dynamicassetgenerator.api.colors.ColorTypes$CIELAB64.cielabF(z / 1.08883));
            return this.color(ARGB64.alpha(color), (int)Math.round(l * 255.0) & 0xFFFF, (int)Math.round(a_ * 255.0) & 0xFFFF, (int)Math.round(b_ * 255.0) & 0xFFFF);
        }

        @Contract(pure=true)
        private static double cielabF(double t) {
            if (t > 0.008856451679035631) {
                return Math.pow(t, 0.3333333333333333);
            }
            return t / 0.12841854934601665 + 0.13793103448275862;
        }

        @Contract(pure=true)
        private static double cielabFinv(double t) {
            if (t > 0.20689655172413793) {
                return t * t * t;
            }
            return 0.12841854934601665 * (t - 0.13793103448275862);
        }
    }

    public static class ConversionCache64 {
        private final Long2LongMap cache = new Long2LongOpenHashMap();
        private final LongUnaryOperator converter;

        public ConversionCache64(LongUnaryOperator converter) {
            this.converter = converter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long convert(long color) {
            Long2LongMap long2LongMap = this.cache;
            synchronized (long2LongMap) {
                if (this.cache.containsKey(color)) {
                    return this.cache.get(color);
                }
            }
            long result = this.converter.applyAsLong(color);
            Long2LongMap long2LongMap2 = this.cache;
            synchronized (long2LongMap2) {
                if (!this.cache.containsKey(color)) {
                    this.cache.put(color, result);
                }
            }
            return result;
        }
    }

    public static class ConversionCache32 {
        private final Int2IntMap cache = new Int2IntOpenHashMap();
        private final IntUnaryOperator converter;

        public ConversionCache32(IntUnaryOperator converter) {
            this.converter = converter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int convert(int color) {
            Int2IntMap int2IntMap = this.cache;
            synchronized (int2IntMap) {
                if (this.cache.containsKey(color)) {
                    return this.cache.get(color);
                }
            }
            int result = this.converter.applyAsInt(color);
            Int2IntMap int2IntMap2 = this.cache;
            synchronized (int2IntMap2) {
                if (!this.cache.containsKey(color)) {
                    this.cache.put(color, result);
                }
            }
            return result;
        }
    }
}

