/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.compat;

import com.google.auto.service.AutoService;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.dynamicassetgenerator.api.compat.ConditionalInvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.api.compat.InvisibleResourceProvider;
import dev.lukebemish.dynamicassetgenerator.api.templates.TagFile;
import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.FabriQuiltShared;
import io.wispforest.owo.util.TagInjector;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3497;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AutoService(value={ConditionalInvisibleResourceProvider.class})
public class OwoLibProviderWrapper
implements ConditionalInvisibleResourceProvider {
    @Override
    public boolean isAvailable() {
        return FabriQuiltShared.getInstance().isModLoaded("owo");
    }

    @Override
    public InvisibleResourceProvider get() {
        return new OwoLibProvider();
    }

    public static class OwoLibProvider
    implements InvisibleResourceProvider {
        private static @Nullable Map<class_2960, String> tagMap;

        @Override
        public class_7367<InputStream> getResource(@NonNull class_3264 type, @NonNull class_2960 location) {
            if (type == class_3264.field_14190) {
                this.checkMap();
                if (tagMap.containsKey(location)) {
                    return () -> new ByteArrayInputStream(tagMap.get(location).getBytes());
                }
            }
            return null;
        }

        @Override
        public void listResources(@NonNull class_3264 type, @NonNull String namespace, @NonNull String path, // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull class_3262.class_7664 resourceOutput) {
            if (type == class_3264.field_14190) {
                this.checkMap();
                tagMap.keySet().stream().filter(location -> location.method_12836().equals(namespace) && location.method_12832().startsWith(path)).forEach(rl -> resourceOutput.accept(rl, this.getResource(type, (class_2960)rl)));
            }
        }

        @Override
        public Set<String> getNamespaces(@NonNull class_3264 type) {
            if (type == class_3264.field_14190) {
                this.checkMap();
                return tagMap.keySet().stream().map(class_2960::method_12836).collect(Collectors.toSet());
            }
            return Set.of();
        }

        @Override
        public void reset(@NonNull class_3264 type) {
            if (type == class_3264.field_14190) {
                tagMap = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkMap() {
            if (tagMap == null) {
                OwoLibProvider owoLibProvider = this;
                synchronized (owoLibProvider) {
                    if (tagMap != null) {
                        return;
                    }
                    tagMap = new HashMap<class_2960, String>();
                    TagInjector.getInjections().forEach((key, values) -> {
                        JsonElement encoded;
                        TagFile tag = new TagFile(new ArrayList<class_3497>((Collection<class_3497>)values), false);
                        try {
                            encoded = (JsonElement)TagFile.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)tag).getOrThrow(RuntimeException::new);
                        }
                        catch (RuntimeException e) {
                            DynamicAssetGenerator.LOGGER.error("Error encoding tag file from OwoLib entries: " + e.getMessage());
                            return;
                        }
                        tagMap.put(new class_2960(key.tagId().method_12836(), "tags/" + key.type() + "/" + key.tagId().method_12832() + ".json"), DynamicAssetGenerator.GSON.toJson(encoded));
                    });
                }
            }
        }
    }
}

