/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.impl.client.NativeImageHelper;
import dev.lukebemish.dynamicassetgenerator.impl.util.Maath;
import dev.lukebemish.dynamicassetgenerator.impl.util.MultiCloser;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_7367;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AnimationSplittingSource
implements TexSource {
    public static final MapCodec<AnimationSplittingSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, TexSource.CODEC).fieldOf("sources").forGetter(AnimationSplittingSource::getSources), (App)TexSource.CODEC.fieldOf("generator").forGetter(AnimationSplittingSource::getGenerator)).apply((Applicative)instance, AnimationSplittingSource::new));
    private final Map<String, TexSource> sources;
    private final TexSource generator;
    static final TexSourceDataHolder.Token<ImageCollection> IMAGE_COLLECTION_TOKEN = new TexSourceDataHolder.Token();

    private AnimationSplittingSource(Map<String, TexSource> sources, TexSource generator) {
        this.sources = sources;
        this.generator = generator;
    }

    @Override
    public @NonNull MapCodec<? extends TexSource> codec() {
        return CODEC;
    }

    @Override
    public @Nullable class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        HashMap sourcesMap = new HashMap();
        this.getSources().forEach((key, source) -> sourcesMap.put(key, source.getCachedSupplier(data, context)));
        if (sourcesMap.isEmpty()) {
            data.getLogger().error("No sources given...");
            return null;
        }
        return () -> {
            HashMap<String, class_1011> images = new HashMap<String, class_1011>();
            for (Map.Entry e : sourcesMap.entrySet()) {
                String key = (String)e.getKey();
                images.put(key, (class_1011)((class_7367)e.getValue()).get());
            }
            try (MultiCloser ignored = new MultiCloser(images.values());){
                List imageList = images.values().stream().toList();
                List<Integer> counts = images.values().stream().map(AnimationSplittingSource::getFrameCount).toList();
                for (int i : counts) {
                    if (i != 0) continue;
                    data.getLogger().error("Source not shaped correctly for an animation...");
                    throw new IOException("Source not shaped correctly for an animation...");
                }
                int lcm = Maath.lcm(counts);
                int lcmWidth = Maath.lcm(imageList.stream().map(class_1011::method_4307).toList());
                class_1011 output = NativeImageHelper.of(class_1011.class_1012.field_4997, lcmWidth, lcmWidth * lcm, false);
                for (int i = 0; i < lcm; ++i) {
                    HashMap<String, class_1011> map = new HashMap<String, class_1011>();
                    int finalI = i;
                    images.forEach((str, old) -> map.put((String)str, AnimationSplittingSource.getPartialImage(old, finalI)));
                    try (ImageCollection collection = new ImageCollection(map, this.getSources(), i);){
                        TexSourceDataHolder newData = new TexSourceDataHolder(data);
                        newData.put(IMAGE_COLLECTION_TOKEN, collection);
                        class_7367<class_1011> supplier = this.generator.getCachedSupplier(newData, context);
                        if (supplier == null) {
                            data.getLogger().error("Generator created no image...");
                            throw new IOException("Generator created no image...");
                        }
                        class_1011 supplied = (class_1011)supplier.get();
                        int sWidth = supplied.method_4307();
                        if (sWidth != supplied.method_4323()) {
                            data.getLogger().error("Generator created non-square image...\n{}", (Object)this.generator.stringify());
                            throw new IOException("Generator created non-square image...");
                        }
                        int scale = lcmWidth / sWidth;
                        for (int x = 0; x < lcmWidth; ++x) {
                            for (int y = 0; y < lcmWidth; ++y) {
                                int color = ImageUtils.safeGetPixelABGR(supplied, x / scale, y / scale);
                                output.method_4305(x, y + i * lcmWidth, color);
                            }
                        }
                        continue;
                    }
                }
                class_1011 class_10112 = output;
                return class_10112;
            }
        };
    }

    private static int getFrameCount(class_1011 image) {
        return image.method_4323() / image.method_4307();
    }

    private static class_1011 getPartialImage(class_1011 input, int part) {
        int numFull = input.method_4323() / input.method_4307();
        int size = input.method_4307();
        class_1011 output = NativeImageHelper.of(input.method_4318(), size, size, false);
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                output.method_4305(x, y, ImageUtils.safeGetPixelABGR(input, x, part % numFull * size + y));
            }
        }
        return output;
    }

    public Map<String, TexSource> getSources() {
        return this.sources;
    }

    public TexSource getGenerator() {
        return this.generator;
    }

    @ApiStatus.Internal
    static class ImageCollection
    implements Closeable {
        private final Map<String, class_1011> map;
        private final Map<String, TexSource> original;
        private final int frame;

        @ApiStatus.Internal
        private ImageCollection(Map<String, class_1011> map, Map<String, TexSource> original, int frame) {
            this.map = new HashMap<String, class_1011>(map);
            this.original = original;
            this.frame = frame;
        }

        @Override
        public void close() {
            this.map.values().forEach(class_1011::close);
        }

        public class_1011 get(String key) throws IOException {
            class_1011 input = this.map.get(key);
            if (input == null) {
                throw new IOException("No image for key: " + key);
            }
            class_1011 newImage = new class_1011(input.method_4318(), input.method_4307(), input.method_4323(), false);
            newImage.method_4317(input);
            return newImage;
        }

        public int getFrame() {
            return this.frame;
        }

        public TexSource getFull(String key) {
            return this.original.get(key);
        }
    }

    public static class Builder {
        private Map<String, TexSource> sources;
        private TexSource generator;

        public Builder setSources(Map<String, TexSource> sources) {
            this.sources = sources;
            return this;
        }

        public Builder setGenerator(TexSource generator) {
            this.generator = generator;
            return this;
        }

        public AnimationSplittingSource build() {
            Objects.requireNonNull(this.sources);
            Objects.requireNonNull(this.generator);
            return new AnimationSplittingSource(this.sources, this.generator);
        }
    }
}

