/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TexSourceDataHolder;
import dev.lukebemish.dynamicassetgenerator.api.client.image.ImageUtils;
import dev.lukebemish.dynamicassetgenerator.api.colors.operations.PointwiseOperation;
import dev.lukebemish.dynamicassetgenerator.impl.util.MultiCloser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_7367;
import org.jspecify.annotations.Nullable;

public abstract class AbstractManyOperationSource
implements TexSource {
    private final List<TexSource> sources;

    public AbstractManyOperationSource(List<TexSource> sources) {
        this.sources = sources;
    }

    public List<TexSource> getSources() {
        return this.sources;
    }

    public abstract PointwiseOperation.Any<Integer> getOperation();

    public static <T extends AbstractManyOperationSource> MapCodec<T> makeCodec(Function<List<TexSource>, T> ctor) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)TexSource.CODEC.listOf().fieldOf("sources").forGetter(AbstractManyOperationSource::getSources)).apply((Applicative)instance, ctor));
    }

    @Override
    public @Nullable class_7367<class_1011> getSupplier(TexSourceDataHolder data, ResourceGenerationContext context) {
        ArrayList<class_7367<class_1011>> inputs = new ArrayList<class_7367<class_1011>>();
        for (TexSource o : this.getSources()) {
            class_7367<class_1011> source = o.getCachedSupplier(data, context);
            if (source == null) {
                data.getLogger().error("Texture given was nonexistent...\n{}", (Object)o.stringify());
                return null;
            }
            inputs.add(source);
        }
        return () -> {
            ArrayList<class_1011> images = new ArrayList<class_1011>();
            for (class_7367 input : inputs) {
                images.add((class_1011)input.get());
            }
            try (MultiCloser ignored = new MultiCloser(images);){
                class_1011 class_10112 = ImageUtils.generateScaledImage(this.getOperation(), images);
                return class_10112;
            }
        };
    }
}

