package dev.lukebemish.dynamicassetgenerator.impl.fabriquilt;

import dev.lukebemish.dynamicassetgenerator.impl.DynamicAssetGenerator;
import dev.lukebemish.dynamicassetgenerator.impl.GeneratedPackResources;
import dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.fabric.FabricPlatform;
import dev.lukebemish.dynamicassetgenerator.impl.fabriquilt.quilt.QuiltPlatformMinimal;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3281;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_3288.class_7679;
import net.minecraft.class_5352;
import net.minecraft.class_7699;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public interface FabriQuiltShared {
    static FabriQuiltShared getInstance() {
        if (FabricLoader.getInstance().isModLoaded("quilt_loader")) {
            return QuiltPlatformMinimal.INSTANCE;
        } else {
            return FabricPlatform.INSTANCE;
        }
    }

    void packForType(class_3264 type, class_3285 source);

    boolean isModLoaded(String id);
    String modVersion(String id);
    Path configDir();
    Path cacheDir();

    static void registerForType(class_3264 type) {
        getInstance().packForType(type, consumer ->
            DynamicAssetGenerator.CACHES.forEach(((location, info) -> {
                if (info.cache().getPackType() == type) {
                    var metadata = DynamicAssetGenerator.makeMetadata(info.cache());
                    var packMetadata = new class_3288.class_7679(
                        metadata.comp_1580(),
                        class_3281.field_14224,
                        class_7699.method_45397(),
                        List.of()
                    );
                    var id = DynamicAssetGenerator.MOD_ID+'/'+ info.cache().getName();
                    class_3288 pack = new class_3288(
                        new class_9224(id, class_2561.method_43470(id), class_5352.field_25347, Optional.empty()),
                        new GeneratedPackResources.GeneratedResourcesSupplier(info.cache()),
                        packMetadata,
                        new class_9225(true, info.position(), true)
                    );
                    consumer.accept(pack);
                }
            })));
    }

    Stream<class_3262> unpackPacks(Stream<? extends class_3262> packs);
}
