package dev.lukebemish.dynamicassetgenerator.api.compat;

import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import java.io.InputStream;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

/**
 * A service used to provide resources that, for one reason or another, are not visible through the normal
 * PrePackRepositories. Examples would be adding compatibility with mods that have their own strange resource injection
 * systems. Should be provided as a service if this should always be available; otherwise, see
 * {@link ConditionalInvisibleResourceProvider}.
 */
public interface InvisibleResourceProvider {

    @Nullable class_7367<InputStream> getResource(@NonNull class_3264 type, @NonNull class_2960 location);

    void listResources(@NonNull class_3264 type, @NonNull String namespace, @NonNull String path, class_3262.@NonNull class_7664 resourceOutput);

    Set<String> getNamespaces(@NonNull class_3264 type);

    default void reset(@NonNull class_3264 type) {}

}
