/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.blas;

import com.github.fommil.netlib.F2jBLAS;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.FloatVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class VectorizedBLAS
extends F2jBLAS {
    private static final VectorSpecies<Float> FMAX = FloatVector.SPECIES_MAX;
    private static final VectorSpecies<Double> DMAX = DoubleVector.SPECIES_MAX;

    public void daxpy(int n, double alpha, double[] x, int incx, double[] y, int incy) {
        if (n >= 0 && x != null && x.length >= n && incx == 1 && y != null && y.length >= n && incy == 1) {
            if (alpha != 0.0) {
                int i;
                DoubleVector valpha = DoubleVector.broadcast(DMAX, (double)alpha);
                for (i = 0; i < DMAX.loopBound(n); i += DMAX.length()) {
                    DoubleVector vx = DoubleVector.fromArray(DMAX, (double[])x, (int)i);
                    DoubleVector vy = DoubleVector.fromArray(DMAX, (double[])y, (int)i);
                    vx.fma((Vector)valpha, (Vector)vy).intoArray(y, i);
                }
                while (i < n) {
                    int n2 = i;
                    y[n2] = y[n2] + alpha * x[i];
                    ++i;
                }
            }
        } else {
            super.daxpy(n, alpha, x, incx, y, incy);
        }
    }

    public float sdot(int n, float[] x, int incx, float[] y, int incy) {
        if (n >= 0 && x != null && x.length >= n && incx == 1 && y != null && y.length >= n && incy == 1) {
            int i;
            float sum = 0.0f;
            FloatVector vsum = FloatVector.zero(FMAX);
            for (i = 0; i < FMAX.loopBound(n); i += FMAX.length()) {
                FloatVector vx = FloatVector.fromArray(FMAX, (float[])x, (int)i);
                FloatVector vy = FloatVector.fromArray(FMAX, (float[])y, (int)i);
                vsum = vx.fma((Vector)vy, (Vector)vsum);
            }
            sum += vsum.reduceLanes(VectorOperators.ADD);
            while (i < n) {
                sum += x[i] * y[i];
                ++i;
            }
            return sum;
        }
        return super.sdot(n, x, incx, y, incy);
    }

    public double ddot(int n, double[] x, int incx, double[] y, int incy) {
        if (n >= 0 && x != null && x.length >= n && incx == 1 && y != null && y.length >= n && incy == 1) {
            int i;
            double sum = 0.0;
            DoubleVector vsum = DoubleVector.zero(DMAX);
            for (i = 0; i < DMAX.loopBound(n); i += DMAX.length()) {
                DoubleVector vx = DoubleVector.fromArray(DMAX, (double[])x, (int)i);
                DoubleVector vy = DoubleVector.fromArray(DMAX, (double[])y, (int)i);
                vsum = vx.fma((Vector)vy, (Vector)vsum);
            }
            sum += vsum.reduceLanes(VectorOperators.ADD);
            while (i < n) {
                sum += x[i] * y[i];
                ++i;
            }
            return sum;
        }
        return super.ddot(n, x, incx, y, incy);
    }

    public void dscal(int n, double alpha, double[] x, int incx) {
        if (n >= 0 && x != null && x.length >= n && incx == 1) {
            if (alpha != 1.0) {
                int i;
                DoubleVector valpha = DoubleVector.broadcast(DMAX, (double)alpha);
                for (i = 0; i < DMAX.loopBound(n); i += DMAX.length()) {
                    DoubleVector vx = DoubleVector.fromArray(DMAX, (double[])x, (int)i);
                    vx.mul((Vector)valpha).intoArray(x, i);
                }
                while (i < n) {
                    int n2 = i++;
                    x[n2] = x[n2] * alpha;
                }
            }
        } else {
            super.dscal(n, alpha, x, incx);
        }
    }

    public void sscal(int n, float alpha, float[] x, int incx) {
        if (n >= 0 && x != null && x.length >= n && incx == 1) {
            if ((double)alpha != 1.0) {
                int i;
                FloatVector valpha = FloatVector.broadcast(FMAX, (float)alpha);
                for (i = 0; i < FMAX.loopBound(n); i += FMAX.length()) {
                    FloatVector vx = FloatVector.fromArray(FMAX, (float[])x, (int)i);
                    vx.mul((Vector)valpha).intoArray(x, i);
                }
                while (i < n) {
                    int n2 = i++;
                    x[n2] = x[n2] * alpha;
                }
            }
        } else {
            super.sscal(n, alpha, x, incx);
        }
    }

    public void dspmv(String uplo, int n, double alpha, double[] a, double[] x, int incx, double beta, double[] y, int incy) {
        if ("U".equals(uplo) && n >= 0 && a != null && a.length >= n * (n + 1) / 2 && x != null && x.length >= n && incx == 1 && y != null && y.length >= n && incy == 1) {
            this.dscal(n, beta, y, 1);
            if (alpha != 0.0) {
                DoubleVector valpha = DoubleVector.broadcast(DMAX, (double)alpha);
                for (int row = 0; row < n; ++row) {
                    int col;
                    DoubleVector vyrowsum = DoubleVector.zero(DMAX);
                    DoubleVector valphaxrow = DoubleVector.broadcast(DMAX, (double)(alpha * x[row]));
                    for (col = 0; col < DMAX.loopBound(row); col += DMAX.length()) {
                        DoubleVector vx = DoubleVector.fromArray(DMAX, (double[])x, (int)col);
                        DoubleVector vy = DoubleVector.fromArray(DMAX, (double[])y, (int)col);
                        DoubleVector va = DoubleVector.fromArray(DMAX, (double[])a, (int)(col + row * (row + 1) / 2));
                        vyrowsum = valpha.mul((Vector)vx).fma((Vector)va, (Vector)vyrowsum);
                        valphaxrow.fma((Vector)va, (Vector)vy).intoArray(y, col);
                    }
                    int n2 = row;
                    y[n2] = y[n2] + vyrowsum.reduceLanes(VectorOperators.ADD);
                    while (col < row) {
                        int n3 = row;
                        y[n3] = y[n3] + alpha * x[col] * a[col + row * (row + 1) / 2];
                        int n4 = col;
                        y[n4] = y[n4] + alpha * x[row] * a[col + row * (row + 1) / 2];
                        ++col;
                    }
                    int n5 = row;
                    y[n5] = y[n5] + alpha * x[col] * a[col + row * (row + 1) / 2];
                }
            }
        } else {
            super.dspmv(uplo, n, alpha, a, x, incx, beta, y, incy);
        }
    }

    public void dspr(String uplo, int n, double alpha, double[] x, int incx, double[] a) {
        if ("U".equals(uplo) && n >= 0 && x != null && x.length >= n && incx == 1 && a != null && a.length >= n * (n + 1) / 2) {
            if (alpha != 0.0) {
                for (int row = 0; row < n; ++row) {
                    int col;
                    DoubleVector valphaxrow = DoubleVector.broadcast(DMAX, (double)(alpha * x[row]));
                    for (col = 0; col < DMAX.loopBound(row + 1); col += DMAX.length()) {
                        DoubleVector vx = DoubleVector.fromArray(DMAX, (double[])x, (int)col);
                        DoubleVector va = DoubleVector.fromArray(DMAX, (double[])a, (int)(col + row * (row + 1) / 2));
                        vx.fma((Vector)valphaxrow, (Vector)va).intoArray(a, col + row * (row + 1) / 2);
                    }
                    while (col < row + 1) {
                        int n2 = col + row * (row + 1) / 2;
                        a[n2] = a[n2] + alpha * x[row] * x[col];
                        ++col;
                    }
                }
            }
        } else {
            super.dspr(uplo, n, alpha, x, incx, a);
        }
    }

    public void dsyr(String uplo, int n, double alpha, double[] x, int incx, double[] a, int lda) {
        if ("U".equals(uplo) && n >= 0 && x != null && x.length >= n && incx == 1 && a != null && a.length >= n * n && lda == n) {
            if (alpha != 0.0) {
                for (int row = 0; row < n; ++row) {
                    int col;
                    DoubleVector valphaxrow = DoubleVector.broadcast(DMAX, (double)(alpha * x[row]));
                    for (col = 0; col < DMAX.loopBound(row + 1); col += DMAX.length()) {
                        DoubleVector vx = DoubleVector.fromArray(DMAX, (double[])x, (int)col);
                        DoubleVector va = DoubleVector.fromArray(DMAX, (double[])a, (int)(col + row * n));
                        vx.fma((Vector)valphaxrow, (Vector)va).intoArray(a, col + row * n);
                    }
                    while (col < row + 1) {
                        int n2 = col + row * n;
                        a[n2] = a[n2] + alpha * x[row] * x[col];
                        ++col;
                    }
                }
            }
        } else {
            super.dsyr(uplo, n, alpha, x, incx, a, lda);
        }
    }

    public void dgemv(String trans, int m, int n, double alpha, double[] a, int lda, double[] x, int incx, double beta, double[] y, int incy) {
        if ("T".equals(trans) && m >= 0 && n >= 0 && lda == m && a != null && a.length >= m * n && x != null && x.length >= m && incx == 1 && y != null && y.length >= n && incy == 1) {
            if (alpha != 0.0 || beta != 1.0) {
                for (int col = 0; col < n; ++col) {
                    int row;
                    double sum = 0.0;
                    DoubleVector vsum = DoubleVector.zero(DMAX);
                    for (row = 0; row < DMAX.loopBound(m); row += DMAX.length()) {
                        DoubleVector vx = DoubleVector.fromArray(DMAX, (double[])x, (int)row);
                        DoubleVector va = DoubleVector.fromArray(DMAX, (double[])a, (int)(row + col * m));
                        vsum = va.fma((Vector)vx, (Vector)vsum);
                    }
                    sum += vsum.reduceLanes(VectorOperators.ADD);
                    while (row < m) {
                        sum += x[row] * a[row + col * m];
                        ++row;
                    }
                    y[col] = alpha * sum + beta * y[col];
                }
            }
        } else {
            super.dgemv(trans, m, n, alpha, a, lda, x, incx, beta, y, incy);
        }
    }

    public void sgemv(String trans, int m, int n, float alpha, float[] a, int lda, float[] x, int incx, float beta, float[] y, int incy) {
        if ("T".equals(trans) && m >= 0 && n >= 0 && a != null && a.length >= m * n && lda == m && x != null && x.length >= m && incx == 1 && y != null && y.length >= n && incy == 1) {
            this.sscal(n, beta, y, 1);
            if ((double)alpha != 0.0) {
                FloatVector valpha = FloatVector.broadcast(FMAX, (float)alpha);
                for (int col = 0; col < n; ++col) {
                    int row;
                    FloatVector vsum = FloatVector.zero(FMAX);
                    for (row = 0; row < FMAX.loopBound(m); row += FMAX.length()) {
                        FloatVector vx = FloatVector.fromArray(FMAX, (float[])x, (int)row);
                        FloatVector va = FloatVector.fromArray(FMAX, (float[])a, (int)(row + col * m));
                        vsum = valpha.mul((Vector)va).fma((Vector)vx, (Vector)vsum);
                    }
                    int n2 = col;
                    y[n2] = y[n2] + vsum.reduceLanes(VectorOperators.ADD);
                    while (row < m) {
                        int n3 = col;
                        y[n3] = y[n3] + alpha * x[row] * a[row + col * m];
                        ++row;
                    }
                }
            }
        } else {
            super.sgemv(trans, m, n, alpha, a, lda, x, incx, beta, y, incy);
        }
    }

    public void dgemm(String transa, String transb, int m, int n, int k, double alpha, double[] a, int lda, double[] b, int ldb, double beta, double[] c, int ldc) {
        if ("N".equals(transa) && "N".equals(transb) && m >= 0 && n >= 0 && k >= 0 && a != null && a.length >= m * k && lda == m && b != null && b.length >= k * n && ldb == k && c != null && c.length >= m * n && ldc == m) {
            this.dscal(m * n, beta, c, 1);
            if (alpha != 0.0) {
                DoubleVector valpha = DoubleVector.broadcast(DMAX, (double)alpha);
                for (int col = 0; col < n; ++col) {
                    for (int i = 0; i < k; ++i) {
                        int row;
                        for (row = 0; row < DMAX.loopBound(m); row += DMAX.length()) {
                            DoubleVector va = DoubleVector.fromArray(DMAX, (double[])a, (int)(i * m + row));
                            DoubleVector vc = DoubleVector.fromArray(DMAX, (double[])c, (int)(col * m + row));
                            valpha.mul(b[col * k + i]).fma((Vector)va, (Vector)vc).intoArray(c, col * m + row);
                        }
                        while (row < m) {
                            int n2 = col * m + row;
                            c[n2] = c[n2] + alpha * a[i * m + row] * b[col * k + i];
                            ++row;
                        }
                    }
                }
            }
        } else if ("N".equals(transa) && "T".equals(transb) && m >= 0 && n >= 0 && k >= 0 && a != null && a.length >= m * k && lda == m && b != null && b.length >= k * n && ldb == n && c != null && c.length >= m * n && ldc == m) {
            this.dscal(m * n, beta, c, 1);
            if (alpha != 0.0) {
                DoubleVector valpha = DoubleVector.broadcast(DMAX, (double)alpha);
                for (int i = 0; i < k; ++i) {
                    for (int col = 0; col < n; ++col) {
                        int row;
                        for (row = 0; row < DMAX.loopBound(m); row += DMAX.length()) {
                            DoubleVector va = DoubleVector.fromArray(DMAX, (double[])a, (int)(i * m + row));
                            DoubleVector vc = DoubleVector.fromArray(DMAX, (double[])c, (int)(col * m + row));
                            valpha.mul(b[col + i * n]).fma((Vector)va, (Vector)vc).intoArray(c, col * m + row);
                        }
                        while (row < m) {
                            int n3 = col * m + row;
                            c[n3] = c[n3] + alpha * a[i * m + row] * b[col + i * n];
                            ++row;
                        }
                    }
                }
            }
        } else if ("T".equals(transa) && "N".equals(transb) && m >= 0 && n >= 0 && k >= 0 && a != null && a.length >= m * k && lda == k && b != null && b.length >= k * n && ldb == k && c != null && c.length >= m * n && ldc == m) {
            if (alpha != 0.0 || beta != 1.0) {
                for (int col = 0; col < n; ++col) {
                    for (int row = 0; row < m; ++row) {
                        int i;
                        double sum = 0.0;
                        DoubleVector vsum = DoubleVector.zero(DMAX);
                        for (i = 0; i < DMAX.loopBound(k); i += DMAX.length()) {
                            DoubleVector va = DoubleVector.fromArray(DMAX, (double[])a, (int)(i + row * k));
                            DoubleVector vb = DoubleVector.fromArray(DMAX, (double[])b, (int)(col * k + i));
                            vsum = va.fma((Vector)vb, (Vector)vsum);
                        }
                        sum += vsum.reduceLanes(VectorOperators.ADD);
                        while (i < k) {
                            sum += a[i + row * k] * b[col * k + i];
                            ++i;
                        }
                        c[col * m + row] = beta != 0.0 ? alpha * sum + beta * c[col * m + row] : alpha * sum;
                    }
                }
            }
        } else if ("T".equals(transa) && "T".equals(transb) && m >= 0 && n >= 0 && k >= 0 && a != null && a.length >= m * k && lda == k && b != null && b.length >= k * n && ldb == n && c != null && c.length >= m * n && ldc == m) {
            if (alpha != 0.0 || beta != 1.0) {
                for (int col = 0; col < n; ++col) {
                    for (int row = 0; row < m; ++row) {
                        double sum = 0.0;
                        for (int i = 0; i < k; ++i) {
                            sum += a[i + row * k] * b[col + i * n];
                        }
                        c[col * m + row] = beta != 0.0 ? alpha * sum + beta * c[col * m + row] : alpha * sum;
                    }
                }
            }
        } else {
            super.dgemm(transa, transb, m, n, k, alpha, a, lda, b, ldb, beta, c, ldc);
        }
    }
}

