/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.blas.benchmarks;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.F2jBLAS;
import dev.ludovic.blas.VectorizedBLAS;
import java.util.Random;

abstract class BLASBenchmark {
    protected final BLAS nativeBLAS = BLAS.getInstance();
    protected final BLAS f2jBLAS = new F2jBLAS();
    protected final BLAS vectorizedBLAS = new VectorizedBLAS();
    private final Random rand = new Random(0L);

    BLASBenchmark() {
    }

    protected double randomDouble() {
        return this.rand.nextDouble();
    }

    protected double[] randomDoubleArray(int n) {
        double[] res = new double[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.rand.nextDouble();
        }
        return res;
    }

    protected float randomFloat() {
        return this.rand.nextFloat();
    }

    protected float[] randomFloatArray(int n) {
        float[] res = new float[n];
        for (int i = 0; i < n; ++i) {
            res[i] = this.rand.nextFloat();
        }
        return res;
    }
}

