/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.blas.benchmarks;

import dev.ludovic.blas.benchmarks.BLASBenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@Fork(value=1, jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
public class SgemvBenchmark
extends BLASBenchmark {
    @Param(value={"N", "T"})
    public String trans;
    @Param(value={"10", "10000"})
    public int m;
    @Param(value={"10", "10000"})
    public int n;
    public float alpha;
    public float[] a;
    public float[] x;
    public float beta;
    public float[] y;

    @Setup
    public void setup() {
        this.alpha = this.randomFloat();
        this.a = this.randomFloatArray(this.m * this.n);
        this.x = this.randomFloatArray(this.trans.equals("T") ? this.m : this.n);
        this.beta = this.randomFloat();
        this.y = this.randomFloatArray(this.trans.equals("T") ? this.n : this.m);
    }

    @Benchmark
    public void f2j(Blackhole bh) {
        this.f2jBLAS.sgemv(this.trans, this.m, this.n, this.alpha, this.a, this.m, this.x, 1, this.beta, this.y, 1);
        bh.consume((Object)this.y);
    }

    @Benchmark
    public void vector(Blackhole bh) {
        this.vectorizedBLAS.sgemv(this.trans, this.m, this.n, this.alpha, this.a, this.m, this.x, 1, this.beta, this.y, 1);
        bh.consume((Object)this.y);
    }

    @Benchmark
    public void blas(Blackhole bh) {
        this.nativeBLAS.sgemv(this.trans, this.m, this.n, this.alpha, this.a, this.m, this.x, 1, this.beta, this.y, 1);
        bh.consume((Object)this.y);
    }
}

