/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.blas.benchmarks;

import dev.ludovic.blas.benchmarks.BLASBenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@Fork(value=1, jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
public class SdotBenchmark
extends BLASBenchmark {
    @Param(value={"100", "10000000"})
    public int n;
    public float[] x;
    public float[] y;

    @Setup
    public void setup() {
        this.x = this.randomFloatArray(this.n);
        this.y = this.randomFloatArray(this.n);
    }

    @Benchmark
    public void f2j(Blackhole bh) {
        bh.consume(this.f2jBLAS.sdot(this.n, this.x, 1, this.y, 1));
    }

    @Benchmark
    public void vector(Blackhole bh) {
        bh.consume(this.vectorizedBLAS.sdot(this.n, this.x, 1, this.y, 1));
    }

    @Benchmark
    public void blas(Blackhole bh) {
        bh.consume(this.nativeBLAS.sdot(this.n, this.x, 1, this.y, 1));
    }
}

