/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.blas.benchmarks;

import dev.ludovic.blas.benchmarks.BLASBenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Thread)
@Fork(value=1, jvmArgsPrepend={"--add-modules=jdk.incubator.vector"})
public class DsprBenchmark
extends BLASBenchmark {
    @Param(value={"10", "1000"})
    public int n;
    public double alpha;
    public double[] a;
    public double[] x;

    @Setup
    public void setup() {
        this.alpha = this.randomDouble();
        this.a = this.randomDoubleArray(this.n * (this.n + 1) / 2);
        this.x = this.randomDoubleArray(this.n);
    }

    @Benchmark
    public void f2j(Blackhole bh) {
        this.f2jBLAS.dspr("U", this.n, this.alpha, this.x, 1, this.a);
        bh.consume((Object)this.a);
    }

    @Benchmark
    public void vector(Blackhole bh) {
        this.vectorizedBLAS.dspr("U", this.n, this.alpha, this.x, 1, this.a);
        bh.consume((Object)this.a);
    }

    @Benchmark
    public void blas(Blackhole bh) {
        this.nativeBLAS.dspr("U", this.n, this.alpha, this.x, 1, this.a);
        bh.consume((Object)this.a);
    }
}

