/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.lapack;

import dev.ludovic.netlib.NativeLAPACK;
import dev.ludovic.netlib.lapack.AbstractLAPACK;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermissions;
import org.netlib.util.StringW;
import org.netlib.util.booleanW;
import org.netlib.util.doubleW;
import org.netlib.util.floatW;
import org.netlib.util.intW;

public final class JNILAPACK
extends AbstractLAPACK
implements NativeLAPACK {
    private static final JNILAPACK instance = new JNILAPACK();

    protected JNILAPACK() {
        Path temp;
        String osName = System.getProperty("os.name");
        if (osName == null || osName.isEmpty()) {
            throw new RuntimeException("Unable to load native implementation");
        }
        String osArch = System.getProperty("os.arch");
        if (osArch == null || osArch.isEmpty()) {
            throw new RuntimeException("Unable to load native implementation");
        }
        try (InputStream resource = this.getClass().getClassLoader().getResourceAsStream(String.format("resources/native/%s-%s/libnetliblapackjni.so", osName, osArch));){
            assert (resource != null);
            temp = Files.createTempFile("libnetliblapackjni.so", "", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxr-x---")));
            Files.copy(resource, temp, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load native implementation", e);
        }
        System.load(temp.toString());
    }

    public static NativeLAPACK getInstance() {
        return instance;
    }

    @Override
    protected native void dbdsdcK(String var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int[] var16, int var17, double[] var18, int var19, int[] var20, int var21, intW var22);

    @Override
    protected native void dbdsqrK(String var1, int var2, int var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, int var18, double[] var19, int var20, intW var21);

    @Override
    protected native void ddisnaK(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, intW var8);

    @Override
    protected native void dgbbrdK(String var1, int var2, int var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, double[] var20, int var21, int var22, double[] var23, int var24, intW var25);

    @Override
    protected native void dgbconK(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, int[] var8, int var9, double var10, doubleW var12, double[] var13, int var14, int[] var15, int var16, intW var17);

    @Override
    protected native void dgbequK(int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, doubleW var12, doubleW var13, doubleW var14, intW var15);

    @Override
    protected native void dgbrfsK(String var1, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, int[] var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, double[] var20, int var21, double[] var22, int var23, double[] var24, int var25, int[] var26, int var27, intW var28);

    @Override
    protected native void dgbsvK(int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, int[] var8, int var9, double[] var10, int var11, int var12, intW var13);

    @Override
    protected native void dgbsvxK(String var1, String var2, int var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, int[] var13, int var14, StringW var15, double[] var16, int var17, double[] var18, int var19, double[] var20, int var21, int var22, double[] var23, int var24, int var25, doubleW var26, double[] var27, int var28, double[] var29, int var30, double[] var31, int var32, int[] var33, int var34, intW var35);

    @Override
    protected native void dgbtf2K(int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, int[] var8, int var9, intW var10);

    @Override
    protected native void dgbtrfK(int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, int[] var8, int var9, intW var10);

    @Override
    protected native void dgbtrsK(String var1, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, int[] var9, int var10, double[] var11, int var12, int var13, intW var14);

    @Override
    protected native void dgebakK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dgebalK(String var1, int var2, double[] var3, int var4, int var5, intW var6, intW var7, double[] var8, int var9, intW var10);

    @Override
    protected native void dgebd2K(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, intW var16);

    @Override
    protected native void dgebrdK(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, int var16, intW var17);

    @Override
    protected native void dgeconK(String var1, int var2, double[] var3, int var4, int var5, double var6, doubleW var8, double[] var9, int var10, int[] var11, int var12, intW var13);

    @Override
    protected native void dgeequK(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, doubleW var10, doubleW var11, doubleW var12, intW var13);

    @Override
    protected native void dgeesK(String var1, String var2, Object var3, int var4, double[] var5, int var6, int var7, intW var8, double[] var9, int var10, double[] var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, int var18, boolean[] var19, int var20, intW var21);

    @Override
    protected native void dgeesxK(String var1, String var2, Object var3, String var4, int var5, double[] var6, int var7, int var8, intW var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, int var16, doubleW var17, doubleW var18, double[] var19, int var20, int var21, int[] var22, int var23, int var24, boolean[] var25, int var26, intW var27);

    @Override
    protected native void dgeevK(String var1, String var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, intW var20);

    @Override
    protected native void dgeevxK(String var1, String var2, String var3, String var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, int var18, intW var19, intW var20, double[] var21, int var22, doubleW var23, double[] var24, int var25, double[] var26, int var27, double[] var28, int var29, int var30, int[] var31, int var32, intW var33);

    @Override
    protected native void dgegsK(String var1, String var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, double[] var16, int var17, int var18, double[] var19, int var20, int var21, double[] var22, int var23, int var24, intW var25);

    @Override
    protected native void dgegvK(String var1, String var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, double[] var16, int var17, int var18, double[] var19, int var20, int var21, double[] var22, int var23, int var24, intW var25);

    @Override
    protected native void dgehd2K(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, intW var11);

    @Override
    protected native void dgehrdK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dgelq2K(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, intW var10);

    @Override
    protected native void dgelqfK(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dgelsK(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, intW var14);

    @Override
    protected native void dgelsdK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double var12, intW var14, double[] var15, int var16, int var17, int[] var18, int var19, intW var20);

    @Override
    protected native void dgelssK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double var12, intW var14, double[] var15, int var16, int var17, intW var18);

    @Override
    protected native void dgelsxK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, int[] var10, int var11, double var12, intW var14, double[] var15, int var16, intW var17);

    @Override
    protected native void dgelsyK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, int[] var10, int var11, double var12, intW var14, double[] var15, int var16, int var17, intW var18);

    @Override
    protected native void dgeql2K(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, intW var10);

    @Override
    protected native void dgeqlfK(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dgeqp3K(int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, intW var13);

    @Override
    protected native void dgeqpfK(int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, double[] var10, int var11, intW var12);

    @Override
    protected native void dgeqr2K(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, intW var10);

    @Override
    protected native void dgeqrfK(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dgerfsK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, int[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19, double[] var20, int var21, double[] var22, int var23, int[] var24, int var25, intW var26);

    @Override
    protected native void dgerq2K(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, intW var10);

    @Override
    protected native void dgerqfK(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dgesc2K(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int[] var7, int var8, int[] var9, int var10, doubleW var11);

    @Override
    protected native void dgesddK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, int[] var18, int var19, intW var20);

    @Override
    protected native void dgesvK(int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dgesvdK(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, int var18, intW var19);

    @Override
    protected native void dgesvxK(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, int[] var11, int var12, StringW var13, double[] var14, int var15, double[] var16, int var17, double[] var18, int var19, int var20, double[] var21, int var22, int var23, doubleW var24, double[] var25, int var26, double[] var27, int var28, double[] var29, int var30, int[] var31, int var32, intW var33);

    @Override
    protected native void dgetc2K(int var1, double[] var2, int var3, int var4, int[] var5, int var6, int[] var7, int var8, intW var9);

    @Override
    protected native void dgetf2K(int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, intW var8);

    @Override
    protected native void dgetrfK(int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, intW var8);

    @Override
    protected native void dgetriK(int var1, double[] var2, int var3, int var4, int[] var5, int var6, double[] var7, int var8, int var9, intW var10);

    @Override
    protected native void dgetrsK(String var1, int var2, int var3, double[] var4, int var5, int var6, int[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dggbakK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, intW var14);

    @Override
    protected native void dggbalK(String var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, int var8, intW var9, intW var10, double[] var11, int var12, double[] var13, int var14, double[] var15, int var16, intW var17);

    @Override
    protected native void dggesK(String var1, String var2, String var3, Object var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, intW var12, double[] var13, int var14, double[] var15, int var16, double[] var17, int var18, double[] var19, int var20, int var21, double[] var22, int var23, int var24, double[] var25, int var26, int var27, boolean[] var28, int var29, intW var30);

    @Override
    protected native void dggesxK(String var1, String var2, String var3, Object var4, String var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, intW var13, double[] var14, int var15, double[] var16, int var17, double[] var18, int var19, double[] var20, int var21, int var22, double[] var23, int var24, int var25, double[] var26, int var27, double[] var28, int var29, double[] var30, int var31, int var32, int[] var33, int var34, int var35, boolean[] var36, int var37, intW var38);

    @Override
    protected native void dggevK(String var1, String var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, double[] var16, int var17, int var18, double[] var19, int var20, int var21, double[] var22, int var23, int var24, intW var25);

    @Override
    protected native void dggevxK(String var1, String var2, String var3, String var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, double[] var14, int var15, double[] var16, int var17, double[] var18, int var19, int var20, double[] var21, int var22, int var23, intW var24, intW var25, double[] var26, int var27, double[] var28, int var29, doubleW var30, doubleW var31, double[] var32, int var33, double[] var34, int var35, double[] var36, int var37, int var38, int[] var39, int var40, boolean[] var41, int var42, intW var43);

    @Override
    protected native void dggglmK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, double[] var16, int var17, int var18, intW var19);

    @Override
    protected native void dgghrdK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, intW var18);

    @Override
    protected native void dgglseK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, double[] var16, int var17, int var18, intW var19);

    @Override
    protected native void dggqrfK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, double[] var14, int var15, int var16, intW var17);

    @Override
    protected native void dggrqfK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, double[] var14, int var15, int var16, intW var17);

    @Override
    protected native void dggsvdK(String var1, String var2, String var3, int var4, int var5, int var6, intW var7, intW var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, double[] var17, int var18, double[] var19, int var20, int var21, double[] var22, int var23, int var24, double[] var25, int var26, int var27, double[] var28, int var29, int[] var30, int var31, intW var32);

    @Override
    protected native void dggsvpK(String var1, String var2, String var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double var13, double var15, intW var17, intW var18, double[] var19, int var20, int var21, double[] var22, int var23, int var24, double[] var25, int var26, int var27, int[] var28, int var29, double[] var30, int var31, double[] var32, int var33, intW var34);

    @Override
    protected native void dgtconK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, int[] var11, int var12, double var13, doubleW var15, double[] var16, int var17, int[] var18, int var19, intW var20);

    @Override
    protected native void dgtrfsK(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, double[] var16, int var17, int[] var18, int var19, double[] var20, int var21, int var22, double[] var23, int var24, int var25, double[] var26, int var27, double[] var28, int var29, double[] var30, int var31, int[] var32, int var33, intW var34);

    @Override
    protected native void dgtsvK(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dgtsvxK(String var1, String var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, double[] var13, int var14, double[] var15, int var16, double[] var17, int var18, int[] var19, int var20, double[] var21, int var22, int var23, double[] var24, int var25, int var26, doubleW var27, double[] var28, int var29, double[] var30, int var31, double[] var32, int var33, int[] var34, int var35, intW var36);

    @Override
    protected native void dgttrfK(int var1, double[] var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, int[] var10, int var11, intW var12);

    @Override
    protected native void dgttrsK(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, int[] var12, int var13, double[] var14, int var15, int var16, intW var17);

    @Override
    protected native void dgtts2K(int var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, int[] var12, int var13, double[] var14, int var15, int var16);

    @Override
    protected native void dhgeqzK(String var1, String var2, String var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, double[] var15, int var16, double[] var17, int var18, double[] var19, int var20, int var21, double[] var22, int var23, int var24, double[] var25, int var26, int var27, intW var28);

    @Override
    protected native void dhseinK(String var1, String var2, String var3, boolean[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, int var20, intW var21, double[] var22, int var23, int[] var24, int var25, int[] var26, int var27, intW var28);

    @Override
    protected native void dhseqrK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, int var18, intW var19);

    @Override
    protected native boolean disnanK(double var1);

    @Override
    protected native void dlabadK(doubleW var1, doubleW var2);

    @Override
    protected native void dlabrdK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, double[] var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19, int var20);

    @Override
    protected native void dlacn2K(int var1, double[] var2, int var3, double[] var4, int var5, int[] var6, int var7, doubleW var8, intW var9, int[] var10, int var11);

    @Override
    protected native void dlaconK(int var1, double[] var2, int var3, double[] var4, int var5, int[] var6, int var7, doubleW var8, intW var9);

    @Override
    protected native void dlacpyK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9);

    @Override
    protected native void dladivK(double var1, double var3, double var5, double var7, doubleW var9, doubleW var10);

    @Override
    protected native void dlae2K(double var1, double var3, double var5, doubleW var7, doubleW var8);

    @Override
    protected native void dlaebzK(int var1, int var2, int var3, int var4, int var5, int var6, double var7, double var9, double var11, double[] var13, int var14, double[] var15, int var16, double[] var17, int var18, int[] var19, int var20, double[] var21, int var22, double[] var23, int var24, intW var25, int[] var26, int var27, double[] var28, int var29, int[] var30, int var31, intW var32);

    @Override
    protected native void dlaed0K(int var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int[] var16, int var17, intW var18);

    @Override
    protected native void dlaed1K(int var1, double[] var2, int var3, double[] var4, int var5, int var6, int[] var7, int var8, doubleW var9, int var10, double[] var11, int var12, int[] var13, int var14, intW var15);

    @Override
    protected native void dlaed2K(intW var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, int var8, int[] var9, int var10, doubleW var11, double[] var12, int var13, double[] var14, int var15, double[] var16, int var17, double[] var18, int var19, int[] var20, int var21, int[] var22, int var23, int[] var24, int var25, int[] var26, int var27, intW var28);

    @Override
    protected native void dlaed3K(int var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, int var8, double var9, double[] var11, int var12, double[] var13, int var14, int[] var15, int var16, int[] var17, int var18, double[] var19, int var20, double[] var21, int var22, intW var23);

    @Override
    protected native void dlaed4K(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, double var9, doubleW var11, intW var12);

    @Override
    protected native void dlaed5K(int var1, double[] var2, int var3, double[] var4, int var5, double[] var6, int var7, double var8, doubleW var10);

    @Override
    protected native void dlaed6K(int var1, boolean var2, double var3, double[] var5, int var6, double[] var7, int var8, double var9, doubleW var11, intW var12);

    @Override
    protected native void dlaed7K(int var1, int var2, int var3, int var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, int[] var12, int var13, doubleW var14, int var15, double[] var16, int var17, int[] var18, int var19, int[] var20, int var21, int[] var22, int var23, int[] var24, int var25, int[] var26, int var27, double[] var28, int var29, double[] var30, int var31, int[] var32, int var33, intW var34);

    @Override
    protected native void dlaed8K(int var1, intW var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, int[] var10, int var11, doubleW var12, int var13, double[] var14, int var15, double[] var16, int var17, double[] var18, int var19, int var20, double[] var21, int var22, int[] var23, int var24, intW var25, int[] var26, int var27, double[] var28, int var29, int[] var30, int var31, int[] var32, int var33, intW var34);

    @Override
    protected native void dlaed9K(int var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, double var10, double[] var12, int var13, double[] var14, int var15, double[] var16, int var17, int var18, intW var19);

    @Override
    protected native void dlaedaK(int var1, int var2, int var3, int var4, int[] var5, int var6, int[] var7, int var8, int[] var9, int var10, int[] var11, int var12, double[] var13, int var14, double[] var15, int var16, int[] var17, int var18, double[] var19, int var20, double[] var21, int var22, intW var23);

    @Override
    protected native void dlaeinK(boolean var1, boolean var2, int var3, double[] var4, int var5, int var6, double var7, double var9, double[] var11, int var12, double[] var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19, double var20, double var22, double var24, intW var26);

    @Override
    protected native void dlaev2K(double var1, double var3, double var5, doubleW var7, doubleW var8, doubleW var9, doubleW var10);

    @Override
    protected native void dlaexcK(boolean var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, int var8, int var9, int var10, int var11, double[] var12, int var13, intW var14);

    @Override
    protected native void dlag2K(double[] var1, int var2, int var3, double[] var4, int var5, int var6, double var7, doubleW var9, doubleW var10, doubleW var11, doubleW var12, doubleW var13);

    @Override
    protected native void dlag2sK(int var1, int var2, double[] var3, int var4, int var5, float[] var6, int var7, int var8, intW var9);

    @Override
    protected native void dlags2K(boolean var1, double var2, double var4, double var6, double var8, double var10, double var12, doubleW var14, doubleW var15, doubleW var16, doubleW var17, doubleW var18, doubleW var19);

    @Override
    protected native void dlagtfK(int var1, double[] var2, int var3, double var4, double[] var6, int var7, double[] var8, int var9, double var10, double[] var12, int var13, int[] var14, int var15, intW var16);

    @Override
    protected native void dlagtmK(String var1, int var2, int var3, double var4, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, double var15, double[] var17, int var18, int var19);

    @Override
    protected native void dlagtsK(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, int[] var11, int var12, double[] var13, int var14, doubleW var15, intW var16);

    @Override
    protected native void dlagv2K(double[] var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, doubleW var13, doubleW var14, doubleW var15, doubleW var16);

    @Override
    protected native void dlahqrK(boolean var1, boolean var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, int var14, double[] var15, int var16, int var17, intW var18);

    @Override
    protected native void dlahr2K(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14);

    @Override
    protected native void dlahrdK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14);

    @Override
    protected native void dlaic1K(int var1, int var2, double[] var3, int var4, double var5, double[] var7, int var8, double var9, doubleW var11, doubleW var12, doubleW var13);

    @Override
    protected native boolean dlaisnanK(double var1, double var3);

    @Override
    protected native void dlaln2K(boolean var1, int var2, int var3, double var4, double var6, double[] var8, int var9, int var10, double var11, double var13, double[] var15, int var16, int var17, double var18, double var20, double[] var22, int var23, int var24, doubleW var25, doubleW var26, intW var27);

    @Override
    protected native void dlals0K(int var1, int var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, int[] var12, int var13, int var14, int[] var15, int var16, int var17, double[] var18, int var19, int var20, double[] var21, int var22, double[] var23, int var24, double[] var25, int var26, double[] var27, int var28, int var29, double var30, double var32, double[] var34, int var35, intW var36);

    @Override
    protected native void dlalsaK(int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int[] var16, int var17, double[] var18, int var19, double[] var20, int var21, double[] var22, int var23, double[] var24, int var25, int[] var26, int var27, int[] var28, int var29, int var30, int[] var31, int var32, double[] var33, int var34, double[] var35, int var36, double[] var37, int var38, double[] var39, int var40, int[] var41, int var42, intW var43);

    @Override
    protected native void dlalsdK(String var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double var12, intW var14, double[] var15, int var16, int[] var17, int var18, intW var19);

    @Override
    protected native void dlamrgK(int var1, int var2, double[] var3, int var4, int var5, int var6, int[] var7, int var8);

    @Override
    protected native int dlanegK(int var1, double[] var2, int var3, double[] var4, int var5, double var6, double var8, int var10);

    @Override
    protected native double dlangbK(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9);

    @Override
    protected native double dlangeK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8);

    @Override
    protected native double dlangtK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8);

    @Override
    protected native double dlanhsK(String var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7);

    @Override
    protected native double dlansbK(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9);

    @Override
    protected native double dlanspK(String var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7);

    @Override
    protected native double dlanstK(String var1, int var2, double[] var3, int var4, double[] var5, int var6);

    @Override
    protected native double dlansyK(String var1, String var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8);

    @Override
    protected native double dlantbK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10);

    @Override
    protected native double dlantpK(String var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8);

    @Override
    protected native double dlantrK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10);

    @Override
    protected native void dlanv2K(doubleW var1, doubleW var2, doubleW var3, doubleW var4, doubleW var5, doubleW var6, doubleW var7, doubleW var8, doubleW var9, doubleW var10);

    @Override
    protected native void dlapllK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7, doubleW var8);

    @Override
    protected native void dlapmtK(boolean var1, int var2, int var3, double[] var4, int var5, int var6, int[] var7, int var8);

    @Override
    protected native double dlapy2K(double var1, double var3);

    @Override
    protected native double dlapy3K(double var1, double var3, double var5);

    @Override
    protected native void dlaqgbK(int var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, double var12, double var14, double var16, StringW var18);

    @Override
    protected native void dlaqgeK(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, double var10, double var12, double var14, StringW var16);

    @Override
    protected native void dlaqp2K(int var1, int var2, int var3, double[] var4, int var5, int var6, int[] var7, int var8, double[] var9, int var10, double[] var11, int var12, double[] var13, int var14, double[] var15, int var16);

    @Override
    protected native void dlaqpsK(int var1, int var2, int var3, int var4, intW var5, double[] var6, int var7, int var8, int[] var9, int var10, double[] var11, int var12, double[] var13, int var14, double[] var15, int var16, double[] var17, int var18, double[] var19, int var20, int var21);

    @Override
    protected native void dlaqr0K(boolean var1, boolean var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19, int var20, intW var21);

    @Override
    protected native void dlaqr1K(int var1, double[] var2, int var3, int var4, double var5, double var7, double var9, double var11, double[] var13, int var14);

    @Override
    protected native void dlaqr2K(boolean var1, boolean var2, int var3, int var4, int var5, int var6, double[] var7, int var8, int var9, int var10, int var11, double[] var12, int var13, int var14, intW var15, intW var16, double[] var17, int var18, double[] var19, int var20, double[] var21, int var22, int var23, int var24, double[] var25, int var26, int var27, int var28, double[] var29, int var30, int var31, double[] var32, int var33, int var34);

    @Override
    protected native void dlaqr3K(boolean var1, boolean var2, int var3, int var4, int var5, int var6, double[] var7, int var8, int var9, int var10, int var11, double[] var12, int var13, int var14, intW var15, intW var16, double[] var17, int var18, double[] var19, int var20, double[] var21, int var22, int var23, int var24, double[] var25, int var26, int var27, int var28, double[] var29, int var30, int var31, double[] var32, int var33, int var34);

    @Override
    protected native void dlaqr4K(boolean var1, boolean var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19, int var20, intW var21);

    @Override
    protected native void dlaqr5K(boolean var1, boolean var2, int var3, int var4, int var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, int var15, int var16, double[] var17, int var18, int var19, double[] var20, int var21, int var22, double[] var23, int var24, int var25, int var26, double[] var27, int var28, int var29, int var30, double[] var31, int var32, int var33);

    @Override
    protected native void dlaqsbK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double var9, double var11, StringW var13);

    @Override
    protected native void dlaqspK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, double var7, double var9, StringW var11);

    @Override
    protected native void dlaqsyK(String var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double var8, double var10, StringW var12);

    @Override
    protected native void dlaqtrK(boolean var1, boolean var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double var9, doubleW var11, double[] var12, int var13, double[] var14, int var15, intW var16);

    @Override
    protected native void dlar1vK(int var1, int var2, int var3, double var4, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, double var14, double var16, double[] var18, int var19, boolean var20, intW var21, doubleW var22, doubleW var23, intW var24, int[] var25, int var26, doubleW var27, doubleW var28, doubleW var29, double[] var30, int var31);

    @Override
    protected native void dlar2vK(int var1, double[] var2, int var3, double[] var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13);

    @Override
    protected native void dlarfK(String var1, int var2, int var3, double[] var4, int var5, int var6, double var7, double[] var9, int var10, int var11, double[] var12, int var13);

    @Override
    protected native void dlarfbK(String var1, String var2, String var3, String var4, int var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19);

    @Override
    protected native void dlarfgK(int var1, doubleW var2, double[] var3, int var4, int var5, doubleW var6);

    @Override
    protected native void dlarftK(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12);

    @Override
    protected native void dlarfxK(String var1, int var2, int var3, double[] var4, int var5, double var6, double[] var8, int var9, int var10, double[] var11, int var12);

    @Override
    protected native void dlargvK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10);

    @Override
    protected native void dlarnvK(int var1, int[] var2, int var3, int var4, double[] var5, int var6);

    @Override
    protected native void dlarraK(int var1, double[] var2, int var3, double[] var4, int var5, double[] var6, int var7, double var8, double var10, intW var12, int[] var13, int var14, intW var15);

    @Override
    protected native void dlarrbK(int var1, double[] var2, int var3, double[] var4, int var5, int var6, int var7, double var8, double var10, int var12, double[] var13, int var14, double[] var15, int var16, double[] var17, int var18, double[] var19, int var20, int[] var21, int var22, double var23, double var25, int var27, intW var28);

    @Override
    protected native void dlarrcK(String var1, int var2, double var3, double var5, double[] var7, int var8, double[] var9, int var10, double var11, intW var13, intW var14, intW var15, intW var16);

    @Override
    protected native void dlarrdK(String var1, String var2, int var3, double var4, double var6, int var8, int var9, double[] var10, int var11, double var12, double[] var14, int var15, double[] var16, int var17, double[] var18, int var19, double var20, int var22, int[] var23, int var24, intW var25, double[] var26, int var27, double[] var28, int var29, doubleW var30, doubleW var31, int[] var32, int var33, int[] var34, int var35, double[] var36, int var37, int[] var38, int var39, intW var40);

    @Override
    protected native void dlarreK(String var1, int var2, doubleW var3, doubleW var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, double var13, double var15, double var17, intW var19, int[] var20, int var21, intW var22, double[] var23, int var24, double[] var25, int var26, double[] var27, int var28, int[] var29, int var30, int[] var31, int var32, double[] var33, int var34, doubleW var35, double[] var36, int var37, int[] var38, int var39, intW var40);

    @Override
    protected native void dlarrfK(int var1, double[] var2, int var3, double[] var4, int var5, double[] var6, int var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, double var16, double var18, double var20, double var22, doubleW var24, double[] var25, int var26, double[] var27, int var28, double[] var29, int var30, intW var31);

    @Override
    protected native void dlarrjK(int var1, double[] var2, int var3, double[] var4, int var5, int var6, int var7, double var8, int var10, double[] var11, int var12, double[] var13, int var14, double[] var15, int var16, int[] var17, int var18, double var19, double var21, intW var23);

    @Override
    protected native void dlarrkK(int var1, int var2, double var3, double var5, double[] var7, int var8, double[] var9, int var10, double var11, double var13, doubleW var15, doubleW var16, intW var17);

    @Override
    protected native void dlarrrK(int var1, double[] var2, int var3, double[] var4, int var5, intW var6);

    @Override
    protected native void dlarrvK(int var1, double var2, double var4, double[] var6, int var7, double[] var8, int var9, double var10, int[] var12, int var13, int var14, int var15, int var16, double var17, doubleW var19, doubleW var20, double[] var21, int var22, double[] var23, int var24, double[] var25, int var26, int[] var27, int var28, int[] var29, int var30, double[] var31, int var32, double[] var33, int var34, int var35, int[] var36, int var37, double[] var38, int var39, int[] var40, int var41, intW var42);

    @Override
    protected native void dlartgK(double var1, double var3, doubleW var5, doubleW var6, doubleW var7);

    @Override
    protected native void dlartvK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12);

    @Override
    protected native void dlaruvK(int[] var1, int var2, int var3, double[] var4, int var5);

    @Override
    protected native void dlarzK(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double var8, double[] var10, int var11, int var12, double[] var13, int var14);

    @Override
    protected native void dlarzbK(String var1, String var2, String var3, String var4, int var5, int var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19, int var20);

    @Override
    protected native void dlarztK(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12);

    @Override
    protected native void dlas2K(double var1, double var3, double var5, doubleW var7, doubleW var8);

    @Override
    protected native void dlasclK(String var1, int var2, int var3, double var4, double var6, int var8, int var9, double[] var10, int var11, int var12, intW var13);

    @Override
    protected native void dlasd0K(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, int var13, int[] var14, int var15, double[] var16, int var17, intW var18);

    @Override
    protected native void dlasd1K(int var1, int var2, int var3, double[] var4, int var5, doubleW var6, doubleW var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, int[] var14, int var15, int[] var16, int var17, double[] var18, int var19, intW var20);

    @Override
    protected native void dlasd2K(int var1, int var2, int var3, intW var4, double[] var5, int var6, double[] var7, int var8, double var9, double var11, double[] var13, int var14, int var15, double[] var16, int var17, int var18, double[] var19, int var20, double[] var21, int var22, int var23, double[] var24, int var25, int var26, int[] var27, int var28, int[] var29, int var30, int[] var31, int var32, int[] var33, int var34, int[] var35, int var36, intW var37);

    @Override
    protected native void dlasd3K(int var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19, int var20, double[] var21, int var22, int var23, int[] var24, int var25, int[] var26, int var27, double[] var28, int var29, intW var30);

    @Override
    protected native void dlasd4K(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, double var9, doubleW var11, double[] var12, int var13, intW var14);

    @Override
    protected native void dlasd5K(int var1, double[] var2, int var3, double[] var4, int var5, double[] var6, int var7, double var8, doubleW var10, double[] var11, int var12);

    @Override
    protected native void dlasd6K(int var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, doubleW var11, doubleW var12, int[] var13, int var14, int[] var15, int var16, intW var17, int[] var18, int var19, int var20, double[] var21, int var22, int var23, double[] var24, int var25, double[] var26, int var27, double[] var28, int var29, double[] var30, int var31, intW var32, doubleW var33, doubleW var34, double[] var35, int var36, int[] var37, int var38, intW var39);

    @Override
    protected native void dlasd7K(int var1, int var2, int var3, int var4, intW var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, double[] var14, int var15, double[] var16, int var17, double[] var18, int var19, double var20, double var22, double[] var24, int var25, int[] var26, int var27, int[] var28, int var29, int[] var30, int var31, int[] var32, int var33, intW var34, int[] var35, int var36, int var37, double[] var38, int var39, int var40, doubleW var41, doubleW var42, intW var43);

    @Override
    protected native void dlasd8K(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, double[] var18, int var19, intW var20);

    @Override
    protected native void dlasdaK(int var1, int var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int[] var14, int var15, double[] var16, int var17, double[] var18, int var19, double[] var20, int var21, double[] var22, int var23, int[] var24, int var25, int[] var26, int var27, int var28, int[] var29, int var30, double[] var31, int var32, double[] var33, int var34, double[] var35, int var36, double[] var37, int var38, int[] var39, int var40, intW var41);

    @Override
    protected native void dlasdqK(String var1, int var2, int var3, int var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, double[] var20, int var21, intW var22);

    @Override
    protected native void dlasdtK(int var1, intW var2, intW var3, int[] var4, int var5, int[] var6, int var7, int[] var8, int var9, int var10);

    @Override
    protected native void dlasetK(String var1, int var2, int var3, double var4, double var6, double[] var8, int var9, int var10);

    @Override
    protected native void dlasq1K(int var1, double[] var2, int var3, double[] var4, int var5, double[] var6, int var7, intW var8);

    @Override
    protected native void dlasq2K(int var1, double[] var2, int var3, intW var4);

    @Override
    protected native void dlasq3K(int var1, intW var2, double[] var3, int var4, int var5, doubleW var6, doubleW var7, doubleW var8, doubleW var9, intW var10, intW var11, intW var12, boolean var13);

    @Override
    protected native void dlasq4K(int var1, int var2, double[] var3, int var4, int var5, int var6, double var7, double var9, double var11, double var13, double var15, double var17, doubleW var19, intW var20);

    @Override
    protected native void dlasq5K(int var1, int var2, double[] var3, int var4, int var5, double var6, doubleW var8, doubleW var9, doubleW var10, doubleW var11, doubleW var12, doubleW var13, boolean var14);

    @Override
    protected native void dlasq6K(int var1, int var2, double[] var3, int var4, int var5, doubleW var6, doubleW var7, doubleW var8, doubleW var9, doubleW var10, doubleW var11);

    @Override
    protected native void dlasrK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12);

    @Override
    protected native void dlasrtK(String var1, int var2, double[] var3, int var4, intW var5);

    @Override
    protected native void dlassqK(int var1, double[] var2, int var3, int var4, doubleW var5, doubleW var6);

    @Override
    protected native void dlasv2K(double var1, double var3, double var5, doubleW var7, doubleW var8, doubleW var9, doubleW var10, doubleW var11, doubleW var12);

    @Override
    protected native void dlaswpK(int var1, double[] var2, int var3, int var4, int var5, int var6, int[] var7, int var8, int var9);

    @Override
    protected native void dlasy2K(boolean var1, boolean var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, doubleW var15, double[] var16, int var17, int var18, doubleW var19, intW var20);

    @Override
    protected native void dlasyfK(String var1, int var2, int var3, intW var4, double[] var5, int var6, int var7, int[] var8, int var9, double[] var10, int var11, int var12, intW var13);

    @Override
    protected native void dlatbsK(String var1, String var2, String var3, String var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, doubleW var12, double[] var13, int var14, intW var15);

    @Override
    protected native void dlatdfK(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, doubleW var8, doubleW var9, int[] var10, int var11, int[] var12, int var13);

    @Override
    protected native void dlatpsK(String var1, String var2, String var3, String var4, int var5, double[] var6, int var7, double[] var8, int var9, doubleW var10, double[] var11, int var12, intW var13);

    @Override
    protected native void dlatrdK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13);

    @Override
    protected native void dlatrsK(String var1, String var2, String var3, String var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, doubleW var11, double[] var12, int var13, intW var14);

    @Override
    protected native void dlatrzK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10);

    @Override
    protected native void dlatzmK(String var1, int var2, int var3, double[] var4, int var5, int var6, double var7, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15);

    @Override
    protected native void dlauu2K(String var1, int var2, double[] var3, int var4, int var5, intW var6);

    @Override
    protected native void dlauumK(String var1, int var2, double[] var3, int var4, int var5, intW var6);

    @Override
    protected native void dlazq3K(int var1, intW var2, double[] var3, int var4, int var5, doubleW var6, doubleW var7, doubleW var8, doubleW var9, intW var10, intW var11, intW var12, boolean var13, intW var14, doubleW var15, doubleW var16, doubleW var17, doubleW var18, doubleW var19, doubleW var20);

    @Override
    protected native void dlazq4K(int var1, int var2, double[] var3, int var4, int var5, int var6, double var7, double var9, double var11, double var13, double var15, double var17, doubleW var19, intW var20, doubleW var21);

    @Override
    protected native void dopgtrK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, intW var12);

    @Override
    protected native void dopmtrK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, intW var15);

    @Override
    protected native void dorg2lK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, intW var11);

    @Override
    protected native void dorg2rK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, intW var11);

    @Override
    protected native void dorgbrK(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, intW var13);

    @Override
    protected native void dorghrK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dorgl2K(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, intW var11);

    @Override
    protected native void dorglqK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dorgqlK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dorgqrK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dorgr2K(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, intW var11);

    @Override
    protected native void dorgrqK(int var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dorgtrK(String var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dorm2lK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, intW var16);

    @Override
    protected native void dorm2rK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, intW var16);

    @Override
    protected native void dormbrK(String var1, String var2, String var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, intW var18);

    @Override
    protected native void dormhrK(String var1, String var2, int var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, intW var18);

    @Override
    protected native void dorml2K(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, intW var16);

    @Override
    protected native void dormlqK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, intW var17);

    @Override
    protected native void dormqlK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, intW var17);

    @Override
    protected native void dormqrK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, intW var17);

    @Override
    protected native void dormr2K(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, intW var16);

    @Override
    protected native void dormr3K(String var1, String var2, int var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, intW var17);

    @Override
    protected native void dormrqK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, intW var17);

    @Override
    protected native void dormrzK(String var1, String var2, int var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, intW var18);

    @Override
    protected native void dormtrK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, intW var17);

    @Override
    protected native void dpbconK(String var1, int var2, int var3, double[] var4, int var5, int var6, double var7, doubleW var9, double[] var10, int var11, int[] var12, int var13, intW var14);

    @Override
    protected native void dpbequK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, doubleW var9, doubleW var10, intW var11);

    @Override
    protected native void dpbrfsK(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, double[] var19, int var20, double[] var21, int var22, int[] var23, int var24, intW var25);

    @Override
    protected native void dpbstfK(String var1, int var2, int var3, double[] var4, int var5, int var6, intW var7);

    @Override
    protected native void dpbsvK(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dpbsvxK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, StringW var12, double[] var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19, int var20, doubleW var21, double[] var22, int var23, double[] var24, int var25, double[] var26, int var27, int[] var28, int var29, intW var30);

    @Override
    protected native void dpbtf2K(String var1, int var2, int var3, double[] var4, int var5, int var6, intW var7);

    @Override
    protected native void dpbtrfK(String var1, int var2, int var3, double[] var4, int var5, int var6, intW var7);

    @Override
    protected native void dpbtrsK(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dpoconK(String var1, int var2, double[] var3, int var4, int var5, double var6, doubleW var8, double[] var9, int var10, int[] var11, int var12, intW var13);

    @Override
    protected native void dpoequK(int var1, double[] var2, int var3, int var4, double[] var5, int var6, doubleW var7, doubleW var8, intW var9);

    @Override
    protected native void dporfsK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, double[] var18, int var19, double[] var20, int var21, int[] var22, int var23, intW var24);

    @Override
    protected native void dposvK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, intW var10);

    @Override
    protected native void dposvxK(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, StringW var11, double[] var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, doubleW var20, double[] var21, int var22, double[] var23, int var24, double[] var25, int var26, int[] var27, int var28, intW var29);

    @Override
    protected native void dpotf2K(String var1, int var2, double[] var3, int var4, int var5, intW var6);

    @Override
    protected native void dpotrfK(String var1, int var2, double[] var3, int var4, int var5, intW var6);

    @Override
    protected native void dpotriK(String var1, int var2, double[] var3, int var4, int var5, intW var6);

    @Override
    protected native void dpotrsK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, intW var10);

    @Override
    protected native void dppconK(String var1, int var2, double[] var3, int var4, double var5, doubleW var7, double[] var8, int var9, int[] var10, int var11, intW var12);

    @Override
    protected native void dppequK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, doubleW var7, doubleW var8, intW var9);

    @Override
    protected native void dpprfsK(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, double[] var16, int var17, double[] var18, int var19, int[] var20, int var21, intW var22);

    @Override
    protected native void dppsvK(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, int var8, intW var9);

    @Override
    protected native void dppsvxK(String var1, String var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, StringW var9, double[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, doubleW var18, double[] var19, int var20, double[] var21, int var22, double[] var23, int var24, int[] var25, int var26, intW var27);

    @Override
    protected native void dpptrfK(String var1, int var2, double[] var3, int var4, intW var5);

    @Override
    protected native void dpptriK(String var1, int var2, double[] var3, int var4, intW var5);

    @Override
    protected native void dpptrsK(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, int var8, intW var9);

    @Override
    protected native void dptconK(int var1, double[] var2, int var3, double[] var4, int var5, double var6, doubleW var8, double[] var9, int var10, intW var11);

    @Override
    protected native void dpteqrK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, intW var12);

    @Override
    protected native void dptrfsK(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, double[] var19, int var20, double[] var21, int var22, intW var23);

    @Override
    protected native void dptsvK(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, intW var10);

    @Override
    protected native void dptsvxK(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, doubleW var18, double[] var19, int var20, double[] var21, int var22, double[] var23, int var24, intW var25);

    @Override
    protected native void dpttrfK(int var1, double[] var2, int var3, double[] var4, int var5, intW var6);

    @Override
    protected native void dpttrsK(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, intW var10);

    @Override
    protected native void dptts2K(int var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9);

    @Override
    protected native void drsclK(int var1, double var2, double[] var4, int var5, int var6);

    @Override
    protected native void dsbevK(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, intW var15);

    @Override
    protected native void dsbevdK(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, int[] var16, int var17, int var18, intW var19);

    @Override
    protected native void dsbevxK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double var12, double var14, int var16, int var17, double var18, intW var20, double[] var21, int var22, double[] var23, int var24, int var25, double[] var26, int var27, int[] var28, int var29, int[] var30, int var31, intW var32);

    @Override
    protected native void dsbgstK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, intW var17);

    @Override
    protected native void dsbgvK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, intW var19);

    @Override
    protected native void dsbgvdK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, int[] var20, int var21, int var22, intW var23);

    @Override
    protected native void dsbgvxK(String var1, String var2, String var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, double var16, double var18, int var20, int var21, double var22, intW var24, double[] var25, int var26, double[] var27, int var28, int var29, double[] var30, int var31, int[] var32, int var33, int[] var34, int var35, intW var36);

    @Override
    protected native void dsbtrdK(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, intW var17);

    @Override
    protected native void dsgesvK(int var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, float[] var16, int var17, intW var18, intW var19);

    @Override
    protected native void dspconK(String var1, int var2, double[] var3, int var4, int[] var5, int var6, double var7, doubleW var9, double[] var10, int var11, int[] var12, int var13, intW var14);

    @Override
    protected native void dspevK(String var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, intW var13);

    @Override
    protected native void dspevdK(String var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, int[] var14, int var15, int var16, intW var17);

    @Override
    protected native void dspevxK(String var1, String var2, String var3, int var4, double[] var5, int var6, double var7, double var9, int var11, int var12, double var13, intW var15, double[] var16, int var17, double[] var18, int var19, int var20, double[] var21, int var22, int[] var23, int var24, int[] var25, int var26, intW var27);

    @Override
    protected native void dspgstK(int var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7, intW var8);

    @Override
    protected native void dspgvK(int var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, intW var16);

    @Override
    protected native void dspgvdK(int var1, String var2, String var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, int[] var17, int var18, int var19, intW var20);

    @Override
    protected native void dspgvxK(int var1, String var2, String var3, String var4, int var5, double[] var6, int var7, double[] var8, int var9, double var10, double var12, int var14, int var15, double var16, intW var18, double[] var19, int var20, double[] var21, int var22, int var23, double[] var24, int var25, int[] var26, int var27, int[] var28, int var29, intW var30);

    @Override
    protected native void dsprfsK(String var1, int var2, int var3, double[] var4, int var5, double[] var6, int var7, int[] var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, double[] var18, int var19, double[] var20, int var21, int[] var22, int var23, intW var24);

    @Override
    protected native void dspsvK(String var1, int var2, int var3, double[] var4, int var5, int[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dspsvxK(String var1, String var2, int var3, int var4, double[] var5, int var6, double[] var7, int var8, int[] var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, doubleW var17, double[] var18, int var19, double[] var20, int var21, double[] var22, int var23, int[] var24, int var25, intW var26);

    @Override
    protected native void dsptrdK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, double[] var9, int var10, intW var11);

    @Override
    protected native void dsptrfK(String var1, int var2, double[] var3, int var4, int[] var5, int var6, intW var7);

    @Override
    protected native void dsptriK(String var1, int var2, double[] var3, int var4, int[] var5, int var6, double[] var7, int var8, intW var9);

    @Override
    protected native void dsptrsK(String var1, int var2, int var3, double[] var4, int var5, int[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dstebzK(String var1, String var2, int var3, double var4, double var6, int var8, int var9, double var10, double[] var12, int var13, double[] var14, int var15, intW var16, intW var17, double[] var18, int var19, int[] var20, int var21, int[] var22, int var23, double[] var24, int var25, int[] var26, int var27, intW var28);

    @Override
    protected native void dstedcK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, int[] var13, int var14, int var15, intW var16);

    @Override
    protected native void dstegrK(String var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7, double var8, double var10, int var12, int var13, double var14, intW var16, double[] var17, int var18, double[] var19, int var20, int var21, int[] var22, int var23, double[] var24, int var25, int var26, int[] var27, int var28, int var29, intW var30);

    @Override
    protected native void dsteinK(int var1, double[] var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int[] var9, int var10, int[] var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, int[] var18, int var19, int[] var20, int var21, intW var22);

    @Override
    protected native void dstemrK(String var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7, double var8, double var10, int var12, int var13, intW var14, double[] var15, int var16, double[] var17, int var18, int var19, int var20, int[] var21, int var22, booleanW var23, double[] var24, int var25, int var26, int[] var27, int var28, int var29, intW var30);

    @Override
    protected native void dsteqrK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, intW var12);

    @Override
    protected native void dsterfK(int var1, double[] var2, int var3, double[] var4, int var5, intW var6);

    @Override
    protected native void dstevK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, intW var12);

    @Override
    protected native void dstevdK(String var1, int var2, double[] var3, int var4, double[] var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, int[] var13, int var14, int var15, intW var16);

    @Override
    protected native void dstevrK(String var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7, double var8, double var10, int var12, int var13, double var14, intW var16, double[] var17, int var18, double[] var19, int var20, int var21, int[] var22, int var23, double[] var24, int var25, int var26, int[] var27, int var28, int var29, intW var30);

    @Override
    protected native void dstevxK(String var1, String var2, int var3, double[] var4, int var5, double[] var6, int var7, double var8, double var10, int var12, int var13, double var14, intW var16, double[] var17, int var18, double[] var19, int var20, int var21, double[] var22, int var23, int[] var24, int var25, int[] var26, int var27, intW var28);

    @Override
    protected native void dsyconK(String var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double var8, doubleW var10, double[] var11, int var12, int[] var13, int var14, intW var15);

    @Override
    protected native void dsyevK(String var1, String var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dsyevdK(String var1, String var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, double[] var9, int var10, int var11, int[] var12, int var13, int var14, intW var15);

    @Override
    protected native void dsyevrK(String var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double var8, double var10, int var12, int var13, double var14, intW var16, double[] var17, int var18, double[] var19, int var20, int var21, int[] var22, int var23, double[] var24, int var25, int var26, int[] var27, int var28, int var29, intW var30);

    @Override
    protected native void dsyevxK(String var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double var8, double var10, int var12, int var13, double var14, intW var16, double[] var17, int var18, double[] var19, int var20, int var21, double[] var22, int var23, int var24, int[] var25, int var26, int[] var27, int var28, intW var29);

    @Override
    protected native void dsygs2K(int var1, String var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, intW var10);

    @Override
    protected native void dsygstK(int var1, String var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, intW var10);

    @Override
    protected native void dsygvK(int var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, double[] var13, int var14, int var15, intW var16);

    @Override
    protected native void dsygvdK(int var1, String var2, String var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, double[] var13, int var14, int var15, int[] var16, int var17, int var18, intW var19);

    @Override
    protected native void dsygvxK(int var1, String var2, String var3, String var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double var12, double var14, int var16, int var17, double var18, intW var20, double[] var21, int var22, double[] var23, int var24, int var25, double[] var26, int var27, int var28, int[] var29, int var30, int[] var31, int var32, intW var33);

    @Override
    protected native void dsyrfsK(String var1, int var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, int[] var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19, double[] var20, int var21, double[] var22, int var23, int[] var24, int var25, intW var26);

    @Override
    protected native void dsysvK(String var1, int var2, int var3, double[] var4, int var5, int var6, int[] var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, intW var15);

    @Override
    protected native void dsysvxK(String var1, String var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, int[] var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, int var18, doubleW var19, double[] var20, int var21, double[] var22, int var23, double[] var24, int var25, int var26, int[] var27, int var28, intW var29);

    @Override
    protected native void dsytd2K(String var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, intW var12);

    @Override
    protected native void dsytf2K(String var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, intW var8);

    @Override
    protected native void dsytrdK(String var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, double[] var10, int var11, double[] var12, int var13, int var14, intW var15);

    @Override
    protected native void dsytrfK(String var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dsytriK(String var1, int var2, double[] var3, int var4, int var5, int[] var6, int var7, double[] var8, int var9, intW var10);

    @Override
    protected native void dsytrsK(String var1, int var2, int var3, double[] var4, int var5, int var6, int[] var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dtbconK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, doubleW var9, double[] var10, int var11, int[] var12, int var13, intW var14);

    @Override
    protected native void dtbrfsK(String var1, String var2, String var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, double[] var16, int var17, double[] var18, int var19, double[] var20, int var21, int[] var22, int var23, intW var24);

    @Override
    protected native void dtbtrsK(String var1, String var2, String var3, int var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, intW var13);

    @Override
    protected native void dtgevcK(String var1, String var2, boolean[] var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, int var18, intW var19, double[] var20, int var21, intW var22);

    @Override
    protected native void dtgex2K(boolean var1, boolean var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, int var16, int var17, int var18, double[] var19, int var20, int var21, intW var22);

    @Override
    protected native void dtgexcK(boolean var1, boolean var2, int var3, double[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, int var15, intW var16, intW var17, double[] var18, int var19, int var20, intW var21);

    @Override
    protected native void dtgsenK(int var1, boolean var2, boolean var3, boolean[] var4, int var5, int var6, double[] var7, int var8, int var9, double[] var10, int var11, int var12, double[] var13, int var14, double[] var15, int var16, double[] var17, int var18, double[] var19, int var20, int var21, double[] var22, int var23, int var24, intW var25, doubleW var26, doubleW var27, double[] var28, int var29, double[] var30, int var31, int var32, int[] var33, int var34, int var35, intW var36);

    @Override
    protected native void dtgsjaK(String var1, String var2, String var3, int var4, int var5, int var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double var15, double var17, double[] var19, int var20, double[] var21, int var22, double[] var23, int var24, int var25, double[] var26, int var27, int var28, double[] var29, int var30, int var31, double[] var32, int var33, intW var34, intW var35);

    @Override
    protected native void dtgsnaK(String var1, String var2, boolean[] var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, int var17, double[] var18, int var19, double[] var20, int var21, int var22, intW var23, double[] var24, int var25, int var26, int[] var27, int var28, intW var29);

    @Override
    protected native void dtgsy2K(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, double[] var20, int var21, int var22, doubleW var23, doubleW var24, doubleW var25, int[] var26, int var27, intW var28, intW var29);

    @Override
    protected native void dtgsylK(String var1, int var2, int var3, int var4, double[] var5, int var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, int var16, double[] var17, int var18, int var19, double[] var20, int var21, int var22, doubleW var23, doubleW var24, double[] var25, int var26, int var27, int[] var28, int var29, intW var30);

    @Override
    protected native void dtpconK(String var1, String var2, String var3, int var4, double[] var5, int var6, doubleW var7, double[] var8, int var9, int[] var10, int var11, intW var12);

    @Override
    protected native void dtprfsK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, double[] var11, int var12, int var13, double[] var14, int var15, double[] var16, int var17, double[] var18, int var19, int[] var20, int var21, intW var22);

    @Override
    protected native void dtptriK(String var1, String var2, int var3, double[] var4, int var5, intW var6);

    @Override
    protected native void dtptrsK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native void dtrconK(String var1, String var2, String var3, int var4, double[] var5, int var6, int var7, doubleW var8, double[] var9, int var10, int[] var11, int var12, intW var13);

    @Override
    protected native void dtrevcK(String var1, String var2, boolean[] var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, int var15, intW var16, double[] var17, int var18, intW var19);

    @Override
    protected native void dtrexcK(String var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, int var8, intW var9, intW var10, double[] var11, int var12, intW var13);

    @Override
    protected native void dtrrfsK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, double[] var17, int var18, double[] var19, int var20, int[] var21, int var22, intW var23);

    @Override
    protected native void dtrsenK(String var1, String var2, boolean[] var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, double[] var14, int var15, intW var16, doubleW var17, doubleW var18, double[] var19, int var20, int var21, int[] var22, int var23, int var24, intW var25);

    @Override
    protected native void dtrsnaK(String var1, String var2, boolean[] var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, double[] var15, int var16, double[] var17, int var18, int var19, intW var20, double[] var21, int var22, int var23, int[] var24, int var25, intW var26);

    @Override
    protected native void dtrsylK(String var1, String var2, int var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, double[] var12, int var13, int var14, doubleW var15, intW var16);

    @Override
    protected native void dtrti2K(String var1, String var2, int var3, double[] var4, int var5, int var6, intW var7);

    @Override
    protected native void dtrtriK(String var1, String var2, int var3, double[] var4, int var5, int var6, intW var7);

    @Override
    protected native void dtrtrsK(String var1, String var2, String var3, int var4, int var5, double[] var6, int var7, int var8, double[] var9, int var10, int var11, intW var12);

    @Override
    protected native void dtzrqfK(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, intW var8);

    @Override
    protected native void dtzrzfK(int var1, int var2, double[] var3, int var4, int var5, double[] var6, int var7, double[] var8, int var9, int var10, intW var11);

    @Override
    protected native int ieeeckK(int var1, float var2, float var3);

    @Override
    protected native int ilaenvK(int var1, String var2, String var3, int var4, int var5, int var6, int var7);

    @Override
    protected native void ilaverK(intW var1, intW var2, intW var3);

    @Override
    protected native int iparmqK(int var1, String var2, String var3, int var4, int var5, int var6, int var7);

    @Override
    protected native boolean lsamenK(int var1, String var2, String var3);

    @Override
    protected native void sbdsdcK(String var1, String var2, int var3, float[] var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int[] var16, int var17, float[] var18, int var19, int[] var20, int var21, intW var22);

    @Override
    protected native void sbdsqrK(String var1, int var2, int var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, int var18, float[] var19, int var20, intW var21);

    @Override
    protected native void sdisnaK(String var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, intW var8);

    @Override
    protected native void sgbbrdK(String var1, int var2, int var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, float[] var20, int var21, int var22, float[] var23, int var24, intW var25);

    @Override
    protected native void sgbconK(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, int[] var8, int var9, float var10, floatW var11, float[] var12, int var13, int[] var14, int var15, intW var16);

    @Override
    protected native void sgbequK(int var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, floatW var12, floatW var13, floatW var14, intW var15);

    @Override
    protected native void sgbrfsK(String var1, int var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, int[] var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, float[] var20, int var21, float[] var22, int var23, float[] var24, int var25, int[] var26, int var27, intW var28);

    @Override
    protected native void sgbsvK(int var1, int var2, int var3, int var4, float[] var5, int var6, int var7, int[] var8, int var9, float[] var10, int var11, int var12, intW var13);

    @Override
    protected native void sgbsvxK(String var1, String var2, int var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, int[] var13, int var14, StringW var15, float[] var16, int var17, float[] var18, int var19, float[] var20, int var21, int var22, float[] var23, int var24, int var25, floatW var26, float[] var27, int var28, float[] var29, int var30, float[] var31, int var32, int[] var33, int var34, intW var35);

    @Override
    protected native void sgbtf2K(int var1, int var2, int var3, int var4, float[] var5, int var6, int var7, int[] var8, int var9, intW var10);

    @Override
    protected native void sgbtrfK(int var1, int var2, int var3, int var4, float[] var5, int var6, int var7, int[] var8, int var9, intW var10);

    @Override
    protected native void sgbtrsK(String var1, int var2, int var3, int var4, int var5, float[] var6, int var7, int var8, int[] var9, int var10, float[] var11, int var12, int var13, intW var14);

    @Override
    protected native void sgebakK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void sgebalK(String var1, int var2, float[] var3, int var4, int var5, intW var6, intW var7, float[] var8, int var9, intW var10);

    @Override
    protected native void sgebd2K(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, intW var16);

    @Override
    protected native void sgebrdK(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sgeconK(String var1, int var2, float[] var3, int var4, int var5, float var6, floatW var7, float[] var8, int var9, int[] var10, int var11, intW var12);

    @Override
    protected native void sgeequK(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, floatW var10, floatW var11, floatW var12, intW var13);

    @Override
    protected native void sgeesK(String var1, String var2, Object var3, int var4, float[] var5, int var6, int var7, intW var8, float[] var9, int var10, float[] var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, int var18, boolean[] var19, int var20, intW var21);

    @Override
    protected native void sgeesxK(String var1, String var2, Object var3, String var4, int var5, float[] var6, int var7, int var8, intW var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, int var16, floatW var17, floatW var18, float[] var19, int var20, int var21, int[] var22, int var23, int var24, boolean[] var25, int var26, intW var27);

    @Override
    protected native void sgeevK(String var1, String var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, intW var20);

    @Override
    protected native void sgeevxK(String var1, String var2, String var3, String var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, int var18, intW var19, intW var20, float[] var21, int var22, floatW var23, float[] var24, int var25, float[] var26, int var27, float[] var28, int var29, int var30, int[] var31, int var32, intW var33);

    @Override
    protected native void sgegsK(String var1, String var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, float[] var16, int var17, int var18, float[] var19, int var20, int var21, float[] var22, int var23, int var24, intW var25);

    @Override
    protected native void sgegvK(String var1, String var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, float[] var16, int var17, int var18, float[] var19, int var20, int var21, float[] var22, int var23, int var24, intW var25);

    @Override
    protected native void sgehd2K(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, intW var11);

    @Override
    protected native void sgehrdK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void sgelq2K(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, intW var10);

    @Override
    protected native void sgelqfK(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void sgelsK(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, intW var14);

    @Override
    protected native void sgelsdK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float var12, intW var13, float[] var14, int var15, int var16, int[] var17, int var18, intW var19);

    @Override
    protected native void sgelssK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float var12, intW var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sgelsxK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, int[] var10, int var11, float var12, intW var13, float[] var14, int var15, intW var16);

    @Override
    protected native void sgelsyK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, int[] var10, int var11, float var12, intW var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sgeql2K(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, intW var10);

    @Override
    protected native void sgeqlfK(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void sgeqp3K(int var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12, intW var13);

    @Override
    protected native void sgeqpfK(int var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, float[] var8, int var9, float[] var10, int var11, intW var12);

    @Override
    protected native void sgeqr2K(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, intW var10);

    @Override
    protected native void sgeqrfK(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void sgerfsK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, int[] var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19, float[] var20, int var21, float[] var22, int var23, int[] var24, int var25, intW var26);

    @Override
    protected native void sgerq2K(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, intW var10);

    @Override
    protected native void sgerqfK(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void sgesc2K(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int[] var7, int var8, int[] var9, int var10, floatW var11);

    @Override
    protected native void sgesddK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, int[] var18, int var19, intW var20);

    @Override
    protected native void sgesvK(int var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void sgesvdK(String var1, String var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, int var18, intW var19);

    @Override
    protected native void sgesvxK(String var1, String var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, int[] var11, int var12, StringW var13, float[] var14, int var15, float[] var16, int var17, float[] var18, int var19, int var20, float[] var21, int var22, int var23, floatW var24, float[] var25, int var26, float[] var27, int var28, float[] var29, int var30, int[] var31, int var32, intW var33);

    @Override
    protected native void sgetc2K(int var1, float[] var2, int var3, int var4, int[] var5, int var6, int[] var7, int var8, intW var9);

    @Override
    protected native void sgetf2K(int var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, intW var8);

    @Override
    protected native void sgetrfK(int var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, intW var8);

    @Override
    protected native void sgetriK(int var1, float[] var2, int var3, int var4, int[] var5, int var6, float[] var7, int var8, int var9, intW var10);

    @Override
    protected native void sgetrsK(String var1, int var2, int var3, float[] var4, int var5, int var6, int[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void sggbakK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, intW var14);

    @Override
    protected native void sggbalK(String var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8, intW var9, intW var10, float[] var11, int var12, float[] var13, int var14, float[] var15, int var16, intW var17);

    @Override
    protected native void sggesK(String var1, String var2, String var3, Object var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, intW var12, float[] var13, int var14, float[] var15, int var16, float[] var17, int var18, float[] var19, int var20, int var21, float[] var22, int var23, int var24, float[] var25, int var26, int var27, boolean[] var28, int var29, intW var30);

    @Override
    protected native void sggesxK(String var1, String var2, String var3, Object var4, String var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, intW var13, float[] var14, int var15, float[] var16, int var17, float[] var18, int var19, float[] var20, int var21, int var22, float[] var23, int var24, int var25, float[] var26, int var27, float[] var28, int var29, float[] var30, int var31, int var32, int[] var33, int var34, int var35, boolean[] var36, int var37, intW var38);

    @Override
    protected native void sggevK(String var1, String var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, float[] var16, int var17, int var18, float[] var19, int var20, int var21, float[] var22, int var23, int var24, intW var25);

    @Override
    protected native void sggevxK(String var1, String var2, String var3, String var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, float[] var14, int var15, float[] var16, int var17, float[] var18, int var19, int var20, float[] var21, int var22, int var23, intW var24, intW var25, float[] var26, int var27, float[] var28, int var29, floatW var30, floatW var31, float[] var32, int var33, float[] var34, int var35, float[] var36, int var37, int var38, int[] var39, int var40, boolean[] var41, int var42, intW var43);

    @Override
    protected native void sggglmK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, float[] var16, int var17, int var18, intW var19);

    @Override
    protected native void sgghrdK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, intW var18);

    @Override
    protected native void sgglseK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, float[] var16, int var17, int var18, intW var19);

    @Override
    protected native void sggqrfK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sggrqfK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sggsvdK(String var1, String var2, String var3, int var4, int var5, int var6, intW var7, intW var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, float[] var17, int var18, float[] var19, int var20, int var21, float[] var22, int var23, int var24, float[] var25, int var26, int var27, float[] var28, int var29, int[] var30, int var31, intW var32);

    @Override
    protected native void sggsvpK(String var1, String var2, String var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float var13, float var14, intW var15, intW var16, float[] var17, int var18, int var19, float[] var20, int var21, int var22, float[] var23, int var24, int var25, int[] var26, int var27, float[] var28, int var29, float[] var30, int var31, intW var32);

    @Override
    protected native void sgtconK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, int[] var11, int var12, float var13, floatW var14, float[] var15, int var16, int[] var17, int var18, intW var19);

    @Override
    protected native void sgtrfsK(String var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, float[] var16, int var17, int[] var18, int var19, float[] var20, int var21, int var22, float[] var23, int var24, int var25, float[] var26, int var27, float[] var28, int var29, float[] var30, int var31, int[] var32, int var33, intW var34);

    @Override
    protected native void sgtsvK(int var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void sgtsvxK(String var1, String var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, float[] var13, int var14, float[] var15, int var16, float[] var17, int var18, int[] var19, int var20, float[] var21, int var22, int var23, float[] var24, int var25, int var26, floatW var27, float[] var28, int var29, float[] var30, int var31, float[] var32, int var33, int[] var34, int var35, intW var36);

    @Override
    protected native void sgttrfK(int var1, float[] var2, int var3, float[] var4, int var5, float[] var6, int var7, float[] var8, int var9, int[] var10, int var11, intW var12);

    @Override
    protected native void sgttrsK(String var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, int[] var12, int var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sgtts2K(int var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, int[] var12, int var13, float[] var14, int var15, int var16);

    @Override
    protected native void shgeqzK(String var1, String var2, String var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, float[] var15, int var16, float[] var17, int var18, float[] var19, int var20, int var21, float[] var22, int var23, int var24, float[] var25, int var26, int var27, intW var28);

    @Override
    protected native void shseinK(String var1, String var2, String var3, boolean[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, int var20, intW var21, float[] var22, int var23, int[] var24, int var25, int[] var26, int var27, intW var28);

    @Override
    protected native void shseqrK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, int var18, intW var19);

    @Override
    protected native boolean sisnanK(float var1);

    @Override
    protected native void slabadK(floatW var1, floatW var2);

    @Override
    protected native void slabrdK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, float[] var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19, int var20);

    @Override
    protected native void slacn2K(int var1, float[] var2, int var3, float[] var4, int var5, int[] var6, int var7, floatW var8, intW var9, int[] var10, int var11);

    @Override
    protected native void slaconK(int var1, float[] var2, int var3, float[] var4, int var5, int[] var6, int var7, floatW var8, intW var9);

    @Override
    protected native void slacpyK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9);

    @Override
    protected native void sladivK(float var1, float var2, float var3, float var4, floatW var5, floatW var6);

    @Override
    protected native void slae2K(float var1, float var2, float var3, floatW var4, floatW var5);

    @Override
    protected native void slaebzK(int var1, int var2, int var3, int var4, int var5, int var6, float var7, float var8, float var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, int[] var16, int var17, float[] var18, int var19, float[] var20, int var21, intW var22, int[] var23, int var24, float[] var25, int var26, int[] var27, int var28, intW var29);

    @Override
    protected native void slaed0K(int var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int[] var16, int var17, intW var18);

    @Override
    protected native void slaed1K(int var1, float[] var2, int var3, float[] var4, int var5, int var6, int[] var7, int var8, floatW var9, int var10, float[] var11, int var12, int[] var13, int var14, intW var15);

    @Override
    protected native void slaed2K(intW var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, int var8, int[] var9, int var10, floatW var11, float[] var12, int var13, float[] var14, int var15, float[] var16, int var17, float[] var18, int var19, int[] var20, int var21, int[] var22, int var23, int[] var24, int var25, int[] var26, int var27, intW var28);

    @Override
    protected native void slaed3K(int var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, int var8, float var9, float[] var10, int var11, float[] var12, int var13, int[] var14, int var15, int[] var16, int var17, float[] var18, int var19, float[] var20, int var21, intW var22);

    @Override
    protected native void slaed4K(int var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, float var9, floatW var10, intW var11);

    @Override
    protected native void slaed5K(int var1, float[] var2, int var3, float[] var4, int var5, float[] var6, int var7, float var8, floatW var9);

    @Override
    protected native void slaed6K(int var1, boolean var2, float var3, float[] var4, int var5, float[] var6, int var7, float var8, floatW var9, intW var10);

    @Override
    protected native void slaed7K(int var1, int var2, int var3, int var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, int[] var12, int var13, floatW var14, int var15, float[] var16, int var17, int[] var18, int var19, int[] var20, int var21, int[] var22, int var23, int[] var24, int var25, int[] var26, int var27, float[] var28, int var29, float[] var30, int var31, int[] var32, int var33, intW var34);

    @Override
    protected native void slaed8K(int var1, intW var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, int[] var10, int var11, floatW var12, int var13, float[] var14, int var15, float[] var16, int var17, float[] var18, int var19, int var20, float[] var21, int var22, int[] var23, int var24, intW var25, int[] var26, int var27, float[] var28, int var29, int[] var30, int var31, int[] var32, int var33, intW var34);

    @Override
    protected native void slaed9K(int var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, float var10, float[] var11, int var12, float[] var13, int var14, float[] var15, int var16, int var17, intW var18);

    @Override
    protected native void slaedaK(int var1, int var2, int var3, int var4, int[] var5, int var6, int[] var7, int var8, int[] var9, int var10, int[] var11, int var12, float[] var13, int var14, float[] var15, int var16, int[] var17, int var18, float[] var19, int var20, float[] var21, int var22, intW var23);

    @Override
    protected native void slaeinK(boolean var1, boolean var2, int var3, float[] var4, int var5, int var6, float var7, float var8, float[] var9, int var10, float[] var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, float var18, float var19, float var20, intW var21);

    @Override
    protected native void slaev2K(float var1, float var2, float var3, floatW var4, floatW var5, floatW var6, floatW var7);

    @Override
    protected native void slaexcK(boolean var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8, int var9, int var10, int var11, float[] var12, int var13, intW var14);

    @Override
    protected native void slag2K(float[] var1, int var2, int var3, float[] var4, int var5, int var6, float var7, floatW var8, floatW var9, floatW var10, floatW var11, floatW var12);

    @Override
    protected native void slag2dK(int var1, int var2, float[] var3, int var4, int var5, double[] var6, int var7, int var8, intW var9);

    @Override
    protected native void slags2K(boolean var1, float var2, float var3, float var4, float var5, float var6, float var7, floatW var8, floatW var9, floatW var10, floatW var11, floatW var12, floatW var13);

    @Override
    protected native void slagtfK(int var1, float[] var2, int var3, float var4, float[] var5, int var6, float[] var7, int var8, float var9, float[] var10, int var11, int[] var12, int var13, intW var14);

    @Override
    protected native void slagtmK(String var1, int var2, int var3, float var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float var14, float[] var15, int var16, int var17);

    @Override
    protected native void slagtsK(int var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, int[] var11, int var12, float[] var13, int var14, floatW var15, intW var16);

    @Override
    protected native void slagv2K(float[] var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, floatW var13, floatW var14, floatW var15, floatW var16);

    @Override
    protected native void slahqrK(boolean var1, boolean var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, int var14, float[] var15, int var16, int var17, intW var18);

    @Override
    protected native void slahr2K(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14);

    @Override
    protected native void slahrdK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14);

    @Override
    protected native void slaic1K(int var1, int var2, float[] var3, int var4, float var5, float[] var6, int var7, float var8, floatW var9, floatW var10, floatW var11);

    @Override
    protected native boolean slaisnanK(float var1, float var2);

    @Override
    protected native void slaln2K(boolean var1, int var2, int var3, float var4, float var5, float[] var6, int var7, int var8, float var9, float var10, float[] var11, int var12, int var13, float var14, float var15, float[] var16, int var17, int var18, floatW var19, floatW var20, intW var21);

    @Override
    protected native void slals0K(int var1, int var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, int[] var12, int var13, int var14, int[] var15, int var16, int var17, float[] var18, int var19, int var20, float[] var21, int var22, float[] var23, int var24, float[] var25, int var26, float[] var27, int var28, int var29, float var30, float var31, float[] var32, int var33, intW var34);

    @Override
    protected native void slalsaK(int var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int[] var16, int var17, float[] var18, int var19, float[] var20, int var21, float[] var22, int var23, float[] var24, int var25, int[] var26, int var27, int[] var28, int var29, int var30, int[] var31, int var32, float[] var33, int var34, float[] var35, int var36, float[] var37, int var38, float[] var39, int var40, int[] var41, int var42, intW var43);

    @Override
    protected native void slalsdK(String var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float var12, intW var13, float[] var14, int var15, int[] var16, int var17, intW var18);

    @Override
    protected native void slamrgK(int var1, int var2, float[] var3, int var4, int var5, int var6, int[] var7, int var8);

    @Override
    protected native int slanegK(int var1, float[] var2, int var3, float[] var4, int var5, float var6, float var7, int var8);

    @Override
    protected native float slangbK(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9);

    @Override
    protected native float slangeK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8);

    @Override
    protected native float slangtK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8);

    @Override
    protected native float slanhsK(String var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7);

    @Override
    protected native float slansbK(String var1, String var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9);

    @Override
    protected native float slanspK(String var1, String var2, int var3, float[] var4, int var5, float[] var6, int var7);

    @Override
    protected native float slanstK(String var1, int var2, float[] var3, int var4, float[] var5, int var6);

    @Override
    protected native float slansyK(String var1, String var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8);

    @Override
    protected native float slantbK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10);

    @Override
    protected native float slantpK(String var1, String var2, String var3, int var4, float[] var5, int var6, float[] var7, int var8);

    @Override
    protected native float slantrK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10);

    @Override
    protected native void slanv2K(floatW var1, floatW var2, floatW var3, floatW var4, floatW var5, floatW var6, floatW var7, floatW var8, floatW var9, floatW var10);

    @Override
    protected native void slapllK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7, floatW var8);

    @Override
    protected native void slapmtK(boolean var1, int var2, int var3, float[] var4, int var5, int var6, int[] var7, int var8);

    @Override
    protected native float slapy2K(float var1, float var2);

    @Override
    protected native float slapy3K(float var1, float var2, float var3);

    @Override
    protected native void slaqgbK(int var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, float var12, float var13, float var14, StringW var15);

    @Override
    protected native void slaqgeK(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, float var10, float var11, float var12, StringW var13);

    @Override
    protected native void slaqp2K(int var1, int var2, int var3, float[] var4, int var5, int var6, int[] var7, int var8, float[] var9, int var10, float[] var11, int var12, float[] var13, int var14, float[] var15, int var16);

    @Override
    protected native void slaqpsK(int var1, int var2, int var3, int var4, intW var5, float[] var6, int var7, int var8, int[] var9, int var10, float[] var11, int var12, float[] var13, int var14, float[] var15, int var16, float[] var17, int var18, float[] var19, int var20, int var21);

    @Override
    protected native void slaqr0K(boolean var1, boolean var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19, int var20, intW var21);

    @Override
    protected native void slaqr1K(int var1, float[] var2, int var3, int var4, float var5, float var6, float var7, float var8, float[] var9, int var10);

    @Override
    protected native void slaqr2K(boolean var1, boolean var2, int var3, int var4, int var5, int var6, float[] var7, int var8, int var9, int var10, int var11, float[] var12, int var13, int var14, intW var15, intW var16, float[] var17, int var18, float[] var19, int var20, float[] var21, int var22, int var23, int var24, float[] var25, int var26, int var27, int var28, float[] var29, int var30, int var31, float[] var32, int var33, int var34);

    @Override
    protected native void slaqr3K(boolean var1, boolean var2, int var3, int var4, int var5, int var6, float[] var7, int var8, int var9, int var10, int var11, float[] var12, int var13, int var14, intW var15, intW var16, float[] var17, int var18, float[] var19, int var20, float[] var21, int var22, int var23, int var24, float[] var25, int var26, int var27, int var28, float[] var29, int var30, int var31, float[] var32, int var33, int var34);

    @Override
    protected native void slaqr4K(boolean var1, boolean var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19, int var20, intW var21);

    @Override
    protected native void slaqr5K(boolean var1, boolean var2, int var3, int var4, int var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, float[] var12, int var13, int var14, int var15, int var16, float[] var17, int var18, int var19, float[] var20, int var21, int var22, float[] var23, int var24, int var25, int var26, float[] var27, int var28, int var29, int var30, float[] var31, int var32, int var33);

    @Override
    protected native void slaqsbK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float var9, float var10, StringW var11);

    @Override
    protected native void slaqspK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, float var7, float var8, StringW var9);

    @Override
    protected native void slaqsyK(String var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float var8, float var9, StringW var10);

    @Override
    protected native void slaqtrK(boolean var1, boolean var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float var9, floatW var10, float[] var11, int var12, float[] var13, int var14, intW var15);

    @Override
    protected native void slar1vK(int var1, int var2, int var3, float var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, float var13, float var14, float[] var15, int var16, boolean var17, intW var18, floatW var19, floatW var20, intW var21, int[] var22, int var23, floatW var24, floatW var25, floatW var26, float[] var27, int var28);

    @Override
    protected native void slar2vK(int var1, float[] var2, int var3, float[] var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13);

    @Override
    protected native void slarfK(String var1, int var2, int var3, float[] var4, int var5, int var6, float var7, float[] var8, int var9, int var10, float[] var11, int var12);

    @Override
    protected native void slarfbK(String var1, String var2, String var3, String var4, int var5, int var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19);

    @Override
    protected native void slarfgK(int var1, floatW var2, float[] var3, int var4, int var5, floatW var6);

    @Override
    protected native void slarftK(String var1, String var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12);

    @Override
    protected native void slarfxK(String var1, int var2, int var3, float[] var4, int var5, float var6, float[] var7, int var8, int var9, float[] var10, int var11);

    @Override
    protected native void slargvK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10);

    @Override
    protected native void slarnvK(int var1, int[] var2, int var3, int var4, float[] var5, int var6);

    @Override
    protected native void slarraK(int var1, float[] var2, int var3, float[] var4, int var5, float[] var6, int var7, float var8, float var9, intW var10, int[] var11, int var12, intW var13);

    @Override
    protected native void slarrbK(int var1, float[] var2, int var3, float[] var4, int var5, int var6, int var7, float var8, float var9, int var10, float[] var11, int var12, float[] var13, int var14, float[] var15, int var16, float[] var17, int var18, int[] var19, int var20, float var21, float var22, int var23, intW var24);

    @Override
    protected native void slarrcK(String var1, int var2, float var3, float var4, float[] var5, int var6, float[] var7, int var8, float var9, intW var10, intW var11, intW var12, intW var13);

    @Override
    protected native void slarrdK(String var1, String var2, int var3, float var4, float var5, int var6, int var7, float[] var8, int var9, float var10, float[] var11, int var12, float[] var13, int var14, float[] var15, int var16, float var17, int var18, int[] var19, int var20, intW var21, float[] var22, int var23, float[] var24, int var25, floatW var26, floatW var27, int[] var28, int var29, int[] var30, int var31, float[] var32, int var33, int[] var34, int var35, intW var36);

    @Override
    protected native void slarreK(String var1, int var2, floatW var3, floatW var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, float var13, float var14, float var15, intW var16, int[] var17, int var18, intW var19, float[] var20, int var21, float[] var22, int var23, float[] var24, int var25, int[] var26, int var27, int[] var28, int var29, float[] var30, int var31, floatW var32, float[] var33, int var34, int[] var35, int var36, intW var37);

    @Override
    protected native void slarrfK(int var1, float[] var2, int var3, float[] var4, int var5, float[] var6, int var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, float var16, float var17, float var18, float var19, floatW var20, float[] var21, int var22, float[] var23, int var24, float[] var25, int var26, intW var27);

    @Override
    protected native void slarrjK(int var1, float[] var2, int var3, float[] var4, int var5, int var6, int var7, float var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, int[] var16, int var17, float var18, float var19, intW var20);

    @Override
    protected native void slarrkK(int var1, int var2, float var3, float var4, float[] var5, int var6, float[] var7, int var8, float var9, float var10, floatW var11, floatW var12, intW var13);

    @Override
    protected native void slarrrK(int var1, float[] var2, int var3, float[] var4, int var5, intW var6);

    @Override
    protected native void slarrvK(int var1, float var2, float var3, float[] var4, int var5, float[] var6, int var7, float var8, int[] var9, int var10, int var11, int var12, int var13, float var14, floatW var15, floatW var16, float[] var17, int var18, float[] var19, int var20, float[] var21, int var22, int[] var23, int var24, int[] var25, int var26, float[] var27, int var28, float[] var29, int var30, int var31, int[] var32, int var33, float[] var34, int var35, int[] var36, int var37, intW var38);

    @Override
    protected native void slartgK(float var1, float var2, floatW var3, floatW var4, floatW var5);

    @Override
    protected native void slartvK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12);

    @Override
    protected native void slaruvK(int[] var1, int var2, int var3, float[] var4, int var5);

    @Override
    protected native void slarzK(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float var8, float[] var9, int var10, int var11, float[] var12, int var13);

    @Override
    protected native void slarzbK(String var1, String var2, String var3, String var4, int var5, int var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19, int var20);

    @Override
    protected native void slarztK(String var1, String var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12);

    @Override
    protected native void slas2K(float var1, float var2, float var3, floatW var4, floatW var5);

    @Override
    protected native void slasclK(String var1, int var2, int var3, float var4, float var5, int var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void slasd0K(int var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, int var13, int[] var14, int var15, float[] var16, int var17, intW var18);

    @Override
    protected native void slasd1K(int var1, int var2, int var3, float[] var4, int var5, floatW var6, floatW var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, int[] var14, int var15, int[] var16, int var17, float[] var18, int var19, intW var20);

    @Override
    protected native void slasd2K(int var1, int var2, int var3, intW var4, float[] var5, int var6, float[] var7, int var8, float var9, float var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, float[] var19, int var20, int var21, float[] var22, int var23, int var24, int[] var25, int var26, int[] var27, int var28, int[] var29, int var30, int[] var31, int var32, int[] var33, int var34, intW var35);

    @Override
    protected native void slasd3K(int var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19, int var20, float[] var21, int var22, int var23, int[] var24, int var25, int[] var26, int var27, float[] var28, int var29, intW var30);

    @Override
    protected native void slasd4K(int var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, float var9, floatW var10, float[] var11, int var12, intW var13);

    @Override
    protected native void slasd5K(int var1, float[] var2, int var3, float[] var4, int var5, float[] var6, int var7, float var8, floatW var9, float[] var10, int var11);

    @Override
    protected native void slasd6K(int var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, floatW var11, floatW var12, int[] var13, int var14, int[] var15, int var16, intW var17, int[] var18, int var19, int var20, float[] var21, int var22, int var23, float[] var24, int var25, float[] var26, int var27, float[] var28, int var29, float[] var30, int var31, intW var32, floatW var33, floatW var34, float[] var35, int var36, int[] var37, int var38, intW var39);

    @Override
    protected native void slasd7K(int var1, int var2, int var3, int var4, intW var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, float[] var12, int var13, float[] var14, int var15, float[] var16, int var17, float[] var18, int var19, float var20, float var21, float[] var22, int var23, int[] var24, int var25, int[] var26, int var27, int[] var28, int var29, int[] var30, int var31, intW var32, int[] var33, int var34, int var35, float[] var36, int var37, int var38, floatW var39, floatW var40, intW var41);

    @Override
    protected native void slasd8K(int var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, float[] var18, int var19, intW var20);

    @Override
    protected native void slasdaK(int var1, int var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int[] var14, int var15, float[] var16, int var17, float[] var18, int var19, float[] var20, int var21, float[] var22, int var23, int[] var24, int var25, int[] var26, int var27, int var28, int[] var29, int var30, float[] var31, int var32, float[] var33, int var34, float[] var35, int var36, float[] var37, int var38, int[] var39, int var40, intW var41);

    @Override
    protected native void slasdqK(String var1, int var2, int var3, int var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, float[] var20, int var21, intW var22);

    @Override
    protected native void slasdtK(int var1, intW var2, intW var3, int[] var4, int var5, int[] var6, int var7, int[] var8, int var9, int var10);

    @Override
    protected native void slasetK(String var1, int var2, int var3, float var4, float var5, float[] var6, int var7, int var8);

    @Override
    protected native void slasq1K(int var1, float[] var2, int var3, float[] var4, int var5, float[] var6, int var7, intW var8);

    @Override
    protected native void slasq2K(int var1, float[] var2, int var3, intW var4);

    @Override
    protected native void slasq3K(int var1, intW var2, float[] var3, int var4, int var5, floatW var6, floatW var7, floatW var8, floatW var9, intW var10, intW var11, intW var12, boolean var13);

    @Override
    protected native void slasq4K(int var1, int var2, float[] var3, int var4, int var5, int var6, float var7, float var8, float var9, float var10, float var11, float var12, floatW var13, intW var14);

    @Override
    protected native void slasq5K(int var1, int var2, float[] var3, int var4, int var5, float var6, floatW var7, floatW var8, floatW var9, floatW var10, floatW var11, floatW var12, boolean var13);

    @Override
    protected native void slasq6K(int var1, int var2, float[] var3, int var4, int var5, floatW var6, floatW var7, floatW var8, floatW var9, floatW var10, floatW var11);

    @Override
    protected native void slasrK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12);

    @Override
    protected native void slasrtK(String var1, int var2, float[] var3, int var4, intW var5);

    @Override
    protected native void slassqK(int var1, float[] var2, int var3, int var4, floatW var5, floatW var6);

    @Override
    protected native void slasv2K(float var1, float var2, float var3, floatW var4, floatW var5, floatW var6, floatW var7, floatW var8, floatW var9);

    @Override
    protected native void slaswpK(int var1, float[] var2, int var3, int var4, int var5, int var6, int[] var7, int var8, int var9);

    @Override
    protected native void slasy2K(boolean var1, boolean var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, floatW var15, float[] var16, int var17, int var18, floatW var19, intW var20);

    @Override
    protected native void slasyfK(String var1, int var2, int var3, intW var4, float[] var5, int var6, int var7, int[] var8, int var9, float[] var10, int var11, int var12, intW var13);

    @Override
    protected native void slatbsK(String var1, String var2, String var3, String var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, floatW var12, float[] var13, int var14, intW var15);

    @Override
    protected native void slatdfK(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, floatW var8, floatW var9, int[] var10, int var11, int[] var12, int var13);

    @Override
    protected native void slatpsK(String var1, String var2, String var3, String var4, int var5, float[] var6, int var7, float[] var8, int var9, floatW var10, float[] var11, int var12, intW var13);

    @Override
    protected native void slatrdK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13);

    @Override
    protected native void slatrsK(String var1, String var2, String var3, String var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, floatW var11, float[] var12, int var13, intW var14);

    @Override
    protected native void slatrzK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10);

    @Override
    protected native void slatzmK(String var1, int var2, int var3, float[] var4, int var5, int var6, float var7, float[] var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14);

    @Override
    protected native void slauu2K(String var1, int var2, float[] var3, int var4, int var5, intW var6);

    @Override
    protected native void slauumK(String var1, int var2, float[] var3, int var4, int var5, intW var6);

    @Override
    protected native void slazq3K(int var1, intW var2, float[] var3, int var4, int var5, floatW var6, floatW var7, floatW var8, floatW var9, intW var10, intW var11, intW var12, boolean var13, intW var14, floatW var15, floatW var16, floatW var17, floatW var18, floatW var19, floatW var20);

    @Override
    protected native void slazq4K(int var1, int var2, float[] var3, int var4, int var5, int var6, float var7, float var8, float var9, float var10, float var11, float var12, floatW var13, intW var14, floatW var15);

    @Override
    protected native void sopgtrK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, intW var12);

    @Override
    protected native void sopmtrK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, intW var15);

    @Override
    protected native void sorg2lK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, intW var11);

    @Override
    protected native void sorg2rK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, intW var11);

    @Override
    protected native void sorgbrK(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12, intW var13);

    @Override
    protected native void sorghrK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void sorgl2K(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, intW var11);

    @Override
    protected native void sorglqK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void sorgqlK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void sorgqrK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void sorgr2K(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, intW var11);

    @Override
    protected native void sorgrqK(int var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void sorgtrK(String var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void sorm2lK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, intW var16);

    @Override
    protected native void sorm2rK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, intW var16);

    @Override
    protected native void sormbrK(String var1, String var2, String var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, intW var18);

    @Override
    protected native void sormhrK(String var1, String var2, int var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, intW var18);

    @Override
    protected native void sorml2K(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, intW var16);

    @Override
    protected native void sormlqK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sormqlK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sormqrK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sormr2K(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, intW var16);

    @Override
    protected native void sormr3K(String var1, String var2, int var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, intW var17);

    @Override
    protected native void sormrqK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sormrzK(String var1, String var2, int var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, intW var18);

    @Override
    protected native void sormtrK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, intW var17);

    @Override
    protected native void spbconK(String var1, int var2, int var3, float[] var4, int var5, int var6, float var7, floatW var8, float[] var9, int var10, int[] var11, int var12, intW var13);

    @Override
    protected native void spbequK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, floatW var9, floatW var10, intW var11);

    @Override
    protected native void spbrfsK(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, float[] var19, int var20, float[] var21, int var22, int[] var23, int var24, intW var25);

    @Override
    protected native void spbstfK(String var1, int var2, int var3, float[] var4, int var5, int var6, intW var7);

    @Override
    protected native void spbsvK(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void spbsvxK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, StringW var12, float[] var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19, int var20, floatW var21, float[] var22, int var23, float[] var24, int var25, float[] var26, int var27, int[] var28, int var29, intW var30);

    @Override
    protected native void spbtf2K(String var1, int var2, int var3, float[] var4, int var5, int var6, intW var7);

    @Override
    protected native void spbtrfK(String var1, int var2, int var3, float[] var4, int var5, int var6, intW var7);

    @Override
    protected native void spbtrsK(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void spoconK(String var1, int var2, float[] var3, int var4, int var5, float var6, floatW var7, float[] var8, int var9, int[] var10, int var11, intW var12);

    @Override
    protected native void spoequK(int var1, float[] var2, int var3, int var4, float[] var5, int var6, floatW var7, floatW var8, intW var9);

    @Override
    protected native void sporfsK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, float[] var18, int var19, float[] var20, int var21, int[] var22, int var23, intW var24);

    @Override
    protected native void sposvK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, intW var10);

    @Override
    protected native void sposvxK(String var1, String var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, StringW var11, float[] var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, floatW var20, float[] var21, int var22, float[] var23, int var24, float[] var25, int var26, int[] var27, int var28, intW var29);

    @Override
    protected native void spotf2K(String var1, int var2, float[] var3, int var4, int var5, intW var6);

    @Override
    protected native void spotrfK(String var1, int var2, float[] var3, int var4, int var5, intW var6);

    @Override
    protected native void spotriK(String var1, int var2, float[] var3, int var4, int var5, intW var6);

    @Override
    protected native void spotrsK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, intW var10);

    @Override
    protected native void sppconK(String var1, int var2, float[] var3, int var4, float var5, floatW var6, float[] var7, int var8, int[] var9, int var10, intW var11);

    @Override
    protected native void sppequK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, floatW var7, floatW var8, intW var9);

    @Override
    protected native void spprfsK(String var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, float[] var16, int var17, float[] var18, int var19, int[] var20, int var21, intW var22);

    @Override
    protected native void sppsvK(String var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, int var8, intW var9);

    @Override
    protected native void sppsvxK(String var1, String var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, StringW var9, float[] var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, floatW var18, float[] var19, int var20, float[] var21, int var22, float[] var23, int var24, int[] var25, int var26, intW var27);

    @Override
    protected native void spptrfK(String var1, int var2, float[] var3, int var4, intW var5);

    @Override
    protected native void spptriK(String var1, int var2, float[] var3, int var4, intW var5);

    @Override
    protected native void spptrsK(String var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, int var8, intW var9);

    @Override
    protected native void sptconK(int var1, float[] var2, int var3, float[] var4, int var5, float var6, floatW var7, float[] var8, int var9, intW var10);

    @Override
    protected native void spteqrK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, intW var12);

    @Override
    protected native void sptrfsK(int var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, float[] var19, int var20, float[] var21, int var22, intW var23);

    @Override
    protected native void sptsvK(int var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, intW var10);

    @Override
    protected native void sptsvxK(String var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, floatW var18, float[] var19, int var20, float[] var21, int var22, float[] var23, int var24, intW var25);

    @Override
    protected native void spttrfK(int var1, float[] var2, int var3, float[] var4, int var5, intW var6);

    @Override
    protected native void spttrsK(int var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, intW var10);

    @Override
    protected native void sptts2K(int var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9);

    @Override
    protected native void srsclK(int var1, float var2, float[] var3, int var4, int var5);

    @Override
    protected native void ssbevK(String var1, String var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, intW var15);

    @Override
    protected native void ssbevdK(String var1, String var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15, int[] var16, int var17, int var18, intW var19);

    @Override
    protected native void ssbevxK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float var12, float var13, int var14, int var15, float var16, intW var17, float[] var18, int var19, float[] var20, int var21, int var22, float[] var23, int var24, int[] var25, int var26, int[] var27, int var28, intW var29);

    @Override
    protected native void ssbgstK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, intW var17);

    @Override
    protected native void ssbgvK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, intW var19);

    @Override
    protected native void ssbgvdK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, int[] var20, int var21, int var22, intW var23);

    @Override
    protected native void ssbgvxK(String var1, String var2, String var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15, float var16, float var17, int var18, int var19, float var20, intW var21, float[] var22, int var23, float[] var24, int var25, int var26, float[] var27, int var28, int[] var29, int var30, int[] var31, int var32, intW var33);

    @Override
    protected native void ssbtrdK(String var1, String var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, float[] var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, intW var17);

    @Override
    protected native void sspconK(String var1, int var2, float[] var3, int var4, int[] var5, int var6, float var7, floatW var8, float[] var9, int var10, int[] var11, int var12, intW var13);

    @Override
    protected native void sspevK(String var1, String var2, int var3, float[] var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, intW var13);

    @Override
    protected native void sspevdK(String var1, String var2, int var3, float[] var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, int[] var14, int var15, int var16, intW var17);

    @Override
    protected native void sspevxK(String var1, String var2, String var3, int var4, float[] var5, int var6, float var7, float var8, int var9, int var10, float var11, intW var12, float[] var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19, int[] var20, int var21, int[] var22, int var23, intW var24);

    @Override
    protected native void sspgstK(int var1, String var2, int var3, float[] var4, int var5, float[] var6, int var7, intW var8);

    @Override
    protected native void sspgvK(int var1, String var2, String var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, intW var16);

    @Override
    protected native void sspgvdK(int var1, String var2, String var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, int[] var17, int var18, int var19, intW var20);

    @Override
    protected native void sspgvxK(int var1, String var2, String var3, String var4, int var5, float[] var6, int var7, float[] var8, int var9, float var10, float var11, int var12, int var13, float var14, intW var15, float[] var16, int var17, float[] var18, int var19, int var20, float[] var21, int var22, int[] var23, int var24, int[] var25, int var26, intW var27);

    @Override
    protected native void ssprfsK(String var1, int var2, int var3, float[] var4, int var5, float[] var6, int var7, int[] var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, float[] var18, int var19, float[] var20, int var21, int[] var22, int var23, intW var24);

    @Override
    protected native void sspsvK(String var1, int var2, int var3, float[] var4, int var5, int[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void sspsvxK(String var1, String var2, int var3, int var4, float[] var5, int var6, float[] var7, int var8, int[] var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, floatW var17, float[] var18, int var19, float[] var20, int var21, float[] var22, int var23, int[] var24, int var25, intW var26);

    @Override
    protected native void ssptrdK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, float[] var9, int var10, intW var11);

    @Override
    protected native void ssptrfK(String var1, int var2, float[] var3, int var4, int[] var5, int var6, intW var7);

    @Override
    protected native void ssptriK(String var1, int var2, float[] var3, int var4, int[] var5, int var6, float[] var7, int var8, intW var9);

    @Override
    protected native void ssptrsK(String var1, int var2, int var3, float[] var4, int var5, int[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void sstebzK(String var1, String var2, int var3, float var4, float var5, int var6, int var7, float var8, float[] var9, int var10, float[] var11, int var12, intW var13, intW var14, float[] var15, int var16, int[] var17, int var18, int[] var19, int var20, float[] var21, int var22, int[] var23, int var24, intW var25);

    @Override
    protected native void sstedcK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, int[] var13, int var14, int var15, intW var16);

    @Override
    protected native void sstegrK(String var1, String var2, int var3, float[] var4, int var5, float[] var6, int var7, float var8, float var9, int var10, int var11, float var12, intW var13, float[] var14, int var15, float[] var16, int var17, int var18, int[] var19, int var20, float[] var21, int var22, int var23, int[] var24, int var25, int var26, intW var27);

    @Override
    protected native void ssteinK(int var1, float[] var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int[] var9, int var10, int[] var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, int[] var18, int var19, int[] var20, int var21, intW var22);

    @Override
    protected native void sstemrK(String var1, String var2, int var3, float[] var4, int var5, float[] var6, int var7, float var8, float var9, int var10, int var11, intW var12, float[] var13, int var14, float[] var15, int var16, int var17, int var18, int[] var19, int var20, booleanW var21, float[] var22, int var23, int var24, int[] var25, int var26, int var27, intW var28);

    @Override
    protected native void ssteqrK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, intW var12);

    @Override
    protected native void ssterfK(int var1, float[] var2, int var3, float[] var4, int var5, intW var6);

    @Override
    protected native void sstevK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, intW var12);

    @Override
    protected native void sstevdK(String var1, int var2, float[] var3, int var4, float[] var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, int[] var13, int var14, int var15, intW var16);

    @Override
    protected native void sstevrK(String var1, String var2, int var3, float[] var4, int var5, float[] var6, int var7, float var8, float var9, int var10, int var11, float var12, intW var13, float[] var14, int var15, float[] var16, int var17, int var18, int[] var19, int var20, float[] var21, int var22, int var23, int[] var24, int var25, int var26, intW var27);

    @Override
    protected native void sstevxK(String var1, String var2, int var3, float[] var4, int var5, float[] var6, int var7, float var8, float var9, int var10, int var11, float var12, intW var13, float[] var14, int var15, float[] var16, int var17, int var18, float[] var19, int var20, int[] var21, int var22, int[] var23, int var24, intW var25);

    @Override
    protected native void ssyconK(String var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, float var8, floatW var9, float[] var10, int var11, int[] var12, int var13, intW var14);

    @Override
    protected native void ssyevK(String var1, String var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void ssyevdK(String var1, String var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, float[] var9, int var10, int var11, int[] var12, int var13, int var14, intW var15);

    @Override
    protected native void ssyevrK(String var1, String var2, String var3, int var4, float[] var5, int var6, int var7, float var8, float var9, int var10, int var11, float var12, intW var13, float[] var14, int var15, float[] var16, int var17, int var18, int[] var19, int var20, float[] var21, int var22, int var23, int[] var24, int var25, int var26, intW var27);

    @Override
    protected native void ssyevxK(String var1, String var2, String var3, int var4, float[] var5, int var6, int var7, float var8, float var9, int var10, int var11, float var12, intW var13, float[] var14, int var15, float[] var16, int var17, int var18, float[] var19, int var20, int var21, int[] var22, int var23, int[] var24, int var25, intW var26);

    @Override
    protected native void ssygs2K(int var1, String var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, intW var10);

    @Override
    protected native void ssygstK(int var1, String var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, intW var10);

    @Override
    protected native void ssygvK(int var1, String var2, String var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, float[] var13, int var14, int var15, intW var16);

    @Override
    protected native void ssygvdK(int var1, String var2, String var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, float[] var13, int var14, int var15, int[] var16, int var17, int var18, intW var19);

    @Override
    protected native void ssygvxK(int var1, String var2, String var3, String var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float var12, float var13, int var14, int var15, float var16, intW var17, float[] var18, int var19, float[] var20, int var21, int var22, float[] var23, int var24, int var25, int[] var26, int var27, int[] var28, int var29, intW var30);

    @Override
    protected native void ssyrfsK(String var1, int var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, int[] var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19, float[] var20, int var21, float[] var22, int var23, int[] var24, int var25, intW var26);

    @Override
    protected native void ssysvK(String var1, int var2, int var3, float[] var4, int var5, int var6, int[] var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, intW var15);

    @Override
    protected native void ssysvxK(String var1, String var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, int[] var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, int var18, floatW var19, float[] var20, int var21, float[] var22, int var23, float[] var24, int var25, int var26, int[] var27, int var28, intW var29);

    @Override
    protected native void ssytd2K(String var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, intW var12);

    @Override
    protected native void ssytf2K(String var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, intW var8);

    @Override
    protected native void ssytrdK(String var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, float[] var10, int var11, float[] var12, int var13, int var14, intW var15);

    @Override
    protected native void ssytrfK(String var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void ssytriK(String var1, int var2, float[] var3, int var4, int var5, int[] var6, int var7, float[] var8, int var9, intW var10);

    @Override
    protected native void ssytrsK(String var1, int var2, int var3, float[] var4, int var5, int var6, int[] var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void stbconK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, floatW var9, float[] var10, int var11, int[] var12, int var13, intW var14);

    @Override
    protected native void stbrfsK(String var1, String var2, String var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15, float[] var16, int var17, float[] var18, int var19, float[] var20, int var21, int[] var22, int var23, intW var24);

    @Override
    protected native void stbtrsK(String var1, String var2, String var3, int var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, intW var13);

    @Override
    protected native void stgevcK(String var1, String var2, boolean[] var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, int var18, intW var19, float[] var20, int var21, intW var22);

    @Override
    protected native void stgex2K(boolean var1, boolean var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15, int var16, int var17, int var18, float[] var19, int var20, int var21, intW var22);

    @Override
    protected native void stgexcK(boolean var1, boolean var2, int var3, float[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, int var15, intW var16, intW var17, float[] var18, int var19, int var20, intW var21);

    @Override
    protected native void stgsenK(int var1, boolean var2, boolean var3, boolean[] var4, int var5, int var6, float[] var7, int var8, int var9, float[] var10, int var11, int var12, float[] var13, int var14, float[] var15, int var16, float[] var17, int var18, float[] var19, int var20, int var21, float[] var22, int var23, int var24, intW var25, floatW var26, floatW var27, float[] var28, int var29, float[] var30, int var31, int var32, int[] var33, int var34, int var35, intW var36);

    @Override
    protected native void stgsjaK(String var1, String var2, String var3, int var4, int var5, int var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float var15, float var16, float[] var17, int var18, float[] var19, int var20, float[] var21, int var22, int var23, float[] var24, int var25, int var26, float[] var27, int var28, int var29, float[] var30, int var31, intW var32, intW var33);

    @Override
    protected native void stgsnaK(String var1, String var2, boolean[] var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, int var17, float[] var18, int var19, float[] var20, int var21, int var22, intW var23, float[] var24, int var25, int var26, int[] var27, int var28, intW var29);

    @Override
    protected native void stgsy2K(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, float[] var20, int var21, int var22, floatW var23, floatW var24, floatW var25, int[] var26, int var27, intW var28, intW var29);

    @Override
    protected native void stgsylK(String var1, int var2, int var3, int var4, float[] var5, int var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, int var16, float[] var17, int var18, int var19, float[] var20, int var21, int var22, floatW var23, floatW var24, float[] var25, int var26, int var27, int[] var28, int var29, intW var30);

    @Override
    protected native void stpconK(String var1, String var2, String var3, int var4, float[] var5, int var6, floatW var7, float[] var8, int var9, int[] var10, int var11, intW var12);

    @Override
    protected native void stprfsK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, float[] var11, int var12, int var13, float[] var14, int var15, float[] var16, int var17, float[] var18, int var19, int[] var20, int var21, intW var22);

    @Override
    protected native void stptriK(String var1, String var2, int var3, float[] var4, int var5, intW var6);

    @Override
    protected native void stptrsK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native void strconK(String var1, String var2, String var3, int var4, float[] var5, int var6, int var7, floatW var8, float[] var9, int var10, int[] var11, int var12, intW var13);

    @Override
    protected native void strevcK(String var1, String var2, boolean[] var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, int var15, intW var16, float[] var17, int var18, intW var19);

    @Override
    protected native void strexcK(String var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, int var8, intW var9, intW var10, float[] var11, int var12, intW var13);

    @Override
    protected native void strrfsK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, float[] var17, int var18, float[] var19, int var20, int[] var21, int var22, intW var23);

    @Override
    protected native void strsenK(String var1, String var2, boolean[] var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, float[] var14, int var15, intW var16, floatW var17, floatW var18, float[] var19, int var20, int var21, int[] var22, int var23, int var24, intW var25);

    @Override
    protected native void strsnaK(String var1, String var2, boolean[] var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, float[] var15, int var16, float[] var17, int var18, int var19, intW var20, float[] var21, int var22, int var23, int[] var24, int var25, intW var26);

    @Override
    protected native void strsylK(String var1, String var2, int var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, float[] var12, int var13, int var14, floatW var15, intW var16);

    @Override
    protected native void strti2K(String var1, String var2, int var3, float[] var4, int var5, int var6, intW var7);

    @Override
    protected native void strtriK(String var1, String var2, int var3, float[] var4, int var5, int var6, intW var7);

    @Override
    protected native void strtrsK(String var1, String var2, String var3, int var4, int var5, float[] var6, int var7, int var8, float[] var9, int var10, int var11, intW var12);

    @Override
    protected native void stzrqfK(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, intW var8);

    @Override
    protected native void stzrzfK(int var1, int var2, float[] var3, int var4, int var5, float[] var6, int var7, float[] var8, int var9, int var10, intW var11);

    @Override
    protected native double dlamchK(String var1);

    @Override
    protected native void dlamc1K(intW var1, intW var2, booleanW var3, booleanW var4);

    @Override
    protected native void dlamc2K(intW var1, intW var2, booleanW var3, doubleW var4, intW var5, doubleW var6, intW var7, doubleW var8);

    @Override
    protected native double dlamc3K(double var1, double var3);

    @Override
    protected native void dlamc4K(intW var1, double var2, int var4);

    @Override
    protected native void dlamc5K(int var1, int var2, int var3, boolean var4, intW var5, doubleW var6);

    @Override
    protected native double dsecndK();

    @Override
    protected native boolean lsameK(String var1, String var2);

    @Override
    protected native float secondK();

    @Override
    protected native float slamchK(String var1);

    @Override
    protected native void slamc1K(intW var1, intW var2, booleanW var3, booleanW var4);

    @Override
    protected native void slamc2K(intW var1, intW var2, booleanW var3, floatW var4, intW var5, floatW var6, intW var7, floatW var8);

    @Override
    protected native float slamc3K(float var1, float var2);

    @Override
    protected native void slamc4K(intW var1, float var2, int var3);

    @Override
    protected native void slamc5K(int var1, int var2, int var3, boolean var4, intW var5, floatW var6);
}

