/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.benchmarks.blas.l3;

import dev.ludovic.netlib.benchmarks.blas.l3.L3Benchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
public class SsymmBenchmark
extends L3Benchmark {
    @Param(value={"L", "R"})
    public String side;
    @Param(value={"U", "L"})
    public String uplo;
    @Param(value={"10", "1000"})
    public int m;
    @Param(value={"10", "1000"})
    public int n;
    public float alpha;
    public float[] a;
    public int lda;
    public float[] b;
    public int ldb;
    public float beta;
    public float[] c;
    public float[] cclone;
    public int ldc;

    @Setup(value=Level.Trial)
    public void setup() {
        this.alpha = this.randomFloat();
        this.a = this.randomFloatArray(this.side.equals("L") ? this.m * this.m : this.n * this.n);
        this.b = this.randomFloatArray(this.m * this.n);
        this.beta = this.randomFloat();
        this.c = this.randomFloatArray(this.m * this.n);
    }

    @Setup(value=Level.Invocation)
    public void setupIteration() {
        this.cclone = (float[])this.c.clone();
    }

    @Benchmark
    public void blas(Blackhole bh) {
        this.blas.ssymm(this.side, this.uplo, this.m, this.n, this.alpha, this.a, this.side.equals("L") ? this.m : this.n, this.b, this.m, this.beta, this.cclone, this.m);
        bh.consume((Object)this.cclone);
    }
}

