/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.maven_plugin.mojo;

import dev.logchange.core.application.changelog.repository.ChangelogRepository;
import dev.logchange.core.application.changelog.repository.VersionSummaryRepository;
import dev.logchange.core.application.changelog.service.generate.GenerateChangelogService;
import dev.logchange.core.application.changelog.service.generate.GenerateChangelogXMLService;
import dev.logchange.core.domain.changelog.command.GenerateChangelogUseCase;
import dev.logchange.core.domain.changelog.command.ValidateChangelogUseCase;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.infrastructure.persistance.changelog.FileChangelogRepository;
import dev.logchange.core.infrastructure.persistance.changelog.FileVersionSummaryRepository;
import dev.logchange.core.infrastructure.persistance.config.FileConfigRepository;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.NONE)
public class GenerateChangelogMojo
extends AbstractMojo {
    @Parameter(defaultValue="changelog", property="inputDir")
    private String inputDir;
    @Parameter(defaultValue="CHANGELOG.md", property="outputFile")
    private String outputFile;
    @Parameter(defaultValue="logchange-config.yml", property="configFile")
    private String configFile;

    public void execute() {
        this.executeGenerate(this.outputFile, this.inputDir, this.configFile, false, "");
    }

    public void validate(String finalChangelogName, String yamlFilesDirectory, String configFile) {
        this.getLog().info((CharSequence)("Started validation of " + yamlFilesDirectory + " and " + configFile));
        File changelogDirectory = this.findChangelogDirectory("./" + yamlFilesDirectory);
        Config config = this.findConfig("./" + yamlFilesDirectory + "/" + configFile);
        FileChangelogRepository repository = new FileChangelogRepository(changelogDirectory, new File(finalChangelogName), config);
        FileVersionSummaryRepository versionSummaryRepository = new FileVersionSummaryRepository(changelogDirectory, config);
        GenerateChangelogService validateChangelog = new GenerateChangelogService((ChangelogRepository)repository, (VersionSummaryRepository)versionSummaryRepository);
        ValidateChangelogUseCase.ValidateChangelogCommand command = ValidateChangelogUseCase.ValidateChangelogCommand.of();
        validateChangelog.handle(command);
        this.getLog().info((CharSequence)("Validation of " + yamlFilesDirectory + " and " + configFile + " successful"));
    }

    public void executeGenerate(String finalChangelogName, String yamlFilesDirectory, String configFile, Boolean isXml, String xmlOutputFile) {
        this.getLog().info((CharSequence)("Started generating " + finalChangelogName));
        File changelogDirectory = this.findChangelogDirectory("./" + yamlFilesDirectory);
        Config config = this.findConfig("./" + yamlFilesDirectory + "/" + configFile);
        FileChangelogRepository repository = new FileChangelogRepository(changelogDirectory, new File(finalChangelogName), config);
        FileVersionSummaryRepository versionSummaryRepository = new FileVersionSummaryRepository(changelogDirectory, config);
        GenerateChangelogService generateChangelog = new GenerateChangelogService((ChangelogRepository)repository, (VersionSummaryRepository)versionSummaryRepository);
        GenerateChangelogUseCase.GenerateChangelogCommand command = GenerateChangelogUseCase.GenerateChangelogCommand.of();
        generateChangelog.handle(command);
        this.getLog().info((CharSequence)("Generating " + finalChangelogName + " successful"));
        if (isXml.booleanValue()) {
            this.generateChangesXml(xmlOutputFile, changelogDirectory, config, command);
        }
    }

    private void generateChangesXml(String xmlOutputFile, File changelogDirectory, Config config, GenerateChangelogUseCase.GenerateChangelogCommand command) {
        FileChangelogRepository repository = new FileChangelogRepository(changelogDirectory, new File(xmlOutputFile), config);
        GenerateChangelogXMLService generateChangelogXml = new GenerateChangelogXMLService((ChangelogRepository)repository);
        generateChangelogXml.handle(command);
        this.getLog().info((CharSequence)("Generating " + xmlOutputFile + " successful"));
    }

    private File findChangelogDirectory(String directoryPath) {
        File changelogDir = new File(directoryPath);
        if (!changelogDir.exists()) {
            this.getLog().error((CharSequence)("There is no " + directoryPath + " directory in this project !!!"));
            throw new RuntimeException("No changelog directory");
        }
        if (!changelogDir.isDirectory()) {
            this.getLog().error((CharSequence)("File " + directoryPath + " is not a directory !!!"));
            throw new RuntimeException("File " + directoryPath + " is not a directory");
        }
        return changelogDir;
    }

    private Config findConfig(String path) {
        File configFile = new File(path);
        if (!configFile.exists()) {
            this.getLog().info((CharSequence)("There is no config file:  " + path + " for this project, using defaults"));
            return Config.EMPTY;
        }
        if (configFile.isDirectory()) {
            this.getLog().error((CharSequence)("File " + path + " is a directory !!!"));
            throw new RuntimeException("File " + path + " is a directory !!!");
        }
        FileConfigRepository configRepository = new FileConfigRepository(configFile);
        return configRepository.find();
    }
}

