/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.maven_plugin.util;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;

public class ConfigFile {
    private final Log log;
    private final String path;

    private ConfigFile(Log log, String path) {
        this.log = log;
        this.path = path;
    }

    public static ConfigFile of(Log log, String path) {
        return new ConfigFile(log, path);
    }

    public File create() {
        File changelogConfig = new File(this.path + "/" + "logchange-config.yml");
        try {
            if (changelogConfig.createNewFile()) {
                this.log.info((CharSequence)("Created: " + changelogConfig.getName()));
                return changelogConfig;
            }
            String msg = changelogConfig.getName() + " already exists.";
            this.log.warn((CharSequence)(changelogConfig.getName() + " already exists."));
            throw new RuntimeException(msg);
        }
        catch (IOException e) {
            String msg = "An error occurred while creating logchange-config.yml in path: " + this.path;
            this.log.error((CharSequence)msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }
}

