/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.maven_plugin.mojo.release;

import dev.logchange.core.format.release_date.ReleaseDate;
import dev.logchange.maven_plugin.mojo.GenerateChangelogMojo;
import dev.logchange.maven_plugin.mojo.init.InitProjectMojo;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="release", defaultPhase=LifecyclePhase.NONE)
public class ReleaseVersionMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="unreleased", property="unreleasedVersionDir")
    private String unreleasedVersionDir;
    @Parameter(defaultValue="changelog", property="inputDir")
    private String inputDir;
    @Parameter(defaultValue="CHANGELOG.md", property="outputFile")
    private String outputFile;
    @Parameter(defaultValue="logchange-config.yml", property="configFile")
    private String configFile;
    @Parameter(defaultValue="false", property="changesXml")
    private boolean isGenerateChangesXml;
    @Parameter(defaultValue="changes.xml", property="outputFileXml")
    private String xmlOutputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Begin preparation from new changelog release");
        String unreleasedDir = this.inputDir + "/" + this.unreleasedVersionDir;
        String newDirName = this.inputDir + "/v" + this.getVersion();
        ReleaseDate.addToDir((String)unreleasedDir);
        this.removeGitKeep(unreleasedDir);
        this.renameUnreleasedDir(unreleasedDir, newDirName);
        GenerateChangelogMojo generateChangelogMojo = new GenerateChangelogMojo();
        generateChangelogMojo.setLog(this.getLog());
        generateChangelogMojo.executeGenerate(this.outputFile, this.inputDir, this.configFile, this.isGenerateChangesXml, this.xmlOutputFile);
        new InitProjectMojo().createUnreleased(this.inputDir, this.unreleasedVersionDir);
        this.getLog().info((CharSequence)"New changelog release successful");
    }

    private String getVersion() {
        String version = this.project.getVersion();
        if (version.contains("-")) {
            return version.substring(0, version.indexOf("-"));
        }
        return version;
    }

    private void renameUnreleasedDir(String unreleasedDirName, String newDirName) {
        File unreleasedDir = new File(unreleasedDirName);
        File newDir = new File(newDirName);
        if (unreleasedDir.renameTo(newDir)) {
            this.getLog().info((CharSequence)("Renamed " + unreleasedDirName + " to " + newDirName + " successful"));
        }
    }

    private void removeGitKeep(String unreleasedDir) {
        File gitKeep = new File(unreleasedDir + "/" + ".gitkeep");
        if (gitKeep.delete()) {
            this.getLog().info((CharSequence)("Deleted: " + gitKeep.getName()));
        } else {
            this.getLog().warn((CharSequence)(gitKeep.getName() + " cannot be deleted."));
        }
    }
}

