/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.maven_plugin.mojo.add.entry;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntry;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryAuthor;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfiguration;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfigurationAction;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryLink;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryMergeRequest;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryTitle;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryType;
import dev.logchange.maven_plugin.mojo.add.entry.ChangelogEntryProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

class UserInputChangelogEntryProvider
implements ChangelogEntryProvider {
    private final Prompter prompter;

    @Override
    public ChangelogEntry get() {
        try {
            return ChangelogEntry.builder().title(this.getTitle()).type(this.getType()).mergeRequests(this.getMergeRequests()).issues(this.getIssues()).links(this.getLinks()).authors(this.getAuthors()).importantNotes(this.getNotes()).configurations(this.getConfigurations()).build();
        }
        catch (PrompterException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private ChangelogEntryTitle getTitle() throws PrompterException {
        while (true) {
            try {
                return ChangelogEntryTitle.of((String)this.prompter.prompt("What is changelog's entry title(e.g. Adding new awesome product to order list)"));
            }
            catch (IllegalArgumentException e) {
                this.prompter.showMessage(e.getMessage());
                continue;
            }
            break;
        }
    }

    private ChangelogEntryType getType() throws PrompterException {
        String prompt = Arrays.stream(ChangelogEntryType.values()).map(ChangelogEntryType::toString).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "What is changelog's entry type (choose number from above) ?";
        while (true) {
            try {
                return ChangelogEntryType.from((String)this.prompter.prompt(prompt));
            }
            catch (IllegalArgumentException e) {
                this.prompter.showMessage(e.getMessage());
                continue;
            }
            break;
        }
    }

    private List<ChangelogEntryMergeRequest> getMergeRequests() throws PrompterException {
        String prompt = "What is the MR's number? (numbers, seperated with comma) [press ENTER to skip] ";
        while (true) {
            try {
                String response = this.prompter.prompt(prompt);
                return Arrays.stream(response.replaceAll("\\s+", "").split(",")).filter(StringUtils::isNotBlank).map(Long::valueOf).map(ChangelogEntryMergeRequest::of).collect(Collectors.toList());
            }
            catch (Exception e) {
                this.prompter.showMessage(e.getMessage());
                continue;
            }
            break;
        }
    }

    private List<Long> getIssues() throws PrompterException {
        String prompt = "What is the issue's number?(numbers, seperated with comma) [press ENTER to skip] ";
        while (true) {
            try {
                String response = this.prompter.prompt(prompt);
                return Arrays.stream(response.replaceAll("\\s+", "").split(",")).filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
            }
            catch (Exception e) {
                this.prompter.showMessage(e.getMessage());
                continue;
            }
            break;
        }
    }

    private List<ChangelogEntryLink> getLinks() throws PrompterException {
        String prompt = "Is there any links you want to include? [Y/y - YES] [N/n - NO] [press ENTER to skip] ";
        ArrayList<ChangelogEntryLink> links = new ArrayList<ChangelogEntryLink>();
        while (true) {
            try {
                String response = this.prompter.prompt(prompt);
                if (response.trim().equalsIgnoreCase("Y")) {
                    return this.getLinksRecur(links);
                }
                return Collections.emptyList();
            }
            catch (Exception e) {
                this.prompter.showMessage(e.getMessage());
                continue;
            }
            break;
        }
    }

    private List<ChangelogEntryLink> getLinksRecur(List<ChangelogEntryLink> links) throws PrompterException {
        String name = this.prompter.prompt("Give a link caption or press ENTER to skip");
        String link = this.prompter.prompt("Give a link");
        links.add(ChangelogEntryLink.of((String)name, (String)link));
        if (this.prompter.prompt("Is there any other links you want to include? [Y/y - YES] [N/n - NO]").trim().equalsIgnoreCase("Y")) {
            return this.getLinksRecur(links);
        }
        return links;
    }

    private List<ChangelogEntryAuthor> getAuthors() throws PrompterException {
        String prompt = "Is there any authors of this change, that you want to include? [Y/y - YES] [N/n - NO] [press ENTER to skip] ";
        ArrayList<ChangelogEntryAuthor> authors = new ArrayList<ChangelogEntryAuthor>();
        while (true) {
            try {
                String response = this.prompter.prompt(prompt);
                if (response.trim().equalsIgnoreCase("Y")) {
                    return this.getAuthorsRecur(authors);
                }
                return Collections.emptyList();
            }
            catch (Exception e) {
                this.prompter.showMessage(e.getMessage());
                continue;
            }
            break;
        }
    }

    private List<ChangelogEntryAuthor> getAuthorsRecur(List<ChangelogEntryAuthor> authors) throws PrompterException {
        try {
            String name = this.prompter.prompt("Give a name of author or press ENTER to skip");
            String nick = this.prompter.prompt("Give a nickname of author or press ENTER to skip");
            String url = this.prompter.prompt("Give a url of author profile or press ENTER to skip");
            authors.add(ChangelogEntryAuthor.of((String)name, (String)nick, (String)url));
        }
        catch (IllegalArgumentException e) {
            this.prompter.showMessage(e.getMessage());
            return this.getAuthorsRecur(authors);
        }
        if (this.prompter.prompt("Is there any other links you want to include? [Y/y - YES] [N/n - NO]").trim().equalsIgnoreCase("Y")) {
            return this.getAuthorsRecur(authors);
        }
        return authors;
    }

    private List<String> getNotes() throws PrompterException {
        String prompt = "Is there any important information about this change (f.e. it affects other system) [Y/y - YES] [N/n - NO] [press ENTER to skip] ";
        ArrayList<String> notes = new ArrayList<String>();
        while (true) {
            try {
                String response = this.prompter.prompt(prompt);
                if (response.trim().trim().equalsIgnoreCase("Y")) {
                    return this.getNotesRecur(notes);
                }
                return Collections.emptyList();
            }
            catch (Exception e) {
                this.prompter.showMessage(e.getMessage());
                continue;
            }
            break;
        }
    }

    private List<String> getNotesRecur(List<String> notes) throws PrompterException {
        String note = this.prompter.prompt("Give a note");
        notes.add(note.trim());
        if (this.prompter.prompt("Is there any other note you want to include? [Y/y - YES] [N/n - NO]").trim().equalsIgnoreCase("Y")) {
            return this.getNotesRecur(notes);
        }
        return notes;
    }

    private List<ChangelogEntryConfiguration> getConfigurations() throws PrompterException {
        String prompt = "Is there any configuration change regarding this change (f.e. new feature flag) [Y/y - YES] [N/n - NO] [press ENTER to skip] ";
        ArrayList<ChangelogEntryConfiguration> configurations = new ArrayList<ChangelogEntryConfiguration>();
        while (true) {
            try {
                String response = this.prompter.prompt(prompt);
                if (response.trim().trim().equalsIgnoreCase("Y")) {
                    return this.getConfigurationsRecur(configurations);
                }
                return Collections.emptyList();
            }
            catch (Exception e) {
                this.prompter.showMessage(e.getMessage());
                continue;
            }
            break;
        }
    }

    private List<ChangelogEntryConfiguration> getConfigurationsRecur(List<ChangelogEntryConfiguration> configurations) throws PrompterException {
        try {
            String type = this.prompter.prompt("Give a type of a configuration property (f.e. database, or system env, or application.properties)");
            ChangelogEntryConfigurationAction action = this.getConfigurationAction();
            String key = this.prompter.prompt("Give a key of configuration property (f.e. server.port)");
            String defaultValue = this.prompter.prompt("Give a default value of configuration property (f.e. 8443) or press ENTER to skip");
            String description = this.prompter.prompt("Give a description of configuration property (f.e. Port to handle incoming https traffic ) or press ENTER to skip");
            String moreInfo = this.prompter.prompt("Here you can specify more information about configuration property (f.e. Remember to disable port 8080 to disable standard http traffic ) or press ENTER to skip");
            configurations.add(ChangelogEntryConfiguration.of((String)type, (ChangelogEntryConfigurationAction)action, (String)key, (String)defaultValue, (String)description, (String)moreInfo));
        }
        catch (IllegalArgumentException e) {
            this.prompter.showMessage(e.getMessage());
            return this.getConfigurationsRecur(configurations);
        }
        if (this.prompter.prompt("Is there any other configuration change you want to include? [Y/y - YES] [N/n - NO]").trim().equalsIgnoreCase("Y")) {
            return this.getConfigurationsRecur(configurations);
        }
        return configurations;
    }

    private ChangelogEntryConfigurationAction getConfigurationAction() throws PrompterException {
        String prompt = Arrays.stream(ChangelogEntryConfigurationAction.values()).map(ChangelogEntryConfigurationAction::toString).collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator() + "What is the configuration action (choose number from above) ?";
        while (true) {
            try {
                return ChangelogEntryConfigurationAction.from((String)this.prompter.prompt(prompt));
            }
            catch (IllegalArgumentException e) {
                this.prompter.showMessage(e.getMessage());
                continue;
            }
            break;
        }
    }

    public UserInputChangelogEntryProvider(Prompter prompter) {
        this.prompter = prompter;
    }
}

