/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.maven_plugin.mojo.add;

import dev.logchange.core.application.changelog.repository.ChangelogEntryRepository;
import dev.logchange.core.application.changelog.service.add.AddChangelogEntryService;
import dev.logchange.core.domain.changelog.command.AddChangelogEntryUseCase;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntry;
import dev.logchange.core.infrastructure.persistance.changelog.FileChangelogEntryRepository;
import dev.logchange.maven_plugin.mojo.add.OutputFileNameProvider;
import dev.logchange.maven_plugin.mojo.add.entry.ChangelogEntryProviderFactory;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.Prompter;

@Mojo(name="add", defaultPhase=LifecyclePhase.NONE)
public class AddChangelogEntryMojo
extends AbstractMojo {
    @Parameter(defaultValue="changelog", property="inputDir")
    private String inputDir;
    @Parameter(defaultValue="unreleased", property="unreleasedVersionDir")
    private String unreleasedVersionDir;
    @Parameter(property="fileName")
    private String outputFileName;
    @Parameter(defaultValue="false", property="batchMode")
    private boolean batchMode;
    @Parameter(defaultValue="false", property="empty")
    private boolean empty;
    @Parameter(property="title")
    private String title;
    @Parameter(property="author")
    private String author;
    @Parameter(property="type")
    private String type;
    @Parameter(property="link.name")
    private String linkName;
    @Parameter(property="link.url")
    private String linkUrl;
    @Inject
    private Prompter prompter;

    public void execute() {
        this.checkIfCanAdd(this.inputDir, this.unreleasedVersionDir);
        this.outputFileName = new OutputFileNameProvider(this.empty, this.prompter, this.outputFileName).get();
        ChangelogEntry entry = new ChangelogEntryProviderFactory(this.empty, this.batchMode, this.getParams(), this.prompter).create().get();
        this.executeAdd(this.inputDir, this.unreleasedVersionDir, this.outputFileName, entry);
    }

    public void executeAdd(String inputDir, String unreleasedVersionDir, String outputFile, ChangelogEntry entry) {
        String path = "./" + inputDir + "/" + unreleasedVersionDir + "/" + outputFile;
        File entryFile = this.createFile(path);
        this.getLog().debug((CharSequence)entry.toString());
        FileChangelogEntryRepository repository = new FileChangelogEntryRepository(entryFile);
        AddChangelogEntryService addChangelogEntry = new AddChangelogEntryService((ChangelogEntryRepository)repository);
        AddChangelogEntryUseCase.AddChangelogEntryCommand command = AddChangelogEntryUseCase.AddChangelogEntryCommand.of((ChangelogEntry)entry);
        addChangelogEntry.handle(command);
    }

    private void checkIfCanAdd(String inputDir, String unreleasedVersionDir) {
        String path = "./" + inputDir + "/" + unreleasedVersionDir;
        File unreleasedDir = new File(path);
        if (!unreleasedDir.exists() || !unreleasedDir.isDirectory()) {
            String msg = "Cannot add new entry if " + path + " not exists nor is directory";
            this.getLog().error((CharSequence)msg);
            throw new RuntimeException(msg);
        }
    }

    private File createFile(String path) {
        try {
            File changelog = new File(path);
            if (changelog.createNewFile()) {
                this.getLog().info((CharSequence)("Created: " + changelog.getName()));
                return changelog;
            }
            String msg = "Entry with name: " + changelog.getName() + "  already exists!";
            this.getLog().warn((CharSequence)msg);
            throw new RuntimeException(msg);
        }
        catch (IOException e) {
            String msg = "An error occurred while creating empty changelog entry file with path: " + path;
            this.getLog().error((CharSequence)msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }

    private AddChangelogEntryBatchModeParams getParams() {
        return AddChangelogEntryBatchModeParams.of(this.title, this.author, this.type, this.linkName, this.linkUrl);
    }

    public static final class AddChangelogEntryBatchModeParams {
        private final String title;
        private final String author;
        private final String type;
        private final String linkName;
        private final String linkUrl;

        private AddChangelogEntryBatchModeParams(String title, String author, String type, String linkName, String linkUrl) {
            this.title = title;
            this.author = author;
            this.type = type;
            this.linkName = linkName;
            this.linkUrl = linkUrl;
        }

        public static AddChangelogEntryBatchModeParams of(String title, String author, String type, String linkName, String linkUrl) {
            return new AddChangelogEntryBatchModeParams(title, author, type, linkName, linkUrl);
        }

        public String getTitle() {
            return this.title;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getType() {
            return this.type;
        }

        public String getLinkName() {
            return this.linkName;
        }

        public String getLinkUrl() {
            return this.linkUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddChangelogEntryBatchModeParams)) {
                return false;
            }
            AddChangelogEntryBatchModeParams other = (AddChangelogEntryBatchModeParams)o;
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$author = this.getAuthor();
            String other$author = other.getAuthor();
            if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$linkName = this.getLinkName();
            String other$linkName = other.getLinkName();
            if (this$linkName == null ? other$linkName != null : !this$linkName.equals(other$linkName)) {
                return false;
            }
            String this$linkUrl = this.getLinkUrl();
            String other$linkUrl = other.getLinkUrl();
            return !(this$linkUrl == null ? other$linkUrl != null : !this$linkUrl.equals(other$linkUrl));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $author = this.getAuthor();
            result = result * 59 + ($author == null ? 43 : $author.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $linkName = this.getLinkName();
            result = result * 59 + ($linkName == null ? 43 : $linkName.hashCode());
            String $linkUrl = this.getLinkUrl();
            result = result * 59 + ($linkUrl == null ? 43 : $linkUrl.hashCode());
            return result;
        }

        public String toString() {
            return "AddChangelogEntryMojo.AddChangelogEntryBatchModeParams(title=" + this.getTitle() + ", author=" + this.getAuthor() + ", type=" + this.getType() + ", linkName=" + this.getLinkName() + ", linkUrl=" + this.getLinkUrl() + ")";
        }
    }
}

