/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.maven_plugin.mojo.add;

import dev.logchange.core.application.changelog.repository.ChangelogEntryRepository;
import dev.logchange.core.application.changelog.service.add.AddChangelogEntryService;
import dev.logchange.core.domain.changelog.command.AddChangelogEntryUseCase;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntry;
import dev.logchange.core.infrastructure.persistance.changelog.FileChangelogEntryRepository;
import dev.logchange.maven_plugin.mojo.add.OutputFileNameProvider;
import dev.logchange.maven_plugin.mojo.add.entry.ChangelogEntryProviderFactory;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.components.interactivity.Prompter;

@Mojo(name="add", defaultPhase=LifecyclePhase.NONE)
public class AddChangelogEntryMojo
extends AbstractMojo {
    @Parameter(defaultValue="changelog", property="inputDir")
    private String inputDir;
    @Parameter(defaultValue="unreleased", property="unreleasedVersionDir")
    private String unreleasedVersionDir;
    @Parameter(property="fileName")
    private String outputFileName;
    @Parameter(defaultValue="false", property="empty")
    private boolean empty;
    @Inject
    private Prompter prompter;

    public void execute() {
        this.outputFileName = new OutputFileNameProvider(this.empty, this.prompter, this.outputFileName).get();
        ChangelogEntry entry = new ChangelogEntryProviderFactory(this.empty, this.prompter).create().get();
        this.executeAdd(this.inputDir, this.unreleasedVersionDir, this.outputFileName, entry);
    }

    public void executeAdd(String inputDir, String unreleasedVersionDir, String outputFile, ChangelogEntry entry) {
        String path = "./" + inputDir + "/" + unreleasedVersionDir + "/" + outputFile;
        File entryFile = this.createFile(path);
        this.getLog().debug((CharSequence)entry.toString());
        FileChangelogEntryRepository repository = new FileChangelogEntryRepository(entryFile);
        AddChangelogEntryService addChangelogEntry = new AddChangelogEntryService((ChangelogEntryRepository)repository);
        AddChangelogEntryUseCase.AddChangelogEntryCommand command = AddChangelogEntryUseCase.AddChangelogEntryCommand.of((ChangelogEntry)entry);
        addChangelogEntry.handle(command);
    }

    private File createFile(String path) {
        try {
            File changelog = new File(path);
            if (changelog.createNewFile()) {
                this.getLog().info((CharSequence)("Created: " + changelog.getName()));
                return changelog;
            }
            String msg = "Entry with name: " + changelog.getName() + "  already exists!";
            this.getLog().warn((CharSequence)msg);
            throw new RuntimeException(msg);
        }
        catch (IOException e) {
            String msg = "An error occurred while creating empty changelog entry file with path: " + path;
            this.getLog().error((CharSequence)msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }
}

