/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.maven_plugin.mojo.add;

import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class OutputFileNameProvider {
    private final boolean empty;
    private final Prompter prompter;
    private final String commandLineOutputFileName;

    public String get() {
        if (StringUtils.isNotBlank((CharSequence)this.commandLineOutputFileName)) {
            return this.commandLineOutputFileName;
        }
        if (this.empty) {
            throw new IllegalArgumentException("When using -Dempty option, you have to also use -DfileName=0001-some-change.yml");
        }
        try {
            return this.getOutputFileName();
        }
        catch (PrompterException e) {
            throw new IllegalArgumentException("Couldn't get file name", e);
        }
    }

    private String getOutputFileName() throws PrompterException {
        String name;
        while (true) {
            if (StringUtils.isBlank((CharSequence)(name = this.prompter.prompt("What is the filename(e.g. 000231-adding-new-product)")))) {
                this.prompter.showMessage("Filename cannot be empty nor blank!!!");
                continue;
            }
            if (!StringUtils.isWhitespace((CharSequence)name)) break;
            this.prompter.showMessage("Filename cannot contain whitespace!!!");
        }
        name = name.replace(".yml", "").replace(".yaml", "");
        return name + ".yml";
    }

    public OutputFileNameProvider(boolean empty, Prompter prompter, String commandLineOutputFileName) {
        this.empty = empty;
        this.prompter = prompter;
        this.commandLineOutputFileName = commandLineOutputFileName;
    }
}

