/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.maven_plugin.mojo;

import dev.logchange.core.application.changelog.repository.ChangelogRepository;
import dev.logchange.core.application.changelog.repository.VersionSummaryRepository;
import dev.logchange.core.application.changelog.service.generate.GenerateChangelogService;
import dev.logchange.core.domain.changelog.command.GenerateChangelogUseCase;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.infrastructure.persistance.changelog.FileChangelogRepository;
import dev.logchange.core.infrastructure.persistance.changelog.FileVersionSummaryRepository;
import dev.logchange.core.infrastructure.persistance.config.FileConfigRepository;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.NONE)
public class GenerateChangelogMojo
extends AbstractMojo {
    @Parameter(defaultValue="", property="heading")
    private String heading;
    @Parameter(defaultValue="changelog", property="inputDir")
    private String inputDir;
    @Parameter(defaultValue="CHANGELOG.md", property="outputFile")
    private String outputFile;

    public void execute() {
        this.executeGenerate(this.outputFile, this.inputDir);
    }

    public void executeGenerate(String finalChangelogName, String yamlFilesDirectory) {
        this.getLog().info((CharSequence)("Started generating " + finalChangelogName));
        File changelogDirectory = this.findChangelogDirectory("./" + yamlFilesDirectory);
        File configFile = this.findChangelogConfig("./" + yamlFilesDirectory + "/logchange-config.yml");
        FileConfigRepository configRepository = new FileConfigRepository(configFile);
        Config config = configRepository.find();
        FileChangelogRepository repository = new FileChangelogRepository(changelogDirectory, new File(finalChangelogName), config);
        FileVersionSummaryRepository versionSummaryRepository = new FileVersionSummaryRepository(changelogDirectory, config);
        GenerateChangelogService generateChangelog = new GenerateChangelogService((ChangelogRepository)repository, (VersionSummaryRepository)versionSummaryRepository);
        GenerateChangelogUseCase.GenerateChangelogCommand command = GenerateChangelogUseCase.GenerateChangelogCommand.of((String)this.heading);
        generateChangelog.handle(command);
        this.getLog().info((CharSequence)("Generating " + finalChangelogName + " successful"));
    }

    private File findChangelogDirectory(String directoryPath) {
        File changelogDir = new File(directoryPath);
        if (!changelogDir.exists()) {
            this.getLog().error((CharSequence)("There is no " + directoryPath + " directory in this project !!!"));
            throw new RuntimeException("No changelog directory");
        }
        if (!changelogDir.isDirectory()) {
            this.getLog().error((CharSequence)("File " + directoryPath + " is not a directory !!!"));
            throw new RuntimeException("File " + directoryPath + " is not a directory");
        }
        return changelogDir;
    }

    private File findChangelogConfig(String path) {
        File configFile = new File(path);
        if (!configFile.exists()) {
            this.getLog().info((CharSequence)("There is no " + path + " for this project, using defaults"));
        }
        if (configFile.isDirectory()) {
            this.getLog().error((CharSequence)("File " + path + " is a directory !!!"));
            throw new RuntimeException("File " + path + " is not a directory");
        }
        return configFile;
    }
}

