/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.maven_plugin.mojo;

import dev.logchange.maven_plugin.util.Dir;
import dev.logchange.maven_plugin.util.GitKeep;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="init", defaultPhase=LifecyclePhase.NONE)
public class InitProjectMojo
extends AbstractMojo {
    @Parameter(defaultValue="changelog", property="inputDir")
    private String inputDir;
    @Parameter(defaultValue="unreleased", property="unreleasedVersionDir")
    private String unreleasedVersionDir;
    @Parameter(defaultValue="CHANGELOG.md", property="outputFile")
    private String outputFile;

    public void execute() {
        this.getLog().info((CharSequence)"Initialize project for logchange-maven-plugin");
        this.createEmptyChangelogFile(this.outputFile);
        this.executeInit(this.inputDir, this.unreleasedVersionDir);
        this.getLog().info((CharSequence)"Initialize project successful");
    }

    public void executeInit(String inputDir, String unreleasedVersionDir) {
        Dir.of(this.getLog(), inputDir).create();
        Dir.of(this.getLog(), inputDir + "/" + unreleasedVersionDir).create();
        GitKeep.of(this.getLog(), inputDir + "/" + unreleasedVersionDir + "/").create();
    }

    public void createEmptyChangelogFile(String path) {
        try {
            File changelog = new File(path);
            if (changelog.createNewFile()) {
                this.getLog().info((CharSequence)("Created: " + changelog.getName()));
            } else {
                this.getLog().warn((CharSequence)(changelog.getName() + " already exists."));
            }
        }
        catch (IOException e) {
            String msg = "An error occurred while creating empty changelog.";
            this.getLog().error((CharSequence)msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }
}

