/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.infrastructure.persistance.config;

import dev.logchange.core.application.config.ConfigRepository;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.format.yml.config.YMLConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;

public class FileConfigRepository
implements ConfigRepository {
    private static final Logger log = Logger.getLogger(FileConfigRepository.class.getName());
    private final File configFile;

    @Override
    public Config find() {
        return YMLConfig.of(this.getConfigInputStream(this.configFile)).to();
    }

    @Override
    public void save(Config config) {
        String content = YMLConfig.of(config).toYMLString();
        try (OutputStream os = Files.newOutputStream(this.configFile.toPath(), new OpenOption[0]);
             PrintWriter out = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
            out.println(content);
        }
        catch (IOException e) {
            String message = "Could not save config to file: " + this.configFile + " because: " + e.getMessage();
            log.severe(message);
            throw new IllegalArgumentException(message);
        }
    }

    private InputStream getConfigInputStream(File entryFile) {
        try {
            return new FileInputStream(entryFile);
        }
        catch (FileNotFoundException e) {
            String message = "Cannot find entry file: " + entryFile.getName();
            log.severe(message);
            throw new IllegalArgumentException(message);
        }
    }

    public FileConfigRepository(File configFile) {
        this.configFile = configFile;
    }
}

