/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.infrastructure.persistance.changelog;

import dev.logchange.core.application.changelog.repository.VersionSummaryRepository;
import dev.logchange.core.domain.changelog.model.version.ChangelogVersion;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.format.md.MDMeta;
import dev.logchange.core.format.md.changelog.version.MDChangelogVersion;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;

public class FileVersionSummaryRepository
implements VersionSummaryRepository {
    private static final Logger log = Logger.getLogger(FileVersionSummaryRepository.class.getName());
    private final File inputDirectory;
    private final Config config;

    @Override
    public void save(ChangelogVersion version) {
        String meta = new MDMeta().toMD();
        String md = new MDChangelogVersion(this.config, version).toMD();
        String outputFilePath = this.inputDirectory.getAbsolutePath() + "/" + version.getVersion().getDirName() + "/version-summary.md";
        File outputFile = new File(outputFilePath);
        try (OutputStream os = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);
             PrintWriter out = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
            out.println(meta + md);
        }
        catch (IOException e) {
            String message = "Could not save changelog to file: " + outputFilePath + " because: " + e.getMessage();
            log.severe(message);
            throw new IllegalArgumentException(message);
        }
    }

    public FileVersionSummaryRepository(File inputDirectory, Config config) {
        this.inputDirectory = inputDirectory;
        this.config = config;
    }
}

