/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.config.labels;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryType;
import dev.logchange.core.domain.config.model.labels.TypesLabels;
import dev.logchange.core.format.yml.config.labels.YMLNumberOfChangesLabels;
import java.util.logging.Logger;

public class YMLTypesLabels {
    private static final Logger log = Logger.getLogger(YMLTypesLabels.class.getName());
    public static final YMLTypesLabels EMPTY = YMLTypesLabels.builder().build();
    @JsonProperty(index=1)
    public String added;
    @JsonProperty(index=2)
    public String changed;
    @JsonProperty(index=3)
    public String deprecated;
    @JsonProperty(index=4)
    public String removed;
    @JsonProperty(index=5)
    public String fixed;
    @JsonProperty(index=6)
    public String security;
    @JsonProperty(value="dependency_update", index=7)
    public String dependencyUpdate;
    @JsonProperty(index=8)
    public String other;
    @JsonProperty(value="number_of_changes", index=9)
    public YMLNumberOfChangesLabels numberOfChanges;

    public static YMLTypesLabels of(TypesLabels types) {
        return YMLTypesLabels.builder().added(types.getType(ChangelogEntryType.ADDED)).changed(types.getType(ChangelogEntryType.CHANGED)).deprecated(types.getType(ChangelogEntryType.DEPRECATED)).removed(types.getType(ChangelogEntryType.REMOVED)).fixed(types.getType(ChangelogEntryType.FIXED)).security(types.getType(ChangelogEntryType.SECURITY)).dependencyUpdate(types.getType(ChangelogEntryType.DEPENDENCY_UPDATE)).other(types.getType(ChangelogEntryType.SECURITY)).numberOfChanges(YMLNumberOfChangesLabels.of(types.getNumberOfChanges())).build();
    }

    @JsonAnySetter
    public void anySetter(String key, Object value) {
        log.warning("Unknown property: " + key + " with value " + value);
    }

    public TypesLabels to() {
        return TypesLabels.builder().added(this.added).changed(this.changed).deprecated(this.deprecated).removed(this.removed).fixed(this.fixed).security(this.security).dependencyUpdate(this.dependencyUpdate).other(this.other).numberOfChanges(this.getNumberOfChanges().to()).build();
    }

    public YMLNumberOfChangesLabels getNumberOfChanges() {
        if (this.numberOfChanges != null) {
            return this.numberOfChanges;
        }
        return YMLNumberOfChangesLabels.EMPTY;
    }

    public static YMLTypesLabelsBuilder builder() {
        return new YMLTypesLabelsBuilder();
    }

    public YMLTypesLabels() {
    }

    public YMLTypesLabels(String added, String changed, String deprecated, String removed, String fixed, String security, String dependencyUpdate, String other, YMLNumberOfChangesLabels numberOfChanges) {
        this.added = added;
        this.changed = changed;
        this.deprecated = deprecated;
        this.removed = removed;
        this.fixed = fixed;
        this.security = security;
        this.dependencyUpdate = dependencyUpdate;
        this.other = other;
        this.numberOfChanges = numberOfChanges;
    }

    public static class YMLTypesLabelsBuilder {
        private String added;
        private String changed;
        private String deprecated;
        private String removed;
        private String fixed;
        private String security;
        private String dependencyUpdate;
        private String other;
        private YMLNumberOfChangesLabels numberOfChanges;

        YMLTypesLabelsBuilder() {
        }

        @JsonProperty(index=1)
        public YMLTypesLabelsBuilder added(String added) {
            this.added = added;
            return this;
        }

        @JsonProperty(index=2)
        public YMLTypesLabelsBuilder changed(String changed) {
            this.changed = changed;
            return this;
        }

        @JsonProperty(index=3)
        public YMLTypesLabelsBuilder deprecated(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        @JsonProperty(index=4)
        public YMLTypesLabelsBuilder removed(String removed) {
            this.removed = removed;
            return this;
        }

        @JsonProperty(index=5)
        public YMLTypesLabelsBuilder fixed(String fixed) {
            this.fixed = fixed;
            return this;
        }

        @JsonProperty(index=6)
        public YMLTypesLabelsBuilder security(String security) {
            this.security = security;
            return this;
        }

        @JsonProperty(value="dependency_update", index=7)
        public YMLTypesLabelsBuilder dependencyUpdate(String dependencyUpdate) {
            this.dependencyUpdate = dependencyUpdate;
            return this;
        }

        @JsonProperty(index=8)
        public YMLTypesLabelsBuilder other(String other) {
            this.other = other;
            return this;
        }

        @JsonProperty(value="number_of_changes", index=9)
        public YMLTypesLabelsBuilder numberOfChanges(YMLNumberOfChangesLabels numberOfChanges) {
            this.numberOfChanges = numberOfChanges;
            return this;
        }

        public YMLTypesLabels build() {
            return new YMLTypesLabels(this.added, this.changed, this.deprecated, this.removed, this.fixed, this.security, this.dependencyUpdate, this.other, this.numberOfChanges);
        }

        public String toString() {
            return "YMLTypesLabels.YMLTypesLabelsBuilder(added=" + this.added + ", changed=" + this.changed + ", deprecated=" + this.deprecated + ", removed=" + this.removed + ", fixed=" + this.fixed + ", security=" + this.security + ", dependencyUpdate=" + this.dependencyUpdate + ", other=" + this.other + ", numberOfChanges=" + this.numberOfChanges + ")";
        }
    }
}

