/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.config.labels;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.logchange.core.domain.config.model.labels.ConfigurationLabels;
import dev.logchange.core.format.yml.config.labels.YMLConfigurationActionLabels;
import java.util.logging.Logger;

public class YMLConfigurationLabels {
    private static final Logger log = Logger.getLogger(YMLConfigurationLabels.class.getName());
    public static final YMLConfigurationLabels EMPTY = YMLConfigurationLabels.builder().build();
    @JsonProperty(index=0)
    public String heading;
    @JsonProperty(index=1)
    public String type;
    @JsonProperty(index=2)
    public YMLConfigurationActionLabels actions;
    @JsonProperty(value="with_default_value", index=3)
    public String withDefaultValue;
    @JsonProperty(index=4)
    public String description;

    public static YMLConfigurationLabels of(ConfigurationLabels configuration) {
        return YMLConfigurationLabels.builder().heading(configuration.getHeading()).type(configuration.getType()).actions(YMLConfigurationActionLabels.of(configuration.getActions())).withDefaultValue(configuration.getWithDefaultValue()).description(configuration.getDescription()).build();
    }

    @JsonAnySetter
    public void anySetter(String key, Object value) {
        log.warning("Unknown property: " + key + " with value " + value);
    }

    public ConfigurationLabels to() {
        return ConfigurationLabels.builder().heading(this.heading).type(this.type).actions(this.getActions().to()).withDefaultValue(this.withDefaultValue).description(this.description).build();
    }

    public YMLConfigurationActionLabels getActions() {
        if (this.actions != null) {
            return this.actions;
        }
        return YMLConfigurationActionLabels.EMPTY;
    }

    public static YMLConfigurationLabelsBuilder builder() {
        return new YMLConfigurationLabelsBuilder();
    }

    public YMLConfigurationLabels() {
    }

    public YMLConfigurationLabels(String heading, String type, YMLConfigurationActionLabels actions, String withDefaultValue, String description) {
        this.heading = heading;
        this.type = type;
        this.actions = actions;
        this.withDefaultValue = withDefaultValue;
        this.description = description;
    }

    public static class YMLConfigurationLabelsBuilder {
        private String heading;
        private String type;
        private YMLConfigurationActionLabels actions;
        private String withDefaultValue;
        private String description;

        YMLConfigurationLabelsBuilder() {
        }

        @JsonProperty(index=0)
        public YMLConfigurationLabelsBuilder heading(String heading) {
            this.heading = heading;
            return this;
        }

        @JsonProperty(index=1)
        public YMLConfigurationLabelsBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(index=2)
        public YMLConfigurationLabelsBuilder actions(YMLConfigurationActionLabels actions) {
            this.actions = actions;
            return this;
        }

        @JsonProperty(value="with_default_value", index=3)
        public YMLConfigurationLabelsBuilder withDefaultValue(String withDefaultValue) {
            this.withDefaultValue = withDefaultValue;
            return this;
        }

        @JsonProperty(index=4)
        public YMLConfigurationLabelsBuilder description(String description) {
            this.description = description;
            return this;
        }

        public YMLConfigurationLabels build() {
            return new YMLConfigurationLabels(this.heading, this.type, this.actions, this.withDefaultValue, this.description);
        }

        public String toString() {
            return "YMLConfigurationLabels.YMLConfigurationLabelsBuilder(heading=" + this.heading + ", type=" + this.type + ", actions=" + this.actions + ", withDefaultValue=" + this.withDefaultValue + ", description=" + this.description + ")";
        }
    }
}

