/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.domain.config.model.Heading;
import dev.logchange.core.domain.config.model.labels.Labels;
import dev.logchange.core.format.yml.ObjectMapperProvider;
import dev.logchange.core.format.yml.config.YMLChangelog;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;

public class YMLConfig {
    private static final Logger log = Logger.getLogger(YMLConfig.class.getName());
    private static final String YML_HEADING = "# This file configures logchange tool \ud83c\udf33 \ud83e\ude93 => \ud83e\udeb5 \n# Visit https://github.com/logchange/logchange and leave a star \ud83c\udf1f \n# More info about configuration you can find https://github.com/logchange/logchange#configuration \n";
    @JsonProperty(index=0)
    public YMLChangelog changelog;

    public static YMLConfig of(InputStream input) {
        ObjectMapper mapper = ObjectMapperProvider.get();
        return (YMLConfig)mapper.readValue(input, YMLConfig.class);
    }

    public static YMLConfig of(Config config) {
        return YMLConfig.builder().changelog(YMLChangelog.of(config)).build();
    }

    public String toYMLString() {
        StringWriter stringWriter = new StringWriter();
        ObjectMapperProvider.get().createGenerator((Writer)stringWriter).writeObject((Object)this);
        return YML_HEADING + stringWriter;
    }

    @JsonAnySetter
    public void anySetter(String key, Object value) {
        log.warning("Unknown property: " + key + " with value " + value);
    }

    public Config to() {
        return Config.builder().heading(this.toHeading()).labels(this.toLabels()).build();
    }

    private Labels toLabels() {
        if (this.changelog == null) {
            return Labels.EMPTY;
        }
        return this.changelog.toLabels();
    }

    private Heading toHeading() {
        if (this.changelog == null) {
            return Heading.EMPTY;
        }
        return this.changelog.toHeading();
    }

    public static YMLConfigBuilder builder() {
        return new YMLConfigBuilder();
    }

    public YMLConfig() {
    }

    public YMLConfig(YMLChangelog changelog) {
        this.changelog = changelog;
    }

    public static class YMLConfigBuilder {
        private YMLChangelog changelog;

        YMLConfigBuilder() {
        }

        @JsonProperty(index=0)
        public YMLConfigBuilder changelog(YMLChangelog changelog) {
            this.changelog = changelog;
            return this;
        }

        public YMLConfig build() {
            return new YMLConfig(this.changelog);
        }

        public String toString() {
            return "YMLConfig.YMLConfigBuilder(changelog=" + this.changelog + ")";
        }
    }
}

