/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.config;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.domain.config.model.Heading;
import dev.logchange.core.domain.config.model.labels.Labels;
import dev.logchange.core.format.yml.config.labels.YMLLabels;
import java.util.logging.Logger;

public class YMLChangelog {
    private static final Logger log = Logger.getLogger(YMLChangelog.class.getName());
    @JsonProperty(index=0)
    public String heading;
    @JsonProperty(index=1)
    public YMLLabels labels;

    public static YMLChangelog of(Config config) {
        return YMLChangelog.builder().heading(config.getHeading().getValue()).labels(YMLLabels.of(config.getLabels())).build();
    }

    @JsonAnySetter
    public void anySetter(String key, Object value) {
        log.warning("Unknown property: " + key + " with value " + value);
    }

    public Labels toLabels() {
        if (this.labels == null) {
            return Labels.EMPTY;
        }
        return this.labels.to();
    }

    public Heading toHeading() {
        if (this.heading == null) {
            return Heading.EMPTY;
        }
        return Heading.of(this.heading);
    }

    public static YMLChangelogBuilder builder() {
        return new YMLChangelogBuilder();
    }

    public YMLChangelog() {
    }

    public YMLChangelog(String heading, YMLLabels labels) {
        this.heading = heading;
        this.labels = labels;
    }

    public static class YMLChangelogBuilder {
        private String heading;
        private YMLLabels labels;

        YMLChangelogBuilder() {
        }

        @JsonProperty(index=0)
        public YMLChangelogBuilder heading(String heading) {
            this.heading = heading;
            return this;
        }

        @JsonProperty(index=1)
        public YMLChangelogBuilder labels(YMLLabels labels) {
            this.labels = labels;
            return this;
        }

        public YMLChangelog build() {
            return new YMLChangelog(this.heading, this.labels);
        }

        public String toString() {
            return "YMLChangelog.YMLChangelogBuilder(heading=" + this.heading + ", labels=" + this.labels + ")";
        }
    }
}

