/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.changelog.entry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryType;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public enum YMLChangelogEntryType {
    ADDED("added"),
    CHANGED("changed"),
    DEPRECATED("deprecated"),
    REMOVED("removed"),
    FIXED("fixed"),
    SECURITY("security"),
    DEPENDENCY_UPDATE("dependency_update"),
    OTHER("other");

    private static final Logger log;
    private final String type;

    static YMLChangelogEntryType of(ChangelogEntryType type) {
        switch (type) {
            case ADDED: {
                return ADDED;
            }
            case CHANGED: {
                return CHANGED;
            }
            case DEPRECATED: {
                return DEPRECATED;
            }
            case REMOVED: {
                return REMOVED;
            }
            case FIXED: {
                return FIXED;
            }
            case SECURITY: {
                return SECURITY;
            }
            case DEPENDENCY_UPDATE: {
                return DEPENDENCY_UPDATE;
            }
            case OTHER: {
                return OTHER;
            }
        }
        String message = "Converting YMLChangelogEntryType failed";
        log.severe(message);
        throw new IllegalArgumentException(message);
    }

    ChangelogEntryType to() {
        switch (this) {
            case ADDED: {
                return ChangelogEntryType.ADDED;
            }
            case CHANGED: {
                return ChangelogEntryType.CHANGED;
            }
            case DEPRECATED: {
                return ChangelogEntryType.DEPRECATED;
            }
            case REMOVED: {
                return ChangelogEntryType.REMOVED;
            }
            case FIXED: {
                return ChangelogEntryType.FIXED;
            }
            case SECURITY: {
                return ChangelogEntryType.SECURITY;
            }
            case DEPENDENCY_UPDATE: {
                return ChangelogEntryType.DEPENDENCY_UPDATE;
            }
            case OTHER: {
                return ChangelogEntryType.OTHER;
            }
        }
        String message = "Converting ChangelogEntryType failed";
        log.severe(message);
        throw new IllegalArgumentException(message);
    }

    @JsonCreator
    public static YMLChangelogEntryType of(String name) {
        return Arrays.stream(YMLChangelogEntryType.values()).filter(value -> value.getType().equals(name)).findFirst().orElseThrow(() -> {
            String availableType = Arrays.stream(YMLChangelogEntryType.values()).map(YMLChangelogEntryType::getType).collect(Collectors.joining(", "));
            String message = "Cannot match YMLChangelogEntryType for string: " + name + " - Available types: [" + availableType + "].";
            log.severe(message);
            return new IllegalArgumentException(message);
        });
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    private YMLChangelogEntryType(String type) {
        this.type = type;
    }

    static {
        log = Logger.getLogger(YMLChangelogEntryType.class.getName());
    }
}

