/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.changelog.entry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfigurationAction;
import java.util.Arrays;
import java.util.logging.Logger;

public enum YMLChangelogEntryConfigurationAction {
    ADD("add"),
    UPDATE("update"),
    DELETE("delete");

    private static final Logger log;
    private final String action;

    ChangelogEntryConfigurationAction to() {
        switch (this) {
            case ADD: {
                return ChangelogEntryConfigurationAction.ADD;
            }
            case UPDATE: {
                return ChangelogEntryConfigurationAction.UPDATE;
            }
            case DELETE: {
                return ChangelogEntryConfigurationAction.DELETE;
            }
        }
        String message = "Converting ChangelogEntryConfigurationAction failed";
        log.severe(message);
        throw new IllegalArgumentException(message);
    }

    static YMLChangelogEntryConfigurationAction of(ChangelogEntryConfigurationAction action) {
        switch (action) {
            case ADD: {
                return ADD;
            }
            case UPDATE: {
                return UPDATE;
            }
            case DELETE: {
                return DELETE;
            }
        }
        String message = "Converting YMLChangelogEntryConfigurationAction failed";
        log.severe(message);
        throw new IllegalArgumentException(message);
    }

    @JsonCreator
    public static YMLChangelogEntryConfigurationAction of(String name) {
        return Arrays.stream(YMLChangelogEntryConfigurationAction.values()).filter(value -> value.getAction().equals(name)).findFirst().orElseThrow(() -> {
            String message = "Cannot match YMLChangelogEntryConfigurationAction for string: " + name;
            log.severe(message);
            return new IllegalArgumentException(message);
        });
    }

    @JsonValue
    public String getAction() {
        return this.action;
    }

    private YMLChangelogEntryConfigurationAction(String action) {
        this.action = action;
    }

    static {
        log = Logger.getLogger(YMLChangelogEntryConfigurationAction.class.getName());
    }
}

