/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.md.changelog.entry;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntry;
import dev.logchange.core.format.md.MD;
import dev.logchange.core.format.md.changelog.entry.MDChangelogEntryAuthors;
import dev.logchange.core.format.md.changelog.entry.MDChangelogEntryIssues;
import dev.logchange.core.format.md.changelog.entry.MDChangelogEntryLinks;
import dev.logchange.core.format.md.changelog.entry.MDChangelogEntryMergeRequests;
import dev.logchange.md.list.MarkdownLists;
import java.util.HashMap;
import org.apache.commons.text.StringSubstitutor;

public class MDChangelogEntry
implements MD {
    private static final String entryFormat = "${title} ${merge_requests} ${issues} ${links} ${authors}";
    private final ChangelogEntry entry;
    private final MDChangelogEntryMergeRequests mdMergeRequests;
    private final MDChangelogEntryIssues mdIssues;
    private final MDChangelogEntryLinks mdLinks;
    private final MDChangelogEntryAuthors mdAuthors;

    public MDChangelogEntry(ChangelogEntry entry) {
        this.entry = entry;
        this.mdMergeRequests = new MDChangelogEntryMergeRequests(entry.getMergeRequests());
        this.mdIssues = new MDChangelogEntryIssues(entry.getIssues());
        this.mdLinks = new MDChangelogEntryLinks(entry.getLinks());
        this.mdAuthors = new MDChangelogEntryAuthors(entry.getAuthors());
    }

    public String toString() {
        return MarkdownLists.unorderedListItem((Object)this.getEntry());
    }

    private String getEntry() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("title", this.entry.getTitle().getValue());
        valuesMap.put("merge_requests", this.mdMergeRequests.toMD());
        valuesMap.put("issues", this.mdIssues.toMD());
        valuesMap.put("links", this.mdLinks.toMD());
        valuesMap.put("authors", this.mdAuthors.toMD());
        StringSubstitutor sub = new StringSubstitutor(valuesMap);
        return sub.replace(entryFormat).replaceAll("\\s{2,}", " ");
    }
}

