/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.changelog.model.entry;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryType;
import java.util.logging.Logger;

public enum ChangesXMLEntryType {
    ADD("add", 1),
    FIX("fix", 2),
    UPDATE("update", 3),
    REMOVE("remove", 4);

    private static final Logger log;
    private final String type;
    private final Integer order;

    public static ChangesXMLEntryType getXmlTypeFromMarkdownEntryType(ChangelogEntryType markdownEntryType) {
        switch (markdownEntryType) {
            case ADDED: {
                return ADD;
            }
            case CHANGED: 
            case FIXED: {
                return FIX;
            }
            case DEPRECATED: 
            case SECURITY: 
            case DEPENDENCY_UPDATE: 
            case OTHER: {
                return UPDATE;
            }
            case REMOVED: {
                return REMOVE;
            }
        }
        log.severe("Wrong change type: " + (Object)((Object)markdownEntryType));
        throw new IllegalArgumentException("Wrong change type");
    }

    public String getType() {
        return this.type;
    }

    public Integer getOrder() {
        return this.order;
    }

    private ChangesXMLEntryType(String type, Integer order) {
        this.type = type;
        this.order = order;
    }

    static {
        log = Logger.getLogger(ChangesXMLEntryType.class.getName());
    }
}

