/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.changelog.model.entry;

public enum ChangelogEntryConfigurationAction {
    ADD("add", "Added", 1),
    UPDATE("update", "Updated", 2),
    DELETE("delete", "Deleted", 3);

    private final String action;
    @Deprecated
    private final String displayText;
    private final Integer order;

    public static ChangelogEntryConfigurationAction from(String orderNumber) {
        for (ChangelogEntryConfigurationAction type : ChangelogEntryConfigurationAction.values()) {
            if (!type.getOrder().toString().equals(orderNumber)) continue;
            return type;
        }
        throw new IllegalArgumentException("Incorrect type!");
    }

    public String toString() {
        return this.order + ". " + this.action;
    }

    public String getAction() {
        return this.action;
    }

    @Deprecated
    public String getDisplayText() {
        return this.displayText;
    }

    public Integer getOrder() {
        return this.order;
    }

    private ChangelogEntryConfigurationAction(String action, String displayText, Integer order) {
        this.action = action;
        this.displayText = displayText;
        this.order = order;
    }
}

