/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.domain.changelog.model.entry;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryAuthor;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfiguration;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryLink;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryMergeRequest;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryTitle;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ChangelogEntry {
    private final ChangelogEntryTitle title;
    private final ChangelogEntryType type;
    private final List<ChangelogEntryMergeRequest> mergeRequests;
    private final List<Long> issues;
    private final List<ChangelogEntryLink> links;
    private final List<ChangelogEntryAuthor> authors;
    private final List<String> importantNotes;
    private final List<ChangelogEntryConfiguration> configurations;

    public static ChangelogEntryBuilder builder() {
        return new ChangelogEntryBuilder();
    }

    public ChangelogEntryTitle getTitle() {
        return this.title;
    }

    public ChangelogEntryType getType() {
        return this.type;
    }

    public List<ChangelogEntryMergeRequest> getMergeRequests() {
        return this.mergeRequests;
    }

    public List<Long> getIssues() {
        return this.issues;
    }

    public List<ChangelogEntryLink> getLinks() {
        return this.links;
    }

    public List<ChangelogEntryAuthor> getAuthors() {
        return this.authors;
    }

    public List<String> getImportantNotes() {
        return this.importantNotes;
    }

    public List<ChangelogEntryConfiguration> getConfigurations() {
        return this.configurations;
    }

    public String toString() {
        return "ChangelogEntry(title=" + this.getTitle() + ", type=" + (Object)((Object)this.getType()) + ", mergeRequests=" + this.getMergeRequests() + ", issues=" + this.getIssues() + ", links=" + this.getLinks() + ", authors=" + this.getAuthors() + ", importantNotes=" + this.getImportantNotes() + ", configurations=" + this.getConfigurations() + ")";
    }

    private ChangelogEntry(ChangelogEntryTitle title, ChangelogEntryType type, List<ChangelogEntryMergeRequest> mergeRequests, List<Long> issues, List<ChangelogEntryLink> links, List<ChangelogEntryAuthor> authors, List<String> importantNotes, List<ChangelogEntryConfiguration> configurations) {
        this.title = title;
        this.type = type;
        this.mergeRequests = mergeRequests;
        this.issues = issues;
        this.links = links;
        this.authors = authors;
        this.importantNotes = importantNotes;
        this.configurations = configurations;
    }

    public static class ChangelogEntryBuilder {
        private ChangelogEntryTitle title;
        private ChangelogEntryType type;
        private ArrayList<ChangelogEntryMergeRequest> mergeRequests;
        private ArrayList<Long> issues;
        private ArrayList<ChangelogEntryLink> links;
        private ArrayList<ChangelogEntryAuthor> authors;
        private ArrayList<String> importantNotes;
        private ArrayList<ChangelogEntryConfiguration> configurations;

        ChangelogEntryBuilder() {
        }

        public ChangelogEntryBuilder title(ChangelogEntryTitle title) {
            this.title = title;
            return this;
        }

        public ChangelogEntryBuilder type(ChangelogEntryType type) {
            this.type = type;
            return this;
        }

        public ChangelogEntryBuilder mergeRequest(ChangelogEntryMergeRequest mergeRequest) {
            if (this.mergeRequests == null) {
                this.mergeRequests = new ArrayList();
            }
            this.mergeRequests.add(mergeRequest);
            return this;
        }

        public ChangelogEntryBuilder mergeRequests(Collection<? extends ChangelogEntryMergeRequest> mergeRequests) {
            if (mergeRequests == null) {
                throw new NullPointerException("mergeRequests cannot be null");
            }
            if (this.mergeRequests == null) {
                this.mergeRequests = new ArrayList();
            }
            this.mergeRequests.addAll(mergeRequests);
            return this;
        }

        public ChangelogEntryBuilder clearMergeRequests() {
            if (this.mergeRequests != null) {
                this.mergeRequests.clear();
            }
            return this;
        }

        public ChangelogEntryBuilder issue(Long issue) {
            if (this.issues == null) {
                this.issues = new ArrayList();
            }
            this.issues.add(issue);
            return this;
        }

        public ChangelogEntryBuilder issues(Collection<? extends Long> issues) {
            if (issues == null) {
                throw new NullPointerException("issues cannot be null");
            }
            if (this.issues == null) {
                this.issues = new ArrayList();
            }
            this.issues.addAll(issues);
            return this;
        }

        public ChangelogEntryBuilder clearIssues() {
            if (this.issues != null) {
                this.issues.clear();
            }
            return this;
        }

        public ChangelogEntryBuilder link(ChangelogEntryLink link) {
            if (this.links == null) {
                this.links = new ArrayList();
            }
            this.links.add(link);
            return this;
        }

        public ChangelogEntryBuilder links(Collection<? extends ChangelogEntryLink> links) {
            if (links == null) {
                throw new NullPointerException("links cannot be null");
            }
            if (this.links == null) {
                this.links = new ArrayList();
            }
            this.links.addAll(links);
            return this;
        }

        public ChangelogEntryBuilder clearLinks() {
            if (this.links != null) {
                this.links.clear();
            }
            return this;
        }

        public ChangelogEntryBuilder author(ChangelogEntryAuthor author) {
            if (this.authors == null) {
                this.authors = new ArrayList();
            }
            this.authors.add(author);
            return this;
        }

        public ChangelogEntryBuilder authors(Collection<? extends ChangelogEntryAuthor> authors) {
            if (authors == null) {
                throw new NullPointerException("authors cannot be null");
            }
            if (this.authors == null) {
                this.authors = new ArrayList();
            }
            this.authors.addAll(authors);
            return this;
        }

        public ChangelogEntryBuilder clearAuthors() {
            if (this.authors != null) {
                this.authors.clear();
            }
            return this;
        }

        public ChangelogEntryBuilder importantNote(String importantNote) {
            if (this.importantNotes == null) {
                this.importantNotes = new ArrayList();
            }
            this.importantNotes.add(importantNote);
            return this;
        }

        public ChangelogEntryBuilder importantNotes(Collection<? extends String> importantNotes) {
            if (importantNotes == null) {
                throw new NullPointerException("importantNotes cannot be null");
            }
            if (this.importantNotes == null) {
                this.importantNotes = new ArrayList();
            }
            this.importantNotes.addAll(importantNotes);
            return this;
        }

        public ChangelogEntryBuilder clearImportantNotes() {
            if (this.importantNotes != null) {
                this.importantNotes.clear();
            }
            return this;
        }

        public ChangelogEntryBuilder configuration(ChangelogEntryConfiguration configuration) {
            if (this.configurations == null) {
                this.configurations = new ArrayList();
            }
            this.configurations.add(configuration);
            return this;
        }

        public ChangelogEntryBuilder configurations(Collection<? extends ChangelogEntryConfiguration> configurations) {
            if (configurations == null) {
                throw new NullPointerException("configurations cannot be null");
            }
            if (this.configurations == null) {
                this.configurations = new ArrayList();
            }
            this.configurations.addAll(configurations);
            return this;
        }

        public ChangelogEntryBuilder clearConfigurations() {
            if (this.configurations != null) {
                this.configurations.clear();
            }
            return this;
        }

        public ChangelogEntry build() {
            List<Object> configurations;
            List<Object> importantNotes;
            List<Object> authors;
            List<Object> links;
            List<Object> issues;
            List<Object> mergeRequests;
            switch (this.mergeRequests == null ? 0 : this.mergeRequests.size()) {
                case 0: {
                    mergeRequests = Collections.emptyList();
                    break;
                }
                case 1: {
                    mergeRequests = Collections.singletonList(this.mergeRequests.get(0));
                    break;
                }
                default: {
                    mergeRequests = Collections.unmodifiableList(new ArrayList<ChangelogEntryMergeRequest>(this.mergeRequests));
                }
            }
            switch (this.issues == null ? 0 : this.issues.size()) {
                case 0: {
                    issues = Collections.emptyList();
                    break;
                }
                case 1: {
                    issues = Collections.singletonList(this.issues.get(0));
                    break;
                }
                default: {
                    issues = Collections.unmodifiableList(new ArrayList<Long>(this.issues));
                }
            }
            switch (this.links == null ? 0 : this.links.size()) {
                case 0: {
                    links = Collections.emptyList();
                    break;
                }
                case 1: {
                    links = Collections.singletonList(this.links.get(0));
                    break;
                }
                default: {
                    links = Collections.unmodifiableList(new ArrayList<ChangelogEntryLink>(this.links));
                }
            }
            switch (this.authors == null ? 0 : this.authors.size()) {
                case 0: {
                    authors = Collections.emptyList();
                    break;
                }
                case 1: {
                    authors = Collections.singletonList(this.authors.get(0));
                    break;
                }
                default: {
                    authors = Collections.unmodifiableList(new ArrayList<ChangelogEntryAuthor>(this.authors));
                }
            }
            switch (this.importantNotes == null ? 0 : this.importantNotes.size()) {
                case 0: {
                    importantNotes = Collections.emptyList();
                    break;
                }
                case 1: {
                    importantNotes = Collections.singletonList(this.importantNotes.get(0));
                    break;
                }
                default: {
                    importantNotes = Collections.unmodifiableList(new ArrayList<String>(this.importantNotes));
                }
            }
            switch (this.configurations == null ? 0 : this.configurations.size()) {
                case 0: {
                    configurations = Collections.emptyList();
                    break;
                }
                case 1: {
                    configurations = Collections.singletonList(this.configurations.get(0));
                    break;
                }
                default: {
                    configurations = Collections.unmodifiableList(new ArrayList<ChangelogEntryConfiguration>(this.configurations));
                }
            }
            return new ChangelogEntry(this.title, this.type, mergeRequests, issues, links, authors, importantNotes, configurations);
        }

        public String toString() {
            return "ChangelogEntry.ChangelogEntryBuilder(title=" + this.title + ", type=" + (Object)((Object)this.type) + ", mergeRequests=" + this.mergeRequests + ", issues=" + this.issues + ", links=" + this.links + ", authors=" + this.authors + ", importantNotes=" + this.importantNotes + ", configurations=" + this.configurations + ")";
        }
    }
}

