/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.application.changelog.service.generate;

import dev.logchange.core.application.changelog.repository.ChangelogRepository;
import dev.logchange.core.domain.changelog.command.GenerateChangelogUseCase;
import dev.logchange.core.domain.changelog.model.Changelog;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryAuthor;
import dev.logchange.core.domain.changelog.model.entry.ChangesXMLEntryType;
import dev.logchange.core.domain.changelog.model.version.ChangelogVersion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Body;
import org.apache.maven.plugins.changes.model.ChangesDocument;
import org.apache.maven.plugins.changes.model.Release;

public class GenerateChangelogXMLService
implements GenerateChangelogUseCase {
    private final ChangelogRepository changelogRepository;

    public GenerateChangelogXMLService(ChangelogRepository changelogRepository) {
        this.changelogRepository = changelogRepository;
    }

    @Override
    public void handle(GenerateChangelogUseCase.GenerateChangelogCommand command) {
        Changelog changelog = this.changelogRepository.findXML();
        ChangesDocument changesDocument = this.mapChangelogToChangesDocument(changelog);
        this.changelogRepository.saveXML(changesDocument);
    }

    private ChangesDocument mapChangelogToChangesDocument(Changelog changelog) {
        ChangesDocument changesDocument = new ChangesDocument();
        List<Release> changelogReleases = this.mapVersionsToReleases(changelog.getVersions().getVersions());
        Body changesBody = new Body();
        changelogReleases.forEach(arg_0 -> ((Body)changesBody).addRelease(arg_0));
        changesDocument.setBody(changesBody);
        return changesDocument;
    }

    private List<Release> mapVersionsToReleases(List<ChangelogVersion> versions) {
        ArrayList<Release> releases = new ArrayList<Release>();
        for (ChangelogVersion version : versions) {
            if (version.getEntries().isEmpty()) continue;
            Release release = new Release();
            release.setVersion(version.getVersion().getValue());
            release.setDateRelease(this.getReleasedDate(version));
            ArrayList actions = new ArrayList();
            version.getEntries().forEach(changelogEntry -> {
                Action action = new Action();
                action.setDev(this.authorsToString(changelogEntry.getAuthors()));
                String type = ChangesXMLEntryType.getXmlTypeFromMarkdownEntryType(changelogEntry.getType()).getType();
                action.setType(type);
                action.setAction(changelogEntry.getTitle().getValue());
                actions.add(action);
            });
            release.setActions(actions);
            releases.add(release);
        }
        return releases;
    }

    private String getReleasedDate(ChangelogVersion version) {
        if (version.getReleaseDateTime() == null) {
            return "unreleased";
        }
        return version.getReleaseDateTime().toLocalDate().toString();
    }

    private String authorsToString(List<ChangelogEntryAuthor> authors) {
        StringBuilder builder = new StringBuilder();
        Iterator<ChangelogEntryAuthor> iterator = authors.iterator();
        while (iterator.hasNext()) {
            ChangelogEntryAuthor author = iterator.next();
            String authorName = "";
            if (author.getNick() != null && !author.getNick().isEmpty()) {
                authorName = author.getNick();
            } else if (author.getName() != null && !author.getName().isEmpty()) {
                authorName = author.getName();
            }
            builder.append(authorName);
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }
}

