/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.infrastructure.persistance.changelog;

import dev.logchange.core.application.changelog.repository.ChangelogEntryRepository;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntry;
import dev.logchange.core.format.yml.changelog.entry.YMLChangelogEntry;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class FileChangelogEntryRepository
implements ChangelogEntryRepository {
    private final File outputFile;

    public FileChangelogEntryRepository(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public void save(ChangelogEntry entry) {
        String content = YMLChangelogEntry.of(entry).toYMLString();
        try (OutputStream os = Files.newOutputStream(this.outputFile.toPath(), new OpenOption[0]);
             PrintWriter out = new PrintWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8));){
            out.println(content);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not save changelog entry to file: " + this.outputFile + " because: " + e.getMessage());
        }
    }
}

