/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.changelog.entry;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfiguration;
import dev.logchange.core.format.yml.changelog.entry.YMLChangelogEntryConfigurationAction;
import java.util.Comparator;

public class YMLChangelogEntryConfiguration
implements Comparable<YMLChangelogEntryConfiguration> {
    @JsonProperty(index=0)
    public String type;
    @JsonProperty(index=1)
    public YMLChangelogEntryConfigurationAction action;
    @JsonProperty(index=2)
    public String key;
    @JsonProperty(value="default_value", index=3)
    public String defaultValue;
    @JsonProperty(index=4)
    public String description;
    @JsonProperty(value="more_info", index=5)
    public String moreInfo;

    @JsonAnySetter
    public void anySetter(String key, Object value) {
    }

    @Override
    public int compareTo(YMLChangelogEntryConfiguration o) {
        return Comparator.comparing(YMLChangelogEntryConfiguration::getType).thenComparing(YMLChangelogEntryConfiguration::getAction).thenComparing(YMLChangelogEntryConfiguration::getKey).compare(this, o);
    }

    ChangelogEntryConfiguration to() {
        return ChangelogEntryConfiguration.of(this.type, this.action.to(), this.key, this.defaultValue, this.description, this.moreInfo);
    }

    static YMLChangelogEntryConfiguration of(ChangelogEntryConfiguration configuration) {
        return YMLChangelogEntryConfiguration.builder().type(configuration.getType()).action(YMLChangelogEntryConfigurationAction.of(configuration.getAction())).key(configuration.getKey()).defaultValue(configuration.getDefaultValue()).description(configuration.getDescription()).moreInfo(configuration.getMoreInfo()).build();
    }

    public static YMLChangelogEntryConfigurationBuilder builder() {
        return new YMLChangelogEntryConfigurationBuilder();
    }

    public String getType() {
        return this.type;
    }

    public YMLChangelogEntryConfigurationAction getAction() {
        return this.action;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMoreInfo() {
        return this.moreInfo;
    }

    @JsonProperty(index=0)
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(index=1)
    public void setAction(YMLChangelogEntryConfigurationAction action) {
        this.action = action;
    }

    @JsonProperty(index=2)
    public void setKey(String key) {
        this.key = key;
    }

    @JsonProperty(value="default_value", index=3)
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @JsonProperty(index=4)
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="more_info", index=5)
    public void setMoreInfo(String moreInfo) {
        this.moreInfo = moreInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YMLChangelogEntryConfiguration)) {
            return false;
        }
        YMLChangelogEntryConfiguration other = (YMLChangelogEntryConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        YMLChangelogEntryConfigurationAction this$action = this.getAction();
        YMLChangelogEntryConfigurationAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$moreInfo = this.getMoreInfo();
        String other$moreInfo = other.getMoreInfo();
        return !(this$moreInfo == null ? other$moreInfo != null : !this$moreInfo.equals(other$moreInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof YMLChangelogEntryConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        YMLChangelogEntryConfigurationAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $moreInfo = this.getMoreInfo();
        result = result * 59 + ($moreInfo == null ? 43 : $moreInfo.hashCode());
        return result;
    }

    public String toString() {
        return "YMLChangelogEntryConfiguration(type=" + this.getType() + ", action=" + (Object)((Object)this.getAction()) + ", key=" + this.getKey() + ", defaultValue=" + this.getDefaultValue() + ", description=" + this.getDescription() + ", moreInfo=" + this.getMoreInfo() + ")";
    }

    public YMLChangelogEntryConfiguration() {
    }

    public YMLChangelogEntryConfiguration(String type, YMLChangelogEntryConfigurationAction action, String key, String defaultValue, String description, String moreInfo) {
        this.type = type;
        this.action = action;
        this.key = key;
        this.defaultValue = defaultValue;
        this.description = description;
        this.moreInfo = moreInfo;
    }

    public static class YMLChangelogEntryConfigurationBuilder {
        private String type;
        private YMLChangelogEntryConfigurationAction action;
        private String key;
        private String defaultValue;
        private String description;
        private String moreInfo;

        YMLChangelogEntryConfigurationBuilder() {
        }

        @JsonProperty(index=0)
        public YMLChangelogEntryConfigurationBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(index=1)
        public YMLChangelogEntryConfigurationBuilder action(YMLChangelogEntryConfigurationAction action) {
            this.action = action;
            return this;
        }

        @JsonProperty(index=2)
        public YMLChangelogEntryConfigurationBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="default_value", index=3)
        public YMLChangelogEntryConfigurationBuilder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @JsonProperty(index=4)
        public YMLChangelogEntryConfigurationBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="more_info", index=5)
        public YMLChangelogEntryConfigurationBuilder moreInfo(String moreInfo) {
            this.moreInfo = moreInfo;
            return this;
        }

        public YMLChangelogEntryConfiguration build() {
            return new YMLChangelogEntryConfiguration(this.type, this.action, this.key, this.defaultValue, this.description, this.moreInfo);
        }

        public String toString() {
            return "YMLChangelogEntryConfiguration.YMLChangelogEntryConfigurationBuilder(type=" + this.type + ", action=" + (Object)((Object)this.action) + ", key=" + this.key + ", defaultValue=" + this.defaultValue + ", description=" + this.description + ", moreInfo=" + this.moreInfo + ")";
        }
    }
}

