/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.md.changelog.version;

import dev.logchange.core.domain.changelog.model.version.Version;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.format.md.MD;
import dev.logchange.core.format.md.changelog.Configurable;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import net.steppschuh.markdowngenerator.text.heading.Heading;
import org.apache.commons.text.StringSubstitutor;

class MDChangelogVersionHeading
extends Configurable
implements MD {
    public static final String RELEASE_DATE_FORMAT = "yyyy-MM-dd";
    private static final String versionHeaderFormat = "[${version}]${releaseData}";
    private static final String releaseDatePrefix = " - ";
    private final Version version;
    private final OffsetDateTime releaseDateTime;

    public MDChangelogVersionHeading(Version version, OffsetDateTime releaseDateTime, Config config) {
        super(config);
        this.version = version;
        this.releaseDateTime = releaseDateTime;
    }

    public String toString() {
        return this.getVersionHeading() + "\n\n";
    }

    private Heading getVersionHeading() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        if (this.version.isUnreleased()) {
            valuesMap.put("version", this.getConfig().getLabels().getUnreleased());
        } else {
            valuesMap.put("version", this.version.getValue());
        }
        valuesMap.put("releaseData", this.getVersionDate());
        StringSubstitutor sub = new StringSubstitutor(valuesMap);
        return new Heading((Object)sub.replace(versionHeaderFormat), 2);
    }

    private String getVersionDate() {
        if (this.releaseDateTime == null) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(RELEASE_DATE_FORMAT);
        return releaseDatePrefix + formatter.format(this.releaseDateTime);
    }
}

