/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.md.changelog.entry;

import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryAuthor;
import dev.logchange.core.format.md.MD;
import java.util.HashMap;
import net.steppschuh.markdowngenerator.link.Link;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;

class MDChangelogEntryAuthor
implements MD {
    private static final String authorFormat = "(${author})";
    private static final String AT = "@";
    private static final String LINK = "LINK";
    private final ChangelogEntryAuthor author;

    MDChangelogEntryAuthor(ChangelogEntryAuthor author) {
        this.author = author;
    }

    public String toString() {
        return this.getAuthor();
    }

    private String getAuthor() {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        valuesMap.put("author", (this.getAuthorName() + " " + this.getAuthorNick() + " " + this.getLinkWhenNameEmpty()).trim());
        StringSubstitutor sub = new StringSubstitutor(valuesMap);
        return sub.replace(authorFormat);
    }

    private String getAuthorName() {
        if (StringUtils.isNotBlank((CharSequence)this.author.getUrl()) && StringUtils.isNotBlank((CharSequence)this.author.getName())) {
            return new Link((Object)this.author.getName(), this.author.getUrl()).toString();
        }
        return StringUtils.defaultString((String)this.author.getName());
    }

    private String getAuthorNick() {
        if (StringUtils.isBlank((CharSequence)this.author.getNick())) {
            return "";
        }
        return AT + this.author.getNick();
    }

    private String getLinkWhenNameEmpty() {
        if (StringUtils.isNotBlank((CharSequence)this.author.getName())) {
            return "";
        }
        if (StringUtils.isNotBlank((CharSequence)this.author.getUrl())) {
            return new Link((Object)LINK, this.author.getUrl()).toString();
        }
        return "";
    }
}

