/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.config.labels;

import de.beosign.snakeyamlanno.property.YamlAnySetter;
import de.beosign.snakeyamlanno.property.YamlProperty;
import dev.logchange.core.domain.config.model.labels.ConfigurationLabels;
import dev.logchange.core.format.yml.config.labels.YMLConfigurationActionLabels;

public class YMLConfigurationLabels {
    public static final YMLConfigurationLabels EMPTY = YMLConfigurationLabels.builder().build();
    @YamlProperty(key="heading", order=0)
    public String heading;
    @YamlProperty(key="type", order=-1)
    public String type;
    @YamlProperty(key="actions", order=-2)
    public YMLConfigurationActionLabels actions;
    @YamlProperty(key="with_default_value", order=-3)
    public String withDefaultValue;
    @YamlProperty(key="description", order=-4)
    public String description;

    public static YMLConfigurationLabels of(ConfigurationLabels configuration) {
        return YMLConfigurationLabels.builder().heading(configuration.getHeading()).type(configuration.getType()).actions(YMLConfigurationActionLabels.of(configuration.getActions())).withDefaultValue(configuration.getWithDefaultValue()).description(configuration.getDescription()).build();
    }

    @YamlAnySetter
    public void anySetter(String key, Object value) {
        System.out.println("Unknown property: " + key + " with value " + value);
    }

    public ConfigurationLabels to() {
        return ConfigurationLabels.builder().heading(this.heading).type(this.type).actions(this.getActions().to()).withDefaultValue(this.withDefaultValue).description(this.description).build();
    }

    public YMLConfigurationActionLabels getActions() {
        if (this.actions != null) {
            return this.actions;
        }
        return YMLConfigurationActionLabels.EMPTY;
    }

    public static YMLConfigurationLabelsBuilder builder() {
        return new YMLConfigurationLabelsBuilder();
    }

    public YMLConfigurationLabels() {
    }

    public YMLConfigurationLabels(String heading, String type, YMLConfigurationActionLabels actions, String withDefaultValue, String description) {
        this.heading = heading;
        this.type = type;
        this.actions = actions;
        this.withDefaultValue = withDefaultValue;
        this.description = description;
    }

    public static class YMLConfigurationLabelsBuilder {
        private String heading;
        private String type;
        private YMLConfigurationActionLabels actions;
        private String withDefaultValue;
        private String description;

        YMLConfigurationLabelsBuilder() {
        }

        public YMLConfigurationLabelsBuilder heading(String heading) {
            this.heading = heading;
            return this;
        }

        public YMLConfigurationLabelsBuilder type(String type) {
            this.type = type;
            return this;
        }

        public YMLConfigurationLabelsBuilder actions(YMLConfigurationActionLabels actions) {
            this.actions = actions;
            return this;
        }

        public YMLConfigurationLabelsBuilder withDefaultValue(String withDefaultValue) {
            this.withDefaultValue = withDefaultValue;
            return this;
        }

        public YMLConfigurationLabelsBuilder description(String description) {
            this.description = description;
            return this;
        }

        public YMLConfigurationLabels build() {
            return new YMLConfigurationLabels(this.heading, this.type, this.actions, this.withDefaultValue, this.description);
        }

        public String toString() {
            return "YMLConfigurationLabels.YMLConfigurationLabelsBuilder(heading=" + this.heading + ", type=" + this.type + ", actions=" + this.actions + ", withDefaultValue=" + this.withDefaultValue + ", description=" + this.description + ")";
        }
    }
}

