/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.config;

import de.beosign.snakeyamlanno.property.YamlAnySetter;
import de.beosign.snakeyamlanno.property.YamlProperty;
import dev.logchange.core.domain.config.model.Config;
import dev.logchange.core.domain.config.model.Heading;
import dev.logchange.core.domain.config.model.labels.Labels;
import dev.logchange.core.format.yml.config.labels.YMLLabels;

public class YMLChangelog {
    @YamlProperty(key="heading", order=0)
    public String heading;
    @YamlProperty(key="labels", order=-1)
    public YMLLabels labels;

    public static YMLChangelog of(Config config) {
        return YMLChangelog.builder().heading(config.getHeading().getValue()).labels(YMLLabels.of(config.getLabels())).build();
    }

    @YamlAnySetter
    public void anySetter(String key, Object value) {
        System.out.println("Unknown property: " + key + " with value " + value);
    }

    public Labels getLabels() {
        if (this.labels == null) {
            return Labels.EMPTY;
        }
        return this.labels.to();
    }

    public Heading getHeading() {
        if (this.heading == null) {
            return Heading.EMPTY;
        }
        return Heading.of(this.heading);
    }

    public static YMLChangelogBuilder builder() {
        return new YMLChangelogBuilder();
    }

    public YMLChangelog() {
    }

    public YMLChangelog(String heading, YMLLabels labels) {
        this.heading = heading;
        this.labels = labels;
    }

    public static class YMLChangelogBuilder {
        private String heading;
        private YMLLabels labels;

        YMLChangelogBuilder() {
        }

        public YMLChangelogBuilder heading(String heading) {
            this.heading = heading;
            return this;
        }

        public YMLChangelogBuilder labels(YMLLabels labels) {
            this.labels = labels;
            return this;
        }

        public YMLChangelog build() {
            return new YMLChangelog(this.heading, this.labels);
        }

        public String toString() {
            return "YMLChangelog.YMLChangelogBuilder(heading=" + this.heading + ", labels=" + this.labels + ")";
        }
    }
}

