/*
 * Decompiled with CFR 0.152.
 */
package dev.logchange.core.format.yml.changelog.entry;

import de.beosign.snakeyamlanno.constructor.AnnotationAwareConstructor;
import de.beosign.snakeyamlanno.property.YamlAnySetter;
import de.beosign.snakeyamlanno.property.YamlProperty;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntry;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryAuthor;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryConfiguration;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryLink;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryMergeRequest;
import dev.logchange.core.domain.changelog.model.entry.ChangelogEntryTitle;
import dev.logchange.core.format.yml.YamlProvider;
import dev.logchange.core.format.yml.changelog.entry.YMLChangelogEntryAuthor;
import dev.logchange.core.format.yml.changelog.entry.YMLChangelogEntryConfiguration;
import dev.logchange.core.format.yml.changelog.entry.YMLChangelogEntryLink;
import dev.logchange.core.format.yml.changelog.entry.YMLChangelogEntryType;
import dev.logchange.core.format.yml.changelog.entry.YMLChangelogEntryTypeConverter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class YMLChangelogEntry {
    private static final String YML_HEADING = "# This file is used by logchange tool to generate CHANGELOG.md \ud83c\udf33 \ud83e\ude93 => \ud83e\udeb5 \n# Visit https://github.com/logchange/logchange and leave a star \ud83c\udf1f \n# More info about configuration you can find https://github.com/logchange/logchange#yaml-format \u2b05\ufe0f\u2b05 \ufe0f\n";
    @YamlProperty(key="title", order=0)
    public String title;
    @YamlProperty(key="authors", order=-1)
    public List<YMLChangelogEntryAuthor> authors;
    @YamlProperty(key="merge_requests", order=-2)
    public List<Long> mergeRequests;
    @YamlProperty(key="issues", order=-3)
    public List<Long> issues;
    @YamlProperty(key="links", order=-4)
    public List<YMLChangelogEntryLink> links;
    @YamlProperty(key="type", order=-5, converter=YMLChangelogEntryTypeConverter.class)
    public YMLChangelogEntryType type;
    @YamlProperty(key="important_notes", order=-6)
    public List<String> importantNotes;
    @YamlProperty(key="configurations", order=-7)
    public List<YMLChangelogEntryConfiguration> configurations;

    public static YMLChangelogEntry of(InputStream input) {
        Yaml yaml = new Yaml((BaseConstructor)new AnnotationAwareConstructor(YMLChangelogEntry.class));
        return (YMLChangelogEntry)yaml.load(input);
    }

    public String toYMLString() {
        return YML_HEADING + YamlProvider.get().dumpAsMap((Object)this);
    }

    @YamlAnySetter
    public void anySetter(String key, Object value) {
        System.out.println("Unknown property: " + key + " with value " + value);
    }

    public ChangelogEntry to() {
        return ChangelogEntry.builder().title(ChangelogEntryTitle.of(this.title)).type(this.type.to()).mergeRequests(this.mergeRequests()).issues(this.issues()).links(this.links()).authors(this.authors()).importantNotes(this.importantNotes()).configurations(this.changelogEntryConfiguration()).build();
    }

    private List<ChangelogEntryMergeRequest> mergeRequests() {
        if (this.mergeRequests == null) {
            return Collections.emptyList();
        }
        return this.mergeRequests.stream().map(ChangelogEntryMergeRequest::of).collect(Collectors.toList());
    }

    private List<Long> issues() {
        if (this.issues == null) {
            return Collections.emptyList();
        }
        return this.issues;
    }

    private List<ChangelogEntryLink> links() {
        if (this.links == null) {
            return Collections.emptyList();
        }
        return this.links.stream().map(YMLChangelogEntryLink::to).collect(Collectors.toList());
    }

    private List<ChangelogEntryAuthor> authors() {
        if (this.authors == null) {
            return Collections.emptyList();
        }
        return this.authors.stream().map(YMLChangelogEntryAuthor::to).collect(Collectors.toList());
    }

    private List<String> importantNotes() {
        if (this.importantNotes == null) {
            return Collections.emptyList();
        }
        return this.importantNotes;
    }

    private List<ChangelogEntryConfiguration> changelogEntryConfiguration() {
        if (this.configurations == null) {
            return Collections.emptyList();
        }
        return this.configurations.stream().map(YMLChangelogEntryConfiguration::to).collect(Collectors.toList());
    }

    public static YMLChangelogEntry of(ChangelogEntry entry) {
        return YMLChangelogEntry.builder().title(entry.getTitle().getValue()).authors(entry.getAuthors().stream().map(YMLChangelogEntryAuthor::of).collect(Collectors.toList())).mergeRequests(entry.getMergeRequests().stream().map(ChangelogEntryMergeRequest::getValue).collect(Collectors.toList())).issues(entry.getIssues()).links(entry.getLinks().stream().map(YMLChangelogEntryLink::of).collect(Collectors.toList())).type(YMLChangelogEntryType.of(entry.getType())).importantNotes(entry.getImportantNotes()).configurations(entry.getConfigurations().stream().map(YMLChangelogEntryConfiguration::of).collect(Collectors.toList())).build();
    }

    public static YMLChangelogEntryBuilder builder() {
        return new YMLChangelogEntryBuilder();
    }

    public String getTitle() {
        return this.title;
    }

    public List<YMLChangelogEntryAuthor> getAuthors() {
        return this.authors;
    }

    public List<Long> getMergeRequests() {
        return this.mergeRequests;
    }

    public List<Long> getIssues() {
        return this.issues;
    }

    public List<YMLChangelogEntryLink> getLinks() {
        return this.links;
    }

    public YMLChangelogEntryType getType() {
        return this.type;
    }

    public List<String> getImportantNotes() {
        return this.importantNotes;
    }

    public List<YMLChangelogEntryConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAuthors(List<YMLChangelogEntryAuthor> authors) {
        this.authors = authors;
    }

    public void setMergeRequests(List<Long> mergeRequests) {
        this.mergeRequests = mergeRequests;
    }

    public void setIssues(List<Long> issues) {
        this.issues = issues;
    }

    public void setLinks(List<YMLChangelogEntryLink> links) {
        this.links = links;
    }

    public void setType(YMLChangelogEntryType type) {
        this.type = type;
    }

    public void setImportantNotes(List<String> importantNotes) {
        this.importantNotes = importantNotes;
    }

    public void setConfigurations(List<YMLChangelogEntryConfiguration> configurations) {
        this.configurations = configurations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YMLChangelogEntry)) {
            return false;
        }
        YMLChangelogEntry other = (YMLChangelogEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<YMLChangelogEntryAuthor> this$authors = this.getAuthors();
        List<YMLChangelogEntryAuthor> other$authors = other.getAuthors();
        if (this$authors == null ? other$authors != null : !((Object)this$authors).equals(other$authors)) {
            return false;
        }
        List<Long> this$mergeRequests = this.getMergeRequests();
        List<Long> other$mergeRequests = other.getMergeRequests();
        if (this$mergeRequests == null ? other$mergeRequests != null : !((Object)this$mergeRequests).equals(other$mergeRequests)) {
            return false;
        }
        List<Long> this$issues = this.getIssues();
        List<Long> other$issues = other.getIssues();
        if (this$issues == null ? other$issues != null : !((Object)this$issues).equals(other$issues)) {
            return false;
        }
        List<YMLChangelogEntryLink> this$links = this.getLinks();
        List<YMLChangelogEntryLink> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        YMLChangelogEntryType this$type = this.getType();
        YMLChangelogEntryType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<String> this$importantNotes = this.getImportantNotes();
        List<String> other$importantNotes = other.getImportantNotes();
        if (this$importantNotes == null ? other$importantNotes != null : !((Object)this$importantNotes).equals(other$importantNotes)) {
            return false;
        }
        List<YMLChangelogEntryConfiguration> this$configurations = this.getConfigurations();
        List<YMLChangelogEntryConfiguration> other$configurations = other.getConfigurations();
        return !(this$configurations == null ? other$configurations != null : !((Object)this$configurations).equals(other$configurations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof YMLChangelogEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<YMLChangelogEntryAuthor> $authors = this.getAuthors();
        result = result * 59 + ($authors == null ? 43 : ((Object)$authors).hashCode());
        List<Long> $mergeRequests = this.getMergeRequests();
        result = result * 59 + ($mergeRequests == null ? 43 : ((Object)$mergeRequests).hashCode());
        List<Long> $issues = this.getIssues();
        result = result * 59 + ($issues == null ? 43 : ((Object)$issues).hashCode());
        List<YMLChangelogEntryLink> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        YMLChangelogEntryType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<String> $importantNotes = this.getImportantNotes();
        result = result * 59 + ($importantNotes == null ? 43 : ((Object)$importantNotes).hashCode());
        List<YMLChangelogEntryConfiguration> $configurations = this.getConfigurations();
        result = result * 59 + ($configurations == null ? 43 : ((Object)$configurations).hashCode());
        return result;
    }

    public String toString() {
        return "YMLChangelogEntry(title=" + this.getTitle() + ", authors=" + this.getAuthors() + ", mergeRequests=" + this.getMergeRequests() + ", issues=" + this.getIssues() + ", links=" + this.getLinks() + ", type=" + (Object)((Object)this.getType()) + ", importantNotes=" + this.getImportantNotes() + ", configurations=" + this.getConfigurations() + ")";
    }

    public YMLChangelogEntry() {
    }

    public YMLChangelogEntry(String title, List<YMLChangelogEntryAuthor> authors, List<Long> mergeRequests, List<Long> issues, List<YMLChangelogEntryLink> links, YMLChangelogEntryType type, List<String> importantNotes, List<YMLChangelogEntryConfiguration> configurations) {
        this.title = title;
        this.authors = authors;
        this.mergeRequests = mergeRequests;
        this.issues = issues;
        this.links = links;
        this.type = type;
        this.importantNotes = importantNotes;
        this.configurations = configurations;
    }

    public static class YMLChangelogEntryBuilder {
        private String title;
        private ArrayList<YMLChangelogEntryAuthor> authors;
        private ArrayList<Long> mergeRequests;
        private ArrayList<Long> issues;
        private ArrayList<YMLChangelogEntryLink> links;
        private YMLChangelogEntryType type;
        private ArrayList<String> importantNotes;
        private ArrayList<YMLChangelogEntryConfiguration> configurations;

        YMLChangelogEntryBuilder() {
        }

        public YMLChangelogEntryBuilder title(String title) {
            this.title = title;
            return this;
        }

        public YMLChangelogEntryBuilder author(YMLChangelogEntryAuthor author) {
            if (this.authors == null) {
                this.authors = new ArrayList();
            }
            this.authors.add(author);
            return this;
        }

        public YMLChangelogEntryBuilder authors(Collection<? extends YMLChangelogEntryAuthor> authors) {
            if (authors == null) {
                throw new NullPointerException("authors cannot be null");
            }
            if (this.authors == null) {
                this.authors = new ArrayList();
            }
            this.authors.addAll(authors);
            return this;
        }

        public YMLChangelogEntryBuilder clearAuthors() {
            if (this.authors != null) {
                this.authors.clear();
            }
            return this;
        }

        public YMLChangelogEntryBuilder mergeRequest(Long mergeRequest) {
            if (this.mergeRequests == null) {
                this.mergeRequests = new ArrayList();
            }
            this.mergeRequests.add(mergeRequest);
            return this;
        }

        public YMLChangelogEntryBuilder mergeRequests(Collection<? extends Long> mergeRequests) {
            if (mergeRequests == null) {
                throw new NullPointerException("mergeRequests cannot be null");
            }
            if (this.mergeRequests == null) {
                this.mergeRequests = new ArrayList();
            }
            this.mergeRequests.addAll(mergeRequests);
            return this;
        }

        public YMLChangelogEntryBuilder clearMergeRequests() {
            if (this.mergeRequests != null) {
                this.mergeRequests.clear();
            }
            return this;
        }

        public YMLChangelogEntryBuilder issue(Long issue) {
            if (this.issues == null) {
                this.issues = new ArrayList();
            }
            this.issues.add(issue);
            return this;
        }

        public YMLChangelogEntryBuilder issues(Collection<? extends Long> issues) {
            if (issues == null) {
                throw new NullPointerException("issues cannot be null");
            }
            if (this.issues == null) {
                this.issues = new ArrayList();
            }
            this.issues.addAll(issues);
            return this;
        }

        public YMLChangelogEntryBuilder clearIssues() {
            if (this.issues != null) {
                this.issues.clear();
            }
            return this;
        }

        public YMLChangelogEntryBuilder link(YMLChangelogEntryLink link) {
            if (this.links == null) {
                this.links = new ArrayList();
            }
            this.links.add(link);
            return this;
        }

        public YMLChangelogEntryBuilder links(Collection<? extends YMLChangelogEntryLink> links) {
            if (links == null) {
                throw new NullPointerException("links cannot be null");
            }
            if (this.links == null) {
                this.links = new ArrayList();
            }
            this.links.addAll(links);
            return this;
        }

        public YMLChangelogEntryBuilder clearLinks() {
            if (this.links != null) {
                this.links.clear();
            }
            return this;
        }

        public YMLChangelogEntryBuilder type(YMLChangelogEntryType type) {
            this.type = type;
            return this;
        }

        public YMLChangelogEntryBuilder importantNote(String importantNote) {
            if (this.importantNotes == null) {
                this.importantNotes = new ArrayList();
            }
            this.importantNotes.add(importantNote);
            return this;
        }

        public YMLChangelogEntryBuilder importantNotes(Collection<? extends String> importantNotes) {
            if (importantNotes == null) {
                throw new NullPointerException("importantNotes cannot be null");
            }
            if (this.importantNotes == null) {
                this.importantNotes = new ArrayList();
            }
            this.importantNotes.addAll(importantNotes);
            return this;
        }

        public YMLChangelogEntryBuilder clearImportantNotes() {
            if (this.importantNotes != null) {
                this.importantNotes.clear();
            }
            return this;
        }

        public YMLChangelogEntryBuilder configuration(YMLChangelogEntryConfiguration configuration) {
            if (this.configurations == null) {
                this.configurations = new ArrayList();
            }
            this.configurations.add(configuration);
            return this;
        }

        public YMLChangelogEntryBuilder configurations(Collection<? extends YMLChangelogEntryConfiguration> configurations) {
            if (configurations == null) {
                throw new NullPointerException("configurations cannot be null");
            }
            if (this.configurations == null) {
                this.configurations = new ArrayList();
            }
            this.configurations.addAll(configurations);
            return this;
        }

        public YMLChangelogEntryBuilder clearConfigurations() {
            if (this.configurations != null) {
                this.configurations.clear();
            }
            return this;
        }

        public YMLChangelogEntry build() {
            List<YMLChangelogEntryConfiguration> configurations;
            List<String> importantNotes;
            List<YMLChangelogEntryLink> links;
            List<Long> issues;
            List<Long> mergeRequests;
            List<YMLChangelogEntryAuthor> authors;
            switch (this.authors == null ? 0 : this.authors.size()) {
                case 0: {
                    authors = Collections.emptyList();
                    break;
                }
                case 1: {
                    authors = Collections.singletonList(this.authors.get(0));
                    break;
                }
                default: {
                    authors = Collections.unmodifiableList(new ArrayList<YMLChangelogEntryAuthor>(this.authors));
                }
            }
            switch (this.mergeRequests == null ? 0 : this.mergeRequests.size()) {
                case 0: {
                    mergeRequests = Collections.emptyList();
                    break;
                }
                case 1: {
                    mergeRequests = Collections.singletonList(this.mergeRequests.get(0));
                    break;
                }
                default: {
                    mergeRequests = Collections.unmodifiableList(new ArrayList<Long>(this.mergeRequests));
                }
            }
            switch (this.issues == null ? 0 : this.issues.size()) {
                case 0: {
                    issues = Collections.emptyList();
                    break;
                }
                case 1: {
                    issues = Collections.singletonList(this.issues.get(0));
                    break;
                }
                default: {
                    issues = Collections.unmodifiableList(new ArrayList<Long>(this.issues));
                }
            }
            switch (this.links == null ? 0 : this.links.size()) {
                case 0: {
                    links = Collections.emptyList();
                    break;
                }
                case 1: {
                    links = Collections.singletonList(this.links.get(0));
                    break;
                }
                default: {
                    links = Collections.unmodifiableList(new ArrayList<YMLChangelogEntryLink>(this.links));
                }
            }
            switch (this.importantNotes == null ? 0 : this.importantNotes.size()) {
                case 0: {
                    importantNotes = Collections.emptyList();
                    break;
                }
                case 1: {
                    importantNotes = Collections.singletonList(this.importantNotes.get(0));
                    break;
                }
                default: {
                    importantNotes = Collections.unmodifiableList(new ArrayList<String>(this.importantNotes));
                }
            }
            switch (this.configurations == null ? 0 : this.configurations.size()) {
                case 0: {
                    configurations = Collections.emptyList();
                    break;
                }
                case 1: {
                    configurations = Collections.singletonList(this.configurations.get(0));
                    break;
                }
                default: {
                    configurations = Collections.unmodifiableList(new ArrayList<YMLChangelogEntryConfiguration>(this.configurations));
                }
            }
            return new YMLChangelogEntry(this.title, authors, mergeRequests, issues, links, this.type, importantNotes, configurations);
        }

        public String toString() {
            return "YMLChangelogEntry.YMLChangelogEntryBuilder(title=" + this.title + ", authors=" + this.authors + ", mergeRequests=" + this.mergeRequests + ", issues=" + this.issues + ", links=" + this.links + ", type=" + (Object)((Object)this.type) + ", importantNotes=" + this.importantNotes + ", configurations=" + this.configurations + ")";
        }
    }
}

